/*
 * Decompiled with CFR 0.152.
 */
package pch;

import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.PixelGrabber;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import paintchat.MgLine;
import pch.PCHProgress;

public class PCHCanvas
extends Canvas
implements Runnable,
WindowListener {
    public static final String STR_VERSION = "(C)\u3057\u3043\u3061\u3083\u3093 PCHCanvas v1.02";
    public static boolean isWin = true;
    private boolean live = true;
    private boolean liveDraw = false;
    private boolean liveLoad = false;
    private boolean isSuspend = false;
    private Applet applet;
    private int[][] i_off = null;
    private int imW = 0;
    private int imH = 0;
    private Image image = null;
    private Graphics primary;
    private Graphics back;
    private int[] b_bk = null;
    private int b_bk_w = 0;
    private int b_bk_h = 0;
    private int scaleX = 0;
    private int scaleY = 0;
    private int scale = 1;
    private int visit0 = 255;
    private int visit1 = 255;
    private MgLine mg_b = null;
    private int speed = 10;
    private URL urlPCH = null;
    private int seek = 0;
    private int mark = 0;
    private int lineCount = 0;
    private MgLine[] mglines = null;
    private Thread tDraw = null;
    private Thread tLoad = null;
    private PCHProgress progress = null;
    private Point oldPo = null;

    public PCHCanvas(Applet applet, boolean bl) {
        this.enableEvents(49L);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.applet = applet;
    }

    public synchronized void addMg(MgLine mgLine) {
        if (this.mglines == null) {
            this.mglines = new MgLine[100];
        }
        this.mglines[this.lineCount++] = mgLine;
        ++this.mark;
        if (this.progress != null) {
            this.progress.drawBar();
        }
        if (this.lineCount >= this.mglines.length) {
            MgLine[] mgLineArray = new MgLine[(int)((double)this.lineCount * 1.5)];
            System.arraycopy(this.mglines, 0, mgLineArray, 0, this.mglines.length);
            this.mglines = mgLineArray;
        }
    }

    private synchronized void clearCanvas() {
        try {
            Dimension dimension;
            int n = 0xFFFFFF;
            if (this.i_off != null) {
                int n2 = this.i_off[0].length;
                if (n2 > 0) {
                    int n3 = 0;
                    while (n3 < n2) {
                        this.i_off[0][n3] = n;
                        ++n3;
                    }
                    System.arraycopy(this.i_off[0], 0, this.i_off[1], 0, n2);
                }
                Dimension dimension2 = dimension = this.applet == null ? null : this.applet.getParameter("image_canvas");
                if (dimension != null && ((String)((Object)dimension)).length() > 0) {
                    if (this.b_bk == null) {
                        Image image = this.applet.getImage(new URL(this.applet.getCodeBase(), (String)((Object)dimension)));
                        MediaTracker mediaTracker = new MediaTracker(this);
                        mediaTracker.addImage(image, 0);
                        mediaTracker.waitForID(0);
                        this.b_bk_w = image.getWidth(null);
                        this.b_bk_h = Math.min(image.getHeight(null), this.imH);
                        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.b_bk_w, image.getHeight(null), true);
                        pixelGrabber.grabPixels();
                        this.b_bk = (int[])pixelGrabber.getPixels();
                        image.flush();
                    }
                    int n4 = 0;
                    while (n4 < this.b_bk_h) {
                        System.arraycopy(this.b_bk, n4 * this.b_bk_w, this.i_off[0], n4 * this.imW, Math.min(this.b_bk_w, this.imW));
                        ++n4;
                    }
                }
            }
            Color color = new Color(n);
            if (this.back != null) {
                this.back.clearRect(0, 0, this.imW, this.imH);
                this.back.setColor(color);
                this.back.fillRect(0, 0, this.imW, this.imH);
            }
            if (this.primary != null) {
                dimension = this.getSize();
                this.primary.clearRect(0, 0, dimension.width, dimension.height);
                this.primary.setColor(color);
                this.primary.fillRect(0, 0, this.imW, this.imH);
            }
            this.repaint();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public synchronized void clearPCH() {
        this.stopLoad();
        this.setMark(0);
        this.lineCount = 0;
        int n = this.mglines.length;
        int n2 = 0;
        while (n2 < n) {
            this.mglines[n2] = null;
            ++n2;
        }
    }

    public synchronized void destroyPCH() {
        Container container = this.getParent();
        if (container instanceof Window) {
            ((Window)container).dispose();
        } else {
            container.remove(this);
        }
        this.stopLoad();
        if (this.tDraw != null) {
            this.liveDraw = false;
            this.tDraw.interrupt();
            if (this.isSuspend) {
                Thread thread = this.tDraw;
                synchronized (thread) {
                    this.tDraw.notify();
                }
            }
        }
    }

    public void error(String string) {
        try {
            if (this.image == null) {
                return;
            }
            new Font("Sans", 0, 16);
            this.back.setColor(new Color(0xCCCCFF));
            this.back.fillRect(0, 0, this.imW, this.imH);
            this.back.setColor(new Color(5263480));
            this.back.drawString(STR_VERSION, 5, 32);
            this.back.drawString(string, 5, 64);
            this.repaint();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public int getMark() {
        return this.mark;
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    public static Window getParentTop(Component component) {
        try {
            Container container = component.getParent();
            while (!(container instanceof Window)) {
                container = container.getParent();
            }
            return (Window)container;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public Dimension getPreferredSize() {
        if (this.imW != 0 && this.imH != 0) {
            return new Dimension(this.imW, this.imH);
        }
        return new Dimension(300, 300);
    }

    public int getSeek() {
        return this.seek;
    }

    public int getSpeed() {
        return this.speed;
    }

    public synchronized void loadPCH(URL uRL, int n, int n2) throws InterruptedException {
        if (uRL == null) {
            return;
        }
        this.setSize(n, n2);
        if (this.urlPCH != null && uRL.equals(this.urlPCH)) {
            this.setMark(0);
            this.setMark(-1);
            return;
        }
        this.urlPCH = uRL;
        this.stopLoad();
        this.liveLoad = true;
        Thread thread = new Thread((Runnable)this, "l");
        thread.setDaemon(true);
        thread.setPriority(1);
        this.tLoad = thread;
        thread.start();
    }

    private void m_paint(Graphics graphics) {
        try {
            if (graphics == null) {
                graphics = this.primary;
            }
            if (graphics == null) {
                return;
            }
            this.m_po(graphics, graphics.getClipBounds());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void m_po(Graphics graphics, Rectangle rectangle) {
        int n;
        if (this.mg_b == null) {
            this.mg_b = new MgLine(0);
        }
        this.mg_b.setVisit(this.visit0, this.visit1);
        Dimension dimension = this.getSize();
        if (rectangle == null) {
            rectangle = new Rectangle(dimension);
        }
        int n2 = this.scaleX * this.scale;
        int n3 = this.scaleY * this.scale;
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        int n6 = rectangle.width;
        int n7 = rectangle.width;
        int n8 = n2;
        int n9 = n3;
        int n10 = n2 + this.imW * this.scale;
        int n11 = n3 + this.imH * this.scale;
        int n12 = Math.max(n4, n8);
        int n13 = Math.max(n5, n9);
        int n14 = Math.min(n6, n10);
        int n15 = Math.min(n7, n11);
        if (n14 - n12 <= 0 || n15 - n13 <= 0) {
            return;
        }
        int n16 = 16384 / this.imW;
        int n17 = 0;
        int n18 = Math.max((n12 - n8) / this.scale, 0);
        int n19 = Math.max((n13 - n9) / this.scale, 0);
        int n20 = (n14 - n12) / this.scale;
        while ((n = Math.min(n16, (n15 - n13) / this.scale - n17)) > 0) {
            Image image = this.mg_b.makeLPic(null, this.i_off, this.imW, this.imH, n18, n19 + n17, n20, n);
            graphics.drawImage(image, n12, n13 + n17 * this.scale, n14 - n12, n * this.scale, Color.white, null);
            image.flush();
            n17 += n16;
        }
    }

    public void paint(Graphics graphics) {
        try {
            if (this.primary == null) {
                this.primary = this.getGraphics();
            }
            Graphics graphics2 = graphics;
            synchronized (graphics2) {
                this.m_paint(graphics);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public synchronized void playPCH() {
        if (this.tDraw == null || !this.liveDraw) {
            this.tDraw = new Thread((Runnable)this, "d");
            this.liveDraw = true;
            this.tDraw.setDaemon(true);
            this.tDraw.setPriority(1);
            this.tDraw.start();
        } else if (this.isSuspend) {
            Thread thread = this.tDraw;
            synchronized (thread) {
                this.tDraw.notify();
            }
        }
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        try {
            if (componentEvent.getID() == 101 && this.primary == null) {
                this.primary = this.getGraphics();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        this.processMouseMotionEvent(mouseEvent);
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        try {
            switch (mouseEvent.getID()) {
                case 501: {
                    this.oldPo = mouseEvent.getPoint();
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    break;
                }
                case 502: {
                    this.oldPo = null;
                    this.setCursor(Cursor.getDefaultCursor());
                    this.repaint();
                    break;
                }
                case 506: {
                    this.scroll(mouseEvent.getPoint(), true);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void rDraw() throws InterruptedException {
        if (this.seek == 0) {
            this.clearCanvas();
        }
        while (this.liveDraw) {
            Object object;
            if (this.seek < this.mark) {
                object = this.mglines[this.seek++];
                if (this.progress != null) {
                    this.progress.drawBar();
                }
                Graphics graphics = this.primary;
                synchronized (graphics) {
                    ((MgLine)object).draw(this, this.primary, this.back, this.i_off, this.imW, this.imH, -this.scaleX, -this.scaleY, this.scale, this.visit0, this.visit1, this.speed);
                }
            } else {
                Thread.sleep(1000L);
            }
            if (!this.isSuspend) continue;
            this.m_paint(null);
            object = this.tDraw;
            synchronized (object) {
                this.tDraw.wait();
                this.isSuspend = false;
            }
        }
    }

    private void rLoad() throws InterruptedException {
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new DataInputStream(new GZIPInputStream(this.urlPCH.openStream(), 4000));
            while (this.liveLoad) {
                MgLine mgLine = new MgLine(1);
                mgLine.setData((DataInputStream)filterInputStream);
                this.addMg(mgLine);
            }
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            this.error(iOException.getMessage());
        }
        if (filterInputStream != null) {
            try {
                filterInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void run() {
        try {
            switch (Thread.currentThread().getName().charAt(0)) {
                case 'l': {
                    this.rLoad();
                    break;
                }
                case 'd': {
                    this.rDraw();
                }
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private synchronized void scroll(Point point, boolean bl) {
        if (this.oldPo == null || this.primary == null || this.oldPo.equals(point)) {
            return;
        }
        if (this.tDraw != null && !this.isSuspend) {
            this.suspendDraw();
        }
        Graphics graphics = this.primary;
        Dimension dimension = this.getSize();
        int n = this.scaleX;
        int n2 = this.scaleY;
        int n3 = point.x - this.oldPo.x;
        int n4 = point.y - this.oldPo.y;
        if (bl) {
            n3 = -n3;
            n4 = -n4;
        }
        this.oldPo.setLocation(point);
        this.scaleX -= n3;
        this.scaleY -= n4;
        graphics.setColor(this.getBackground());
        graphics.fillRect(n * this.scale, n2 * this.scale, dimension.width * this.scale, dimension.height * this.scale);
        graphics.setColor(this.getForeground());
        graphics.drawRect(this.scaleX * this.scale, this.scaleY * this.scale, (this.imW - 1) * this.scale, (this.imH - 1) * this.scale);
    }

    public synchronized void setMark(int n) {
        int n2 = n = n < 0 || n >= this.lineCount ? this.lineCount : n;
        if (n < this.seek) {
            this.seek = 0;
            this.clearCanvas();
        }
        this.mark = n;
    }

    public void setProgress(PCHProgress pCHProgress) {
        this.progress = pCHProgress;
    }

    public synchronized void setSize(int n, int n2) {
        if (n <= 0 || n2 <= 0 || n == this.imW && n2 == this.imH) {
            return;
        }
        this.imW = n;
        this.imH = n2;
        int n3 = n * (n2 + 1);
        if (this.i_off == null || this.i_off[0].length < n3) {
            this.i_off = new int[2][n3];
        }
        this.seek = 0;
        this.clearCanvas();
    }

    public void setSpeed(int n) {
        try {
            this.speed = n;
            if (this.progress != null) {
                this.progress.repaint();
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    public synchronized void setVisit(int n, boolean bl) {
        int n2;
        if (n <= -1 || n >= 2) {
            return;
        }
        int n3 = n2 = bl ? 255 : 0;
        if (n == 0) {
            this.visit0 = n2;
        } else {
            this.visit1 = n2;
        }
        this.repaint();
    }

    public synchronized void stopLoad() {
        try {
            if (this.tLoad != null) {
                this.liveLoad = false;
                this.tLoad.join();
                this.tLoad = null;
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public void suspendDraw() {
        this.isSuspend = true;
    }

    public void setScale(int n, boolean bl) {
        int n2 = n = bl ? n : this.scale + n;
        if (n <= 0) {
            return;
        }
        if (this.tDraw != null && !this.isSuspend) {
            this.suspendDraw();
        }
        this.scale = n;
        Dimension dimension = this.getSize();
        this.scaleX = (dimension.width - this.imW * this.scale) / 2 / this.scale;
        this.scaleY = (dimension.height - this.imH * this.scale) / 2 / this.scale;
        this.repaint(0L);
    }

    public void update_(Graphics graphics) {
        this.paint(graphics);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        try {
            this.destroyPCH();
            Component[] componentArray = windowEvent.getWindow().getComponents();
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof PCHCanvas) {
                    ((PCHCanvas)componentArray[n]).destroyPCH();
                }
                ++n;
            }
            windowEvent.getWindow().dispose();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

