/*
 * Decompiled with CFR 0.152.
 */
package paintchat;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.PixelGrabber;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import paintchat.SRaster;

public class MgLine {
    public int head = 0;
    private int line_size = 1;
    private int i_color = 0;
    private int i_mask = 0;
    private int i_alpha = 255;
    private int layer = 0;
    private int layer_end = 0;
    private int mask = 110;
    private Rectangle rect;
    private short firstX = 0;
    private short firstY = 0;
    private byte[] offset;
    public static final byte M_LINE = 0;
    public static final byte M_SUISAI = 1;
    public static final byte M_TEXT = 2;
    public static final byte M_X = 5;
    public static final byte M_XX = 6;
    public static final byte M_TONE = 7;
    public static final byte M_BOKASHI = 8;
    public static final byte M_LIGHT = 9;
    public static final byte M_DARK = 10;
    public static final byte M_WHITE = 19;
    public static final byte M_RECT = 20;
    public static final byte M_FRECT = 21;
    public static final byte M_OVAL = 22;
    public static final byte M_FOVAL = 23;
    public static final byte M_RWHITE = 39;
    public static final byte M_MOVE = 40;
    public static final byte M_BRECT = 41;
    public static final byte M_ABS_LR = 42;
    public static final byte M_ABS_TB = 43;
    public static final byte M_LIE = 44;
    public static final byte M_FUSION = 45;
    public static final byte M_V_F = 60;
    public static final byte M_V_L = 61;
    public static final byte M_V_B = 62;
    public static final byte M_PASTE = -2;
    public static final byte M_DELETE = 100;
    public static final byte M_EMPTY = 101;
    public static final byte M_HEADER = 102;
    public static final byte M_ARCHIVE = 103;
    public static final byte M_PING = 104;
    public static final byte M_PAINTBBS = 105;
    public static final byte M_PRELINE = 106;
    public static final byte M_PAINTCHAT = 107;
    public static final byte M_IMAGE = 108;
    public static final byte M_OUT = 110;
    public static final byte N = 110;
    public static final byte M = 111;
    public static final byte R = 112;
    public static final byte ADD = 113;
    public static final byte SUB = 114;
    public static final byte MK_M = 1;
    public static final byte MK_S = 2;
    public static final byte MK_C = 4;
    public static final byte MK_MC = 8;
    public static final byte MK_A = 16;
    public static final byte MK_L = 32;
    private static float[] b255 = new float[256];
    private static int[][] b_arc = null;
    private static ColorModel color_model = null;
    private static SRaster[] raster = null;
    private static Image[] imBuffer = null;
    private static int[][] b_d;
    private int visit0 = 255;
    private int visit1 = 255;
    private int alpha;
    private int d_x;
    private int d_y;
    private int d_w;
    private int d_h;
    private int[] buffer_work;
    private int vWidth;
    private int vHeight;
    public Component component;
    private int userNum = 0;

    public MgLine() {
    }

    public MgLine(int n) {
        this.userNum = n;
    }

    private final int aM(int n, int n2) {
        return this.mask == 113 ? Math.min(n, n2) : (this.mask == 114 ? Math.max(n, n2) : n);
    }

    public short[] bezier(Point[] pointArray) {
        int n = pointArray.length - 1;
        int n2 = 0;
        try {
            short[] sArray = new short[600];
            int n3 = 0;
            while (n3 < 300) {
                double d = (double)n3 / 300.0;
                double d2 = 0.0;
                double d3 = 0.0;
                int n4 = 0;
                while (n4 <= n) {
                    double d4 = (double)this.kei(n, n4) * Math.pow(d, n4) * Math.pow(1.0 - d, n - n4);
                    d2 += d4 * (double)pointArray[n - n4].x;
                    d3 += d4 * (double)pointArray[n - n4].y;
                    ++n4;
                }
                short s = (short)Math.round(d2);
                short s2 = (short)Math.round(d3);
                if (n2 == 0 || sArray[n2 - 2] != s || sArray[n2 - 1] != s2) {
                    sArray[n2] = s;
                    sArray[n2 + 1] = s2;
                    n2 += 2;
                }
                ++n3;
            }
            if (n2 <= 2) {
                sArray[2] = sArray[0];
                sArray[3] = sArray[1];
                n2 = 2;
            }
            if (n2 < sArray.length) {
                short[] sArray2 = new short[n2];
                System.arraycopy(sArray, 0, sArray2, 0, n2);
                return sArray2;
            }
            return sArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void clear(Graphics graphics, int[][] nArray, int n, int n2) {
        int[] nArray2 = nArray[0];
        int n3 = 0xFFFFFF;
        int n4 = n * n2;
        int[] nArray3 = nArray2;
        synchronized (nArray2) {
            int n5 = 0;
            while (n5 < n) {
                nArray2[n5] = n3;
                ++n5;
            }
            n5 = n;
            while (n5 < n4) {
                System.arraycopy(nArray2, 0, nArray2, n5, n);
                n5 += n;
            }
            System.arraycopy(nArray2, 0, nArray[1], 0, nArray2.length);
            // ** MonitorExit[var8_8] (shouldn't be in output)
            this.d_x = 0;
            this.d_y = 0;
            this.d_w = n;
            this.d_h = n2;
            return;
        }
    }

    public void create(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.head = n;
        this.line_size = n3 <= 0 ? 1 : n3;
        this.mask = n2 == 0 ? 110 : n2;
        this.i_mask = n5 & 0xFFFFFF;
        this.i_alpha = n6 == 0 ? 255 : n6;
        this.i_color = n4 & 0xFFFFFF;
        this.layer = n7;
    }

    private final void dBuffer(Graphics graphics, Graphics graphics2, int[][] nArray, int n, int n2, int n3, int n4, int n5) {
        try {
            int n6 = this.d_x <= 1 ? 0 : this.d_x - 1;
            int n7 = this.d_y <= 1 ? 0 : this.d_y - 1;
            int n8 = this.d_w + this.line_size + 1;
            int n9 = this.d_h + this.line_size + 1;
            n8 = n8 >= n ? n - n6 : n8 - n6;
            int n10 = n9 = n9 >= n2 ? n2 - n7 : n9 - n7;
            if (n8 <= 0 || n9 <= 0 || this.vWidth < (n6 - n3) * n5 || this.vHeight < (n7 - n4) * n5) {
                return;
            }
            int[] nArray2 = b_d[this.userNum];
            int n11 = n9 + n7;
            int n12 = (n6 - n3) * n5;
            n9 = nArray2.length / n8;
            do {
                n9 = Math.min(n9, n11 - n7);
                Image image = this.makeLPic(null, nArray, n, n2, n6, n7, n8, n9);
                if (graphics != null) {
                    graphics.drawImage(image, n12, (n7 - n4) * n5, n8 * n5, n9 * n5, Color.white, null);
                }
                if (graphics2 == null) continue;
                graphics2.drawImage(image, n12, (n7 - n4) * n5, n8 * n5, n9 * n5, Color.white, null);
            } while ((n7 += n9) < n11);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    private void dFusion(int[][] nArray, int n, int n2) {
        Rectangle rectangle = new Rectangle(n, n2).intersection(this.rect);
        if (rectangle.isEmpty()) {
            return;
        }
        int n3 = rectangle.x + rectangle.width;
        int n4 = rectangle.y + rectangle.height;
        int[] nArray2 = nArray[this.layer];
        int[] nArray3 = nArray[this.layer == 0 ? 1 : 0];
        int n5 = rectangle.y;
        while (n5 < n4) {
            int n6 = n5 * n + rectangle.x;
            int n7 = rectangle.x;
            while (n7 < n3) {
                int n8 = nArray[0][n6];
                int n9 = nArray[1][n6];
                int n10 = n9 >>> 24;
                int n11 = (int)(b255[255 - n10] * (float)(n8 >>> 24));
                int n12 = n10 + n11 << 24;
                double d = n10 + n11 == 0 ? 0.0f : 255.0f / (float)(n10 + n11);
                int n13 = (int)((double)n10 * d);
                int n14 = (int)((double)n11 * d);
                int n15 = 255 - n13 - n14;
                int n16 = 16;
                while (n16 >= 0) {
                    int n17 = (int)(b255[n9 >>> n16 & 0xFF] * (float)n13) + (int)(b255[n8 >>> n16 & 0xFF] * (float)n14) + n15;
                    n17 = n17 < 0 ? 0 : (n17 > 255 ? 255 : n17);
                    n12 |= n17 << n16;
                    n16 -= 8;
                }
                nArray2[n6] = n12;
                nArray3[n6] = 0xFFFFFF;
                ++n6;
                ++n7;
            }
            ++n5;
        }
        this.d_x = rectangle.x;
        this.d_y = rectangle.y;
        this.d_w = rectangle.x + rectangle.width;
        this.d_h = rectangle.y + rectangle.height;
    }

    private void dLine(Graphics graphics, Graphics graphics2, int[][] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) throws InterruptedException {
        try {
            int n8 = Math.max(this.line_size >>> 3, 1);
            int n9 = this.firstX;
            int n10 = this.firstY;
            int n11 = this.offset.length;
            boolean bl = n6 >= 0;
            Thread thread = n6 > 0 ? Thread.currentThread() : null;
            int[] nArray2 = nArray[this.layer];
            int n12 = 0;
            while (n12 < n11) {
                float f;
                float f2;
                int n13;
                int n14;
                int n15 = n9;
                int n16 = n10;
                n9 = n15 + this.offset[n12];
                n10 = n16 + this.offset[n12 + 1];
                this.d_x = this.d_x > n9 ? n9 : this.d_x;
                this.d_y = this.d_y > n10 ? n10 : this.d_y;
                this.d_w = this.d_w < n9 ? n9 : this.d_w;
                this.d_h = this.d_h < n10 ? n10 : this.d_h;
                int n17 = n9 - n15;
                int n18 = n10 - n16;
                int n19 = n17 < 0 ? -n17 : n17;
                int n20 = n14 = n18 < 0 ? -n18 : n18;
                if (n19 >= n14) {
                    n13 = n19;
                    f2 = n17 < 0 ? -1 : 1;
                    f = n18 != 0 ? (float)n18 / (float)n19 : 0.0f;
                } else {
                    n13 = n14;
                    f = n18 < 0 ? -1 : 1;
                    f2 = n18 != 0 ? (float)n17 / (float)n14 : 0.0f;
                }
                switch (n7) {
                    case 0: {
                        int n21 = 0;
                        while (n21 <= n13) {
                            this.dPen(nArray2, n, n2, n15 + Math.round(f2 * (float)n21), n16 + Math.round(f * (float)n21));
                            ++n21;
                        }
                        break;
                    }
                    case 1: {
                        int n21 = 0;
                        while (n21 < n13) {
                            if (n21 % n8 == 0) {
                                this.dPen(nArray2, n, n2, n15 + (int)(f2 * (float)n21), n16 + (int)(f * (float)n21));
                            }
                            ++n21;
                        }
                        break;
                    }
                    case 2: {
                        int n21 = 0;
                        while (n21 < n13) {
                            if (this.line_size <= 2) {
                                graphics.fillRect(n15 + (int)(f2 * (float)n21), n16 + (int)(f * (float)n21), this.line_size, this.line_size);
                            } else {
                                graphics.fillOval(n15 + (int)(f2 * (float)n21), n16 + (int)(f * (float)n21), this.line_size, this.line_size);
                            }
                            ++n21;
                        }
                        break;
                    }
                    case 3: {
                        int n21 = 0;
                        while (n21 < n13) {
                            this.dPen(nArray2, n, n2, n15 + Math.round(f2 * (float)n21), n16 + Math.round(f * (float)n21));
                            ++n21;
                        }
                        break;
                    }
                }
                if (bl) {
                    this.dBuffer(graphics, graphics2, nArray, n, n2, n3, n4, n5);
                    this.d_x = n9;
                    this.d_y = n10;
                    this.d_w = n9;
                    this.d_h = n10;
                }
                if (thread != null) {
                    Thread.sleep(n6);
                }
                n12 += 2;
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    private void dMove(int[][] nArray, int n, int n2, int n3, int n4, int n5) {
        try {
            int n6;
            int n7 = Math.max(0, this.firstX);
            int n8 = Math.max(0, this.firstY);
            int n9 = this.firstX < 0 ? this.rect.width + this.firstX : (n6 = n7 + this.rect.width >= n ? this.rect.width - (n7 + this.rect.width - n) : this.rect.width);
            int n10 = this.firstY < 0 ? this.rect.height + this.firstY : (n8 + this.rect.height >= n2 ? this.rect.height - (n8 + this.rect.height - n2) : this.rect.height);
            int n11 = this.rect.x + (this.firstX <= 0 ? this.rect.width - n6 : 0);
            int n12 = this.rect.y + (this.firstY <= 0 ? this.rect.height - n10 : 0);
            if (n6 <= 0 || n10 <= 0 || n7 >= n || n8 >= n2) {
                return;
            }
            int n13 = n * n12 + n11;
            int n14 = n * n8 + n7;
            int n15 = n6 * n10;
            int[] nArray2 = new int[n15];
            int n16 = 0;
            while (n16 < n10) {
                System.arraycopy(nArray[this.layer], n13 + n * n16, nArray2, n6 * n16, n6);
                ++n16;
            }
            n16 = 0;
            while (n16 < n10) {
                System.arraycopy(nArray2, n6 * n16, nArray[this.layer_end], n14 + n * n16, n6);
                ++n16;
            }
            this.d_x = Math.min(n7, n11);
            this.d_y = Math.min(n8, n12);
            this.d_w = Math.max(n7, n11) + n6;
            this.d_h = Math.max(n8, n12) + n10;
            nArray2 = null;
        }
        catch (RuntimeException runtimeException) {
            System.out.println(runtimeException);
        }
    }

    private final void dPen(int[] nArray, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = this.line_size * this.line_size;
        int n7 = n * n2;
        int n8 = n4 * n + n3 - 1;
        int n9 = -1;
        int n10 = n3 - 1;
        int n11 = n4;
        switch (this.head) {
            case 0: {
                while (n5 < n6) {
                    if (++n9 >= this.line_size) {
                        n9 = 0;
                        n10 = n3;
                        ++n11;
                        n8 += n - this.line_size + 1;
                    } else {
                        ++n10;
                        ++n8;
                    }
                    if (!(this.isArc(n5) || n8 < 0 || n8 >= n7 || n10 < 0 || n10 >= n || this.isM(nArray[n8]) || this.isAm(this.i_color, nArray[n8]))) {
                        nArray[n8] = this.getAPix(nArray[n8], this.i_color);
                    }
                    ++n5;
                }
                break;
            }
            case 19: {
                while (n5 < n6) {
                    if (++n9 >= this.line_size) {
                        n9 = 0;
                        n10 = n3;
                        ++n11;
                        n8 += n - this.line_size + 1;
                    } else {
                        ++n10;
                        ++n8;
                    }
                    if (!(this.isArc(n5) || n8 < 0 || n8 >= n7 || n10 < 0 || n10 >= n || this.isM(nArray[n8]) || this.isAm(this.i_color, nArray[n8]))) {
                        nArray[n8] = this.getWPix(nArray[n8]);
                    }
                    ++n5;
                }
                break;
            }
            case 1: {
                while (n5 < n6) {
                    if (++n9 >= this.line_size) {
                        n9 = 0;
                        n10 = n3;
                        n8 += n - this.line_size + 1;
                    } else {
                        ++n10;
                        ++n8;
                    }
                    if (n8 >= 0 && n8 < n7 && n10 >= 0 && n10 < n) {
                        int n12 = nArray[n8];
                        if (!this.isArc(n5) && !this.isM(n12)) {
                            int n13 = n12 >> 24 & 0xFF;
                            int n14 = Math.max((255 - n13) / this.alpha, 1);
                            n13 = Math.min(n13 + n14, 255) << 24;
                            int n15 = 16;
                            while (n15 >= 0) {
                                int n16 = this.i_color >> n15 & 0xFF;
                                int n17 = n12 >> n15 & 0xFF;
                                int n18 = n16 - n17;
                                int n19 = n18 < 0 ? (n18 >= -this.alpha ? n17 - 1 : Math.max(n17 + n18 / this.alpha * n14, n16)) : (n18 > 0 ? (n18 <= this.alpha ? n17 + 1 : Math.min(n17 + n18 / this.alpha * n14, n16)) : (n18 = n17));
                                n13 |= this.aM(n18 < 0 ? 0 : (n18 > 255 ? 255 : n18), n17) << n15;
                                n15 -= 8;
                            }
                            nArray[n8] = n13;
                        }
                    }
                    ++n5;
                }
                break;
            }
            case 7: {
                while (n5 < n6) {
                    if (++n9 >= this.line_size) {
                        n9 = 0;
                        n10 = n3;
                        ++n11;
                        n8 += n - this.line_size + 1;
                    } else {
                        ++n10;
                        ++n8;
                    }
                    if (!(this.isArc(n5) || n8 < 0 || n8 >= n7 || n10 < 0 || n10 >= n || this.isM(nArray[n8]) || MgLine.isTone(this.alpha, n10, n11))) {
                        nArray[n8] = 0xFF000000 | this.i_color & 0xFFFFFF;
                    }
                    ++n5;
                }
                break;
            }
            case 8: {
                int n20;
                int n21;
                int n22 = Math.min(n11 + this.line_size, n2);
                int n23 = Math.min(n10 + this.line_size, n);
                n10 = Math.max(n10, 0);
                n11 = Math.max(n11, 0);
                if (n23 - n10 <= 0 || n22 - n11 <= 0) break;
                int[] nArray2 = new int[4];
                float f = Math.max((float)(255 - this.i_alpha) / 16.0f, 1.0f);
                int n24 = 0;
                int n25 = n11;
                while (n25 < n22) {
                    int n26 = n25 * n + n10;
                    int n27 = n10;
                    while (n27 < n23) {
                        if (this.isM(nArray[n26])) {
                            this.buffer_work[n24++] = nArray[n26++];
                        } else {
                            n5 = 0;
                            while (n5 < 4) {
                                int n28 = n5 << 3;
                                int n29 = nArray[n26] >>> n28 & 0xFF;
                                int n30 = 0;
                                int n31 = 0;
                                n21 = -2;
                                while (n21 <= 2) {
                                    n20 = -2;
                                    while (n20 <= 2) {
                                        int n32 = n27 + n20;
                                        int n33 = n25 + n21;
                                        if (n32 >= 0 && n32 < n && n33 >= 0 && n33 < n2) {
                                            n30 += nArray[n * n33 + n32] >>> n28 & 0xFF;
                                            ++n31;
                                        }
                                        ++n20;
                                    }
                                    ++n21;
                                }
                                nArray2[n5] = ((n29 -= (int)(((float)n29 - (float)n30 / (float)n31) / f)) < 0 ? 0 : (n29 > 255 ? 255 : n29)) << n28;
                                ++n5;
                            }
                            this.buffer_work[n24++] = nArray2[3] | nArray2[2] | nArray2[1] | nArray2[0];
                            ++n26;
                        }
                        ++n27;
                    }
                    ++n25;
                }
                n20 = n23 - n10;
                n21 = n22 - n11;
                n5 = 0;
                while (n5 < n21) {
                    System.arraycopy(this.buffer_work, n5 * n20, nArray, n * (n5 + n11) + n10, n20);
                    ++n5;
                }
                break;
            }
            case 9: 
            case 10: {
                float f = Math.max(255 - this.i_alpha, 1);
                n5 = 0;
                while (n5 < n6) {
                    if (++n9 >= this.line_size) {
                        n9 = 0;
                        n8 += n - this.line_size + 1;
                        n10 = n3;
                    } else {
                        ++n8;
                        ++n10;
                    }
                    if (n8 >= 0 && n8 < n7 && n10 >= 0 && n10 < n) {
                        int n34 = nArray[n8];
                        if (!this.isArc(n5) && !this.isM(n34)) {
                            int n35 = n34 >> 16 & 0xFF;
                            int n36 = n34 >> 8 & 0xFF;
                            int n37 = n34 & 0xFF & 0xFF;
                            if (this.head == 9) {
                                n35 += Math.round((float)n35 / f);
                                n36 += Math.round((float)n36 / f);
                                n37 += Math.round((float)n37 / f);
                            } else {
                                n35 -= Math.round((float)(255 - n35) / f);
                                n36 -= Math.round((float)(255 - n36) / f);
                                n37 -= Math.round((float)(255 - n37) / f);
                            }
                            nArray[n8] = n34 & 0xFF000000 | (n35 > 0 ? (n35 <= 255 ? n35 : 255) : 0) << 16 | (n36 > 0 ? (n36 <= 255 ? n36 : 255) : 0) << 8 | (n37 > 0 ? (n37 <= 255 ? n37 : 255) : 0);
                        }
                    }
                    ++n5;
                }
                break;
            }
        }
    }

    public final void draw(Component component, Graphics graphics, Graphics graphics2, int[][] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        try {
            this.d_x = this.firstX;
            this.d_y = this.firstY;
            this.d_w = this.d_x;
            this.d_h = this.d_y;
            if (component != null) {
                this.component = component;
                Dimension dimension = component.getSize();
                this.vWidth = dimension.width;
                this.vHeight = dimension.height;
            }
            this.visit0 = n6;
            this.visit1 = n7;
            switch (this.head) {
                case 0: 
                case 19: {
                    this.dLine(graphics, graphics2, nArray, n, n2, n3, n4, n5, n8, this.i_alpha == 255 ? 0 : 3);
                    break;
                }
                case 7: {
                    this.alpha = this.i_alpha / 23;
                    this.dLine(graphics, graphics2, nArray, n, n2, n3, n4, n5, n8, 0);
                    break;
                }
                case 8: {
                    this.buffer_work = b_d[this.userNum];
                }
                case 1: 
                case 9: 
                case 10: {
                    this.alpha = (255 - this.i_alpha) / 2 + 1;
                    this.dLine(graphics, graphics2, nArray, n, n2, n3, n4, n5, n8, 1);
                    break;
                }
                case 100: {
                    if (n8 >= 0) {
                        n8 = -1;
                    }
                    this.clear(graphics, nArray, n, n2);
                    break;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 39: {
                    this.alpha = this.i_alpha;
                    if (n8 >= 0) {
                        n8 = -1;
                    }
                    this.dRectOval(nArray[this.layer], n, n2, n3, n4, n5);
                    break;
                }
                case 40: {
                    if (n8 >= 0) {
                        n8 = -1;
                    }
                    this.dMove(nArray, n, n2, n3, n4, n5);
                    break;
                }
                case 41: 
                case 42: 
                case 43: 
                case 44: {
                    if (n8 >= 0) {
                        n8 = -1;
                    }
                    this.alpha = this.i_alpha;
                    this.replace(nArray, n, n2);
                    break;
                }
                case -2: {
                    if (n8 >= 0) {
                        n8 = -1;
                    }
                    this.paste(nArray[this.layer], n, n2);
                    break;
                }
                case 2: {
                    if (n8 >= 0) {
                        n8 = -1;
                    }
                    this.alpha = this.i_alpha;
                    this.dText(nArray[this.layer], n, n2);
                    break;
                }
                case 45: {
                    if (n8 >= 0) {
                        n8 = -1;
                    }
                    this.dFusion(nArray, n, n2);
                    break;
                }
                case 101: {
                    break;
                }
                case 106: {
                    n8 = -2;
                    this.dLine(graphics, graphics2, nArray, n, n2, n3, n4, n5, n8, 2);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {}
        if (n8 == -1 && graphics != null) {
            this.dBuffer(graphics, graphics2, nArray, n, n2, n3, n4, n5);
        }
    }

    private void dRectOval(int[] nArray, int n, int n2, int n3, int n4, int n5) throws RuntimeException {
        try {
            Rectangle rectangle = new Rectangle(n, n2).intersection(this.rect);
            if (rectangle.isEmpty()) {
                return;
            }
            block3 : switch (this.head) {
                case 20: 
                case 39: {
                    int n6 = 0;
                    while (n6 < rectangle.height) {
                        int n7 = n * (rectangle.y + n6) + rectangle.x;
                        int n8 = 0;
                        while (n8 < rectangle.width) {
                            if (!this.isM(nArray[n7])) {
                                nArray[n7] = this.head == 39 ? this.getWPix(nArray[n7]) : this.getAPix(nArray[n7], this.i_color);
                            }
                            ++n7;
                            ++n8;
                        }
                        ++n6;
                    }
                    break;
                }
                case 22: {
                    try {
                        int n9 = rectangle.width;
                        int n10 = rectangle.height;
                        Image image = this.component.createImage(n9, n10);
                        Graphics graphics = image.getGraphics();
                        graphics.setColor(Color.black);
                        graphics.fillRect(0, 0, n9, n10);
                        graphics.setColor(Color.white);
                        graphics.fillOval(1, 1, n9 - 2, n10 - 2);
                        graphics.dispose();
                        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n9, n10, true);
                        pixelGrabber.grabPixels();
                        int[] nArray2 = (int[])pixelGrabber.getPixels();
                        image.flush();
                        image = null;
                        int n11 = n * rectangle.y + rectangle.x;
                        int n12 = 0;
                        int n13 = 0;
                        while (n13 < n10) {
                            int n14 = 0;
                            while (n14 < n9) {
                                if (!this.isM(nArray[n11]) && (nArray2[n12] & 0xFFFFFF) != 0) {
                                    nArray[n11] = this.getAPix(nArray[n11], this.i_color);
                                }
                                ++n11;
                                ++n12;
                                ++n14;
                            }
                            n11 += n - n9;
                            ++n13;
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                    break;
                }
                case 21: {
                    int n15 = rectangle.x;
                    int n16 = rectangle.y;
                    int n17 = rectangle.width;
                    int n18 = rectangle.height - 1;
                    int n19 = 0;
                    while (n19 < this.line_size) {
                        int n20;
                        int n21;
                        int n22 = n21 = n * n16 + n15;
                        int n23 = 0;
                        while (n23 < 2) {
                            n20 = 0;
                            while (n20 < n17) {
                                if (!this.isM(nArray[n22])) {
                                    nArray[n22] = this.getAPix(nArray[n22], this.i_color);
                                }
                                ++n22;
                                ++n20;
                            }
                            n22 = n21 + n * n18;
                            ++n23;
                        }
                        n22 = n21 + n;
                        n23 = 0;
                        while (n23 < 2) {
                            n20 = 0;
                            while (n20 < n18 - 1) {
                                if (!this.isM(nArray[n22])) {
                                    nArray[n22] = this.getAPix(nArray[n22], this.i_color);
                                }
                                n22 += n;
                                ++n20;
                            }
                            n22 = n21 + n + n17 - 1;
                            ++n23;
                        }
                        ++n15;
                        ++n16;
                        if ((n17 -= 2) <= 0 || (n18 -= 2) <= 0) break block3;
                        ++n19;
                    }
                    break;
                }
                case 23: {
                    try {
                        Image image = this.component.createImage(rectangle.width, rectangle.height);
                        Graphics graphics = image.getGraphics();
                        graphics.setColor(Color.black);
                        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
                        graphics.setColor(Color.white);
                        int n24 = 0;
                        while (n24 < this.line_size) {
                            int n25 = 0;
                            while (n25 < this.line_size) {
                                graphics.drawOval(n25 + 1, n24 + 1, rectangle.width - n25 * 2 - 2, rectangle.height - n24 * 2 - 2);
                                ++n25;
                            }
                            ++n24;
                        }
                        graphics.dispose();
                        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, rectangle.width, rectangle.height, true);
                        pixelGrabber.grabPixels();
                        int[] nArray3 = (int[])pixelGrabber.getPixels();
                        image.flush();
                        image = null;
                        int n26 = n * rectangle.y + rectangle.x;
                        int n27 = 0;
                        int n28 = 0;
                        while (n28 < rectangle.height) {
                            int n29 = 0;
                            while (n29 < rectangle.width) {
                                if (!this.isM(nArray[n26]) && nArray3[n27] >= -7829368) {
                                    nArray[n26] = this.getAPix(nArray[n26], this.i_color);
                                }
                                ++n26;
                                ++n27;
                                ++n29;
                            }
                            n26 += n - rectangle.width;
                            ++n28;
                        }
                        break;
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.d_x = rectangle.x;
            this.d_y = rectangle.y;
            this.d_w = rectangle.x + rectangle.width;
            this.d_h = rectangle.y + rectangle.height;
        }
        catch (RuntimeException runtimeException) {
            System.out.println("oval" + runtimeException);
        }
    }

    private void dText(int[] nArray, int n, int n2) {
        try {
            Font font = new Font("sansserif", 0, this.line_size);
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            String string = new String(this.offset, "UTF8");
            if (string.length() <= 0) {
                return;
            }
            int n3 = fontMetrics.stringWidth(string) + string.length();
            int n4 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
            int n5 = n4 - fontMetrics.getMaxDescent();
            this.d_x = this.firstX;
            this.d_y = this.firstY - n4;
            this.d_w = this.firstX + n3;
            this.d_h = this.firstY;
            Image image = this.component.createImage(n3, n4);
            Graphics graphics = image.getGraphics();
            graphics.setFont(font);
            graphics.setColor(Color.black);
            graphics.fillRect(0, 0, n3, n4);
            graphics.setColor(Color.white);
            graphics.drawString(string, fontMetrics.getLeading(), n5);
            graphics.dispose();
            graphics = null;
            font = null;
            fontMetrics = null;
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n3, n4, true);
            pixelGrabber.grabPixels();
            int[] nArray2 = (int[])pixelGrabber.getPixels();
            pixelGrabber = null;
            image.flush();
            image = null;
            int n6 = n * this.firstY - n * n5 + this.firstX;
            int n7 = 0;
            int[] nArray3 = new int[3];
            int[] nArray4 = new int[3];
            int n8 = n * n2;
            int n9 = 0;
            while (n9 < 3) {
                nArray3[n9] = this.i_color >>> (n9 << 3) & 0xFF;
                ++n9;
            }
            n9 = 0;
            while (n9 < n4) {
                int n10 = 0;
                while (n10 < n3) {
                    int n11;
                    if (n6 < 0 || n6 >= n8 || this.firstX + n10 >= n || (n11 = nArray2[n7] & 0xFF) == 0) {
                        ++n7;
                        ++n6;
                    } else {
                        int n12;
                        int n13 = 0;
                        while (n13 < 3) {
                            int n14 = nArray[n6] >>> (n13 << 3) & 0xFF;
                            n12 = n14 + (int)((float)(nArray3[n13] - n14) / 255.0f * (float)n11);
                            nArray4[n13] = n12 < 0 ? 0 : (n12 > 255 ? 255 : n12);
                            ++n13;
                        }
                        n12 = n11 << 24 | nArray4[2] << 16 | nArray4[1] << 8 | nArray4[0];
                        if (!this.isM(nArray[n6])) {
                            nArray[n6] = this.getAPix(nArray[n6], n12);
                        }
                        ++n7;
                        ++n6;
                    }
                    ++n10;
                }
                n6 += n - n3;
                ++n9;
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    private final int getAPix(int n, int n2) {
        if (this.i_alpha == 255) {
            return 0xFF000000 | n2;
        }
        int n3 = n >>> 24;
        int n4 = Math.max(255 - this.i_alpha >>> 3, 1);
        n3 = Math.min(n3 + 1 + (255 - n3) / n4, 255) << 24;
        int n5 = 16;
        while (n5 >= 0) {
            int n6 = n >>> n5 & 0xFF;
            int n7 = n2 >>> n5 & 0xFF;
            n3 |= (n6 == n7 ? n7 : (n6 > n7 ? ((n4 = n6 - this.i_alpha) < n7 ? n7 : n4) : ((n4 = n6 + this.i_alpha) > n7 ? n7 : n4))) << n5;
            n5 -= 8;
        }
        return n3;
    }

    public void getData(OutputStream outputStream) {
        try {
            if (this.mask == 110) {
                this.i_mask = 0;
            }
            int n = this.layer_end << 4 | this.layer;
            outputStream.write(107);
            outputStream.write(this.head);
            int n2 = 0;
            if (this.mask != 110) {
                n2 |= 1;
            }
            if (this.line_size > 1) {
                n2 |= 2;
            }
            if (this.i_color != 0) {
                n2 |= 4;
            }
            if (this.i_mask != 0) {
                n2 |= 8;
            }
            if (this.i_alpha != 255) {
                n2 |= 0x10;
            }
            if (n != 0) {
                n2 |= 0x20;
            }
            outputStream.write(n2);
            n2 = 0;
            if (this.mask != 110) {
                outputStream.write(this.mask);
            }
            if (this.line_size > 1) {
                outputStream.write(this.line_size);
            }
            if (this.i_color != 0) {
                this.w(24, this.i_color, outputStream);
            }
            if (this.i_mask != 0) {
                this.w(24, this.i_mask, outputStream);
            }
            if (this.i_alpha != 255) {
                outputStream.write(this.i_alpha);
            }
            if (n != 0) {
                outputStream.write(n);
            }
            switch (this.head) {
                case 0: 
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 19: {
                    this.w(16, this.firstX, outputStream);
                    this.w(16, this.firstY, outputStream);
                    this.w(16, this.offset.length, outputStream);
                    outputStream.write(this.offset);
                    break;
                }
                case 2: {
                    this.w(16, this.firstX, outputStream);
                    this.w(16, this.firstY, outputStream);
                }
                case 100: 
                case 102: 
                case 103: {
                    if (this.offset == null) {
                        this.w(32, 0, outputStream);
                        break;
                    }
                    this.w(32, this.offset.length, outputStream);
                    if (this.offset.length > 0) {
                        outputStream.write(this.offset);
                    }
                    break;
                }
                case 40: {
                    this.w(16, this.firstX, outputStream);
                    this.w(16, this.firstY, outputStream);
                }
                default: {
                    if (this.rect == null) {
                        this.rect = new Rectangle();
                    }
                    this.w(16, this.rect.x, outputStream);
                    this.w(16, this.rect.y, outputStream);
                    this.w(16, this.rect.width, outputStream);
                    this.w(16, this.rect.height, outputStream);
                    break;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    public byte[] getOffset() {
        return this.offset;
    }

    private final int getWPix(int n) {
        if (this.i_alpha == 255) {
            return 0xFFFFFF;
        }
        int n2 = n >> 24 & 0xFF;
        n2 = Math.max(n2 - ((n2 / (255 - this.i_alpha) << 1) + 1), 0);
        int n3 = n2 << 24;
        n2 = (255 - n2) / 255;
        int n4 = 16;
        while (n4 >= 0) {
            n3 |= Math.min((n >> n4 & 0xFF) + n2, 255) << n4;
            n4 -= 8;
        }
        return n3;
    }

    private final boolean isAm(int n, int n2) {
        if (this.mask != 113 && this.mask != 114) {
            return false;
        }
        int n3 = 0;
        while (n3 < 24) {
            int n4 = n >>> n3 & 0xFF;
            int n5 = n2 >>> n3 & 0xFF;
            if (this.mask == 113 && n4 > n5) {
                return true;
            }
            if (this.mask == 114 && n4 < n5) {
                return true;
            }
            n3 += 8;
        }
        return false;
    }

    private final boolean isArc(int n) {
        return b_arc[this.line_size][n] == 0;
    }

    private final boolean isM(int n) {
        return this.mask == 111 ? n == this.i_mask : (this.mask == 112 ? (n &= 0xFFFFFF) != this.i_mask : false);
    }

    public static boolean isTone(int n, int n2, int n3) {
        switch (n) {
            default: {
                break;
            }
            case 10: {
                if ((n2 + 3) % 4 != 0 || (n3 + 2) % 4 != 0) break;
                return true;
            }
            case 9: {
                if ((n2 + 1) % 4 == 0 && (n3 + 2) % 4 == 0) break;
            }
            case 8: {
                if (n2 % 2 == 0 || (n3 + 1) % 2 == 0) break;
                return true;
            }
            case 7: {
                if ((n2 + 2) % 4 == 0 && (n3 + 3) % 4 == 0) break;
            }
            case 6: {
                if (n2 % 4 == 0 && (n3 + 1) % 4 == 0) break;
            }
            case 5: {
                if ((n2 + 1) % 2 == (n3 + 1) % 2) break;
                return true;
            }
            case 4: {
                if ((n2 + 1) % 4 == 0 && (n3 + 3) % 4 == 0) break;
            }
            case 3: {
                if (n2 % 2 == 0 && n3 % 2 == 0) break;
                return true;
            }
            case 2: {
                if ((n2 + 2) % 4 == 0 && (n3 + 4) % 4 == 0) break;
            }
            case 1: {
                if ((n2 + 2) % 4 == 0 && (n3 + 2) % 4 == 0) break;
            }
            case 0: {
                if (n2 % 4 == 0 && n3 % 4 == 0) break;
                return true;
            }
        }
        return false;
    }

    private final int k(int n) {
        int n2 = 1;
        int n3 = n;
        while (n3 > 1) {
            n2 *= n3;
            --n3;
        }
        return n2;
    }

    private final int kei(int n, int n2) {
        int n3 = this.k(n) / (this.k(n2) * this.k(n - n2));
        return n3;
    }

    public short[] line(Point point, Point point2) {
        short[] sArray = null;
        try {
            float f;
            float f2;
            int n;
            int n2;
            int n3 = point.x;
            int n4 = point.y;
            int n5 = point2.x - n3;
            int n6 = point2.y - n4;
            int n7 = n5 < 0 ? -n5 : n5;
            int n8 = n2 = n6 < 0 ? -n6 : n6;
            if (n7 >= n2) {
                n = n7;
                f2 = n5 < 0 ? -1 : 1;
                f = n6 != 0 ? (float)n6 / (float)n7 : 0.0f;
            } else {
                n = n2;
                f = n6 < 0 ? -1 : 1;
                f2 = n5 != 0 ? (float)n5 / (float)n2 : 0.0f;
            }
            sArray = new short[n * 2];
            int n9 = 0;
            int n10 = 0;
            while (n10 < n) {
                sArray[n9++] = (short)(n3 + Math.round(f2 * (float)n10));
                sArray[n9++] = (short)(n4 + Math.round(f * (float)n10));
                ++n10;
            }
            return sArray;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            return null;
        }
    }

    public final Image makeLPic(int[] nArray, int[][] nArray2, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = n4 + n6;
        boolean bl = nArray == null;
        try {
            if (nArray == null) {
                nArray = b_d[this.userNum];
            }
            while (n4 < n8) {
                int n9 = n * n4 + n3;
                int n10 = n9 + n5;
                while (n9 < n10) {
                    int n11 = nArray2[0][n9];
                    int n12 = nArray2[1][n9];
                    float f = b255[n12 >>> 24 & this.visit1];
                    float f2 = b255[n11 >>> 24 & this.visit0] * (1.0f - f);
                    int n13 = (int)((1.0f - f2 - f) * 255.0f);
                    nArray[n7++] = (int)((float)(n12 >>> 16 & 0xFF) * f) + (int)((float)(n11 >>> 16 & 0xFF) * f2) + n13 << 16 | (int)((float)(n12 >>> 8 & 0xFF) * f) + (int)((float)(n11 >>> 8 & 0xFF) * f2) + n13 << 8 | (int)((float)(n12 & 0xFF) * f) + (int)((float)(n11 & 0xFF) * f2) + n13;
                    ++n9;
                }
                ++n4;
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        if (!bl) {
            return null;
        }
        raster[this.userNum].newPixels(imBuffer[this.userNum], n5, n6);
        return imBuffer[this.userNum];
    }

    private void paste(int[] nArray, int n, int n2) {
        try {
            int n3 = this.rect.x;
            int n4 = this.rect.y;
            int[] nArray2 = b_d[this.userNum];
            int n5 = 0;
            if (n3 < 0 || n3 >= n || n4 < 0 || n4 >= n2) {
                return;
            }
            int n6 = nArray[n4 * n + n3];
            int n7 = this.i_alpha << 24 | this.i_color & 0xFFFFFF;
            if (n6 == n7) {
                return;
            }
            int n8 = n * n4 + 1;
            while (n3 < n - 1 && nArray[n8 + n3] == n6) {
                ++n3;
            }
            nArray2[n5++] = n3 << 16 | n4;
            block3: while (n5 > 0) {
                int n9 = nArray2[--n5];
                n3 = n9 >>> 16;
                n4 = n9 & 0xFFFF;
                n8 = n * n4;
                boolean bl = false;
                boolean bl2 = false;
                while (true) {
                    int n10;
                    int n11;
                    nArray[n8 + n3] = n7;
                    if (n4 > 0 && nArray[n8 - n + n3] == n6) {
                        if (!bl) {
                            bl = true;
                            n11 = n3;
                            n10 = n * (n4 - 1);
                            while (n11 < n - 1 && nArray[n10 + n11 + 1] == n6) {
                                ++n11;
                            }
                            nArray2[n5++] = n11 << 16 | n4 - 1 & 0xFFFF;
                        }
                    } else {
                        bl = false;
                    }
                    if (n4 < n2 - 1 && nArray[n8 + n + n3] == n6) {
                        if (!bl2) {
                            bl2 = true;
                            n11 = n3;
                            n10 = n * (n4 + 1);
                            while (n11 < n - 1 && nArray[n10 + n11 + 1] == n6) {
                                ++n11;
                            }
                            nArray2[n5++] = n11 << 16 | n4 + 1 & 0xFFFF;
                        }
                    } else {
                        bl2 = false;
                    }
                    if (n3 <= 0 || nArray[n8 + n3 - 1] != n6) continue block3;
                    --n3;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            System.out.println(runtimeException);
        }
        this.d_x = 0;
        this.d_y = 0;
        this.d_w = n;
        this.d_h = n2;
    }

    private int r(int n, InputStream inputStream) throws IOException {
        int n2 = 0;
        int n3 = n - 8;
        while (n3 >= 0) {
            int n4 = inputStream.read();
            if (n4 == -1) {
                throw new EOFException();
            }
            n2 |= n4 << n3;
            n3 -= 8;
        }
        return n2;
    }

    /*
     * Exception decompiling
     */
    private void replace(int[][] var1_1, int var2_2, int var3_3) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[SWITCH], 9[CASE]], but top level block is 4[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setC(Component component) {
        this.component = component;
    }

    public void setData(byte[] byArray) {
        this.offset = byArray;
    }

    public Point setData(short[] sArray, int n) {
        int n2 = -((this.line_size - 1) / 2);
        try {
            if (n == 0) {
                n = sArray.length;
            }
            int n3 = 0;
            while (n3 < n) {
                int n4 = n3++;
                sArray[n4] = (short)(sArray[n4] + n2);
            }
            this.firstX = sArray[0];
            this.firstY = sArray[1];
            Point point = new Point(this.firstX, this.firstY);
            this.offset = new byte[n -= 2];
            short s = sArray[0];
            short s2 = sArray[1];
            int n5 = 2;
            int n6 = 0;
            while (n6 < n) {
                int n7 = sArray[n5] - s;
                n7 = n7 < -128 ? -128 : (n7 > 127 ? 127 : n7);
                int n8 = sArray[n5 + 1] - s2;
                n8 = n8 < -128 ? -128 : (n8 > 127 ? 127 : n8);
                this.offset[n6] = (byte)n7;
                this.offset[n6 + 1] = (byte)n8;
                point.translate(n7, n8);
                s = sArray[n5];
                s2 = sArray[n5 + 1];
                n5 += 2;
                n6 += 2;
            }
            return new Point(point.x - n2, point.y - n2);
        }
        catch (RuntimeException runtimeException) {
            return new Point(sArray[sArray.length - 1] - n2, sArray[sArray.length - 2] - n2);
        }
    }

    public void setData(int n) {
        this.head = n;
        this.rect = null;
        this.offset = null;
    }

    public void setData(Point point, String string) {
        try {
            if (point != null) {
                this.firstX = (short)point.x;
                this.firstY = (short)point.y;
            } else {
                this.firstX = 0;
                this.firstY = 0;
            }
            this.offset = string.getBytes("UTF8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.offset = null;
        }
    }

    public void setData(Rectangle rectangle) {
        this.rect = rectangle != null ? rectangle : new Rectangle();
    }

    public void setData(Rectangle rectangle, Point point, int n, int n2) {
        Rectangle rectangle2 = this.rect = rectangle != null ? rectangle : new Rectangle();
        if (point != null) {
            this.firstX = (short)point.x;
            this.firstY = (short)point.y;
        } else {
            this.firstX = 0;
            this.firstY = 0;
        }
        this.layer = n;
        this.layer_end = n2;
    }

    public void setData(DataInputStream dataInputStream) throws EOFException, IOException, InterruptedIOException {
        try {
            int n;
            while ((n = dataInputStream.readByte()) != 107) {
            }
            this.head = dataInputStream.readByte();
            n = dataInputStream.readByte();
            this.mask = (n & 1) != 0 ? (int)dataInputStream.readByte() : 110;
            this.line_size = (n & 2) != 0 ? dataInputStream.readByte() : (byte)1;
            this.i_color = (n & 4) != 0 ? this.r(24, dataInputStream) : 0;
            this.i_mask = (n & 8) != 0 ? this.r(24, dataInputStream) : 0;
            int n2 = this.i_alpha = (n & 0x10) != 0 ? dataInputStream.readUnsignedByte() : 255;
            if ((n & 0x20) != 0) {
                n = dataInputStream.readUnsignedByte();
                this.layer = n & 0xF;
                this.layer_end = n >> 4 & 0xF;
            } else {
                this.layer = 0;
                this.layer_end = 0;
            }
            n = 0;
            switch (this.head) {
                case 0: 
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 19: {
                    this.firstX = dataInputStream.readShort();
                    this.firstY = dataInputStream.readShort();
                    short s = dataInputStream.readShort();
                    if (s > 10000) {
                        while (n < s) {
                            n = (int)((long)n + dataInputStream.skip(s - n));
                        }
                        this.offset = new byte[2];
                        break;
                    }
                    this.offset = new byte[s];
                    while (n < s) {
                        n += dataInputStream.read(this.offset, n, s - n);
                    }
                    break;
                }
                case 2: {
                    this.firstX = dataInputStream.readShort();
                    this.firstY = dataInputStream.readShort();
                }
                case 100: 
                case 102: 
                case 103: {
                    int n3 = this.r(32, dataInputStream);
                    if (n3 >= 500000) {
                        while (n < n3) {
                            n = (int)((long)n + dataInputStream.skip(n3 - n));
                        }
                        this.offset = new byte[1];
                        break;
                    }
                    if (n3 == 0) {
                        this.offset = new byte[1];
                        break;
                    }
                    this.offset = new byte[n3];
                    while (n < n3) {
                        n += dataInputStream.read(this.offset, n, n3 - n);
                    }
                    break;
                }
                case 40: {
                    this.firstX = dataInputStream.readShort();
                    this.firstY = dataInputStream.readShort();
                }
                default: {
                    this.rect = new Rectangle(dataInputStream.readShort(), dataInputStream.readShort(), dataInputStream.readShort(), dataInputStream.readShort());
                    break;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    public void setPreData(short[] sArray, int n, int n2) {
        this.head = 106;
        this.line_size = n2;
        this.setData(sArray, n);
    }

    public static void setup(Component component, int n) {
        if (b_arc == null) {
            int n2;
            int n3;
            int n4;
            color_model = new DirectColorModel(24, 0xFF0000, 65280, 255);
            int n5 = 1;
            while (n5 < 256) {
                MgLine.b255[n5] = (float)n5 / 255.0f;
                ++n5;
            }
            b_d = new int[n][16384];
            raster = new SRaster[n];
            imBuffer = new Image[n];
            n5 = 0;
            while (n5 < n) {
                MgLine.raster[n5] = new SRaster(color_model, b_d[n5], 128, 128);
                MgLine.imBuffer[n5] = component.createImage(raster[n5]);
                ++n5;
            }
            MgLine mgLine = new MgLine();
            mgLine.rect = new Rectangle();
            mgLine.i_color = 255;
            mgLine.i_alpha = 0;
            b_arc = new int[31][];
            n5 = 0;
            while (n5 < 31) {
                MgLine.b_arc[n5] = new int[n5 * n5];
                ++n5;
            }
            n5 = 1;
            while (n5 < 3) {
                int n6 = 0;
                while (n6 < b_arc[n5].length) {
                    MgLine.b_arc[n5][n6] = 255;
                    ++n6;
                }
                ++n5;
            }
            int n7 = 0;
            int[] nArray = new int[]{186, 28662, 4685252};
            while (n5 < 6) {
                n4 = nArray[n7++];
                n3 = 0;
                n2 = 0;
                while (n2 < b_arc[n5].length) {
                    if ((n4 >> n2 & 1) != 0) {
                        MgLine.b_arc[n5][n2] = 255;
                    }
                    ++n2;
                }
                ++n5;
            }
            while (n5 < 31) {
                int[] nArray2 = b_arc[n5];
                n4 = n5 / 2 - 1;
                int n8 = (int)(Math.PI * 2 * (double)n4);
                n2 = 0;
                while (n2 < n8 * 4) {
                    n3 = Math.min(n4 + (int)Math.round((double)n4 * Math.cos(n2)), n5 - 1);
                    n7 = Math.min(n4 + (int)Math.round((double)n4 * Math.sin(n2)), n5 - 1);
                    nArray2[n7 * n5 + n3] = 255;
                    ++n2;
                }
                mgLine.rect.setLocation(n4, n4);
                mgLine.paste(b_arc[n5], n5, n5);
                ++n5;
            }
        }
    }

    public void setVisit(int n, int n2) {
        this.visit0 = n;
        this.visit1 = n2;
    }

    private void w(int n, int n2, OutputStream outputStream) throws IOException {
        int n3 = n - 8;
        while (n3 >= 0) {
            outputStream.write(n2 >>> n3 & 0xFF);
            n3 -= 8;
        }
    }
}

