# doc/etc 目录整理说明

## 整理概述

本目录原本包含了大量的开发记录文件，现已按功能模块进行分类整理，便于查找和维护。

## NOUVEAU DAY 时间体系

### 时间锚点
项目开发记录以2025年4月8日为锚点（NOUVEAU DAY 1），该日期为钓鱼功能的首次实现日期。

### 计算公式
NOUVEAU DAY X = (记录日期 - 2025年4月8日) + 1

### 重要时间节点
- 2025年4月8日 = NOUVEAU DAY 1 (钓鱼系统实现 - 锚点)
- 2025年4月11日 = NOUVEAU DAY 4 (钓鱼属性提升)
- 2025年4月12日 = NOUVEAU DAY 5 (钓鱼系统完善)
- 2025年6月15日 = NOUVEAU DAY 69 (时间戳整理)

### 历史记录
- 2025年1月3日 = NOUVEAU DAY -95 (种火战斗修复)
- 2025年1月9日 = NOUVEAU DAY -89 (核武器修复完成)
- 2024年12月14日 = NOUVEAU DAY -115 (骰子函数修复)
- 2024年12月15日 = NOUVEAU DAY -114 (RuleSet系统修复)

## 目录结构

### 📁 物品系统/
包含物品系统相关的开发记录，主要涉及：
- 物品参数系统 (itmpara) 的实现和优化
- Y和Z类型物品的重构
- NPC平台功能重构
- 无限耐久度修复
- 各种增强器的重构

**文件列表：**
- `20240719_itmpara_*.txt` - 物品参数系统相关
- `20250408-*-*items-refactor*.txt` - 物品重构相关
- `20250119_infinite_durability_fix.txt` - 耐久度修复
- `20250408-*-nachster-booster-refactor.txt` - 增强器重构
- `20250408-*-platform-*.txt` - 平台功能相关

### 📁 钓鱼系统/
包含钓鱼功能的完整开发历程：
- 基础钓鱼功能实现
- 属性提升机制
- 钓竿增强效果
- 系统优化和修复

**文件列表：**
- `20250408-234725-fishing-feature.txt` - 基础功能
- `20250411-134214-fishing-attribute-boost.txt` - 属性提升
- `20250412-*-fishing*.txt` - 系统更新和优化
- `20250412-210000-fishing-feature-complete.md` - 完整实现记录

### 📁 社团系统/
包含社团相关功能的开发记录：
- 枫火歌者 (Club 22) 社团的完整实现
- 种火系统机制
- 社团技能和套装系统

**文件列表：**
- `20240720_000000_club22_implementation_summary.txt` - 枫火歌者社团完整总结

### 📁 战斗系统/
包含战斗系统的分析、优化和扩展：
- 改进版战斗系统分析
- 技能系统实现
- 核武器机制
- NPC技能系统

**文件列表：**
- `20250412_185958_revcombat_analysis.txt` - 战斗系统分析
- `20250417_*_*skills_implementation*.txt` - 技能系统
- `20250417_*_*Nuclear*.txt` - 核武器系统
- `20250419_*_npc_*.txt` - NPC技能系统

### 📁 对话系统/
包含对话系统的开发记录：
- 对话选择机制
- 剧情分支系统

**文件列表：**
- `20250419_dialogue_choice_system.txt` - 对话选择系统

### 📁 界面修复/
包含用户界面相关的修复记录：
- 背景图片更新修复
- PHP通知修复
- 界面显示优化

**文件列表：**
- `20240719_fix_*.txt` - 界面修复相关
- `20240719_php_notice_fixes.txt` - PHP通知修复

### 📁 数据库系统/
包含数据库相关的开发和修复记录：
- 主从数据库系统实现
- 用户迁移功能
- 数据库表结构修复
- 配置管理优化

**文件列表：**
- `20250112_*slave*.txt` - 主从数据库系统
- `20250112_*migration*.txt` - 迁移功能
- `20250112_database_*.txt` - 数据库修复
- `20250112_*config*.txt` - 配置相关

### 📁 事件系统/
包含游戏事件系统的开发记录：
- 事件触发机制
- 事件处理逻辑

**文件列表：**
- `20240712_revevent_implementation.txt` - 事件系统实现

### 📁 已整合/
用于存放已经整合到正式文档中的记录文件。

## 整理原则

### 1. 按功能分类
- 根据文件内容的主要功能进行分类
- 相关功能的文件放在同一目录下
- 便于按模块查找相关开发记录

### 2. 保持原始文件名
- 保留原始的时间戳文件名
- 便于追溯开发时间线
- 维持文件的唯一性

### 3. 创建索引文档
- 在主文档中创建了完整的开发历程整合
- 提供功能模块的交叉引用
- 便于快速定位相关信息

## 使用建议

### 查找特定功能的开发记录
1. 根据功能模块进入对应目录
2. 按时间戳查看开发顺序
3. 参考主文档的整合说明

### 了解完整开发历程
1. 查看 `doc/nouveau_250609/开发历程整合.md`
2. 按时间线了解项目演进
3. 参考功能模块的实现细节

### 添加新的开发记录
1. 按照现有的命名规范创建文件
2. 根据功能分类放入对应目录
3. 更新相关的索引文档

## 文件命名规范

### 时间戳格式
- `YYYYMMDD_HHMMSS_功能描述.txt` - 标准格式
- `YYYYMMDD-HHMMSS-功能描述.txt` - 替代格式
- `YYYYMMDD_功能描述.txt` - 简化格式

### 功能描述规范
- 使用英文或拼音描述主要功能
- 避免使用特殊字符
- 保持描述的简洁性和准确性

## 维护说明

### 定期整理
- 建议每季度进行一次目录整理
- 将完成的功能记录移入"已整合"目录
- 更新主文档的内容索引

### 文档更新
- 重要功能实现后及时更新主文档
- 保持开发历程的完整性
- 为新团队成员提供清晰的参考

### 备份策略
- 定期备份整个doc目录
- 重要文档建议多地备份
- 保持版本控制的完整性

---

## 时间戳整理记录

**时间戳整理时间**: 2025年6月15日 (NOUVEAU DAY 69)
**整理内容**:
- 修正了10个错误的2025年6月时间戳文件，改为2024年12月（这些文件实际是2024年的RuleSet系统修复记录）
- 为2025年6月14-15日的9个正确文件添加了NOUVEAU DAY标记
- 为历史文件添加了NOUVEAU DAY标记（包括钓鱼系统、核武器修复、种火系统等）
- 建立了NOUVEAU DAY计算体系，以钓鱼系统实现日期(2025年4月8日)为锚点
- 统一了时间戳格式和标记体系

**原始整理时间**: 2025年6月9日 (NOUVEAU DAY 63)
**整理人员**: 开发团队
**文件总数**: 42个开发记录文件
**分类目录**: 8个功能模块目录

*本次整理大大提高了开发记录的可维护性和可查找性，为团队协作提供了更好的支持。时间戳整理进一步规范了开发记录的时间体系。*
