<?php

	if (! defined ( 'IN_GAME' )) {
		exit ( 'Access Denied' );
	}

	# 没有目标击杀，自然死亡时的事件（可能也不是那么“自然”……）
	function death($death, $kname = '', $ktype = 0, $annex = '',&$data=NULL)
	{
		global $now, $db, $tablepre, $gtablepre, $alivenum, $deathnum, $killmsginfo, $typeinfo, $weather;

		if(!isset($data))
		{
			global $pdata;
			$data = &$pdata;
		}
		extract($data,EXTR_REFS);

		$bid = 0; $action = '';

		if (!$death) return;

		$hp = 0;
		if ($death == 'poison') {
			$state = 26;
		} elseif ($death == 'trap') {
			$state = 27;
		} elseif ($death == 'event') {
			$state = 13;
		} elseif ($death == 'hack') {
			$state = 14;
		} elseif ($death == 'pmove') {
			$state = 12;
		} elseif ($death == 'hsmove') {
			$state = 17;
		} elseif ($death == 'umove') {
			$state = 18;
		} elseif ($death == 'button') {
			$state = 30;
		} elseif ($death == 'suiside') {
			$state = 31;
		} elseif ($death == 'gradius') {
			$state = 33;
		} elseif ($death == 'SCP') {
			$state = 34;
		} elseif ($death == 'salv'){
			$state = 35;
		} elseif ($death == 'kagari1'){
			$state = 36;
		} elseif ($death == 'kagari2'){
			$state = 37;
		} elseif ($death == 'kagari3'){
			$state = 38;
		} elseif ($death == 'gg'){
			$state = 39;
		} elseif ($death == 'fake_dn'){
			$state = 28;
		} elseif ($death == 'thunde'){
			$state = 40;
		} elseif ($death == 's_escape'){
			$state = 42;
		} elseif ($death == 'club21_burnout'){
			$state = 44;
		} elseif ($death == 'club21_blaster'){
			$state = 45;
		} elseif ($death == 'sdestruct'){
			$state = 50;
		} else {
			$state = 10;
		}

		$killmsg = '';
		if ($ktype == 0 && $kname) {
			$result = $db->query ( "SELECT killmsg FROM {$gtablepre}users WHERE username = '$kname'" );
			$killmsg = $db->result ( $result, 0 );
		} elseif ($ktype != 0 && $kname) {
			$killmsg = $killmsginfo [$ktype];
			$kname = "$typeinfo[$ktype] $kname";
		} else {
			$kname = '';
			$killmsg = '';
		}

		$dname = $name;

		if (!$type)
		{
			$dname = (!empty($nick) || $nick == 0) ? $nick.'|'.$name : $name;
			$alivenum--;
			$deathnum++;
			$result = $db->query ( "SELECT lastword FROM {$gtablepre}users WHERE username = '$name'" );
			$lastword = $db->result ( $result, 0 );
			$lwname = $typeinfo [$type] . ' ' . $name;
			$db->query ( "INSERT INTO {$tablepre}chat (type,`time`,send,recv,msg) VALUES ('3','$now','$lwname','$pls','$lastword')" );
		}
		$deathtime = $now;

		addnews ($now,'death'.$state,$dname,$type,$kname,$annex,$lastword);

		# 执行死亡事件（灵魂绑定等）
		if(!$data['type'] && empty($data['nm'])) $data['nm'] = '你';
		check_death_events(create_dummy_playerdata(),$data,1);

		player_save($data);

		save_gameinfo ();
		return $killmsg;
	}

	# 执行不需要考虑复活问题的击杀事件：
	# 再重复一遍：这里的第一个参数指的是杀人者(敌对方)视角，第二个参数指的是死者(受到伤害者)视角。
	function pre_kill_events(&$pa,&$pd,$active,$death)
	{
		global $log, $now, $db, $gtablepre, $tablepre, $typeinfo, $lwinfo;

		// 登记死法
		// 传入了数字编号死法
		if (is_numeric($death)) {
			$pd['state'] = $death;
		// 否则按照指定武器类型判断
		} elseif ($death == 'N') {
			$pd['state'] = 20;
		} elseif ($death == 'P') {
			$pd['state'] = 21;
		} elseif ($death == 'K') {
			$pd['state'] = 22;
		} elseif ($death == 'G') {
			$pd['state'] = 23;
		} elseif ($death == 'J') {
			$pd['state'] = 23;
		} elseif ($death == 'C') {
			$pd['state'] = 24;
		} elseif ($death == 'D') {
			$pd['state'] = 25;
		} elseif ($death == 'F') {
			$pd['state'] = 29;
		} elseif ($death == 'B') {
			$pd['state'] = 60;
		} elseif ($death == 'poison') {
			$pd['state'] = 26;
		} elseif ($death == 'trap') {
			$pd['state'] = 27;
		} elseif ($death == 'dn') {
			$pd['state'] = 28;
		} else {
			$pd['state'] = 10;
		}
		//初始化死者信息
		$dtype = $pd['type']; $dname = $pd['name']; $dpls = $pd['pls'];
		//初始化NPC遗言
		if($dtype)
		{
			$lastword = is_array($lwinfo[$dtype]) ? $lwinfo[$dtype][$dname] : $lwinfo[$dtype];
		}
		//初始化玩家遗言
		else
		{
			$result = $db->query ( "SELECT lastword FROM {$gtablepre}users WHERE username ='$dname'");
			$lastword = $db->result ( $result, 0 );
		}
		//向聊天框发送遗言
		$dname = $typeinfo[$pd['type']].' '.$pd['name']; //以前有没有来着……
		$db->query ( "INSERT INTO {$tablepre}chat (type,`time`,send,recv,msg) VALUES ('3','$now','$dname','$dpls','$lastword')" );

		//发送news
		$dname = !$pd['type'] && (!empty($pd['nick']) || $pd['nick'] == 0) ? $pd['nick'].'|'.$pd['name'] : $pd['name'];
		$kname = !$pa['type'] && (!empty($pa['nick']) || $pa['nick'] == 0) ? $pa['nick'].'|'.$pa['name'] : $pa['name'];
		addnews ($now,'death'.$pd['state'],$dname,$dtype,$kname,$pa['wep_name'],$lastword);

		return $lastword;
	}

	# 执行复活事件：
	# 重要的事情要说三次：这里的第一个参数指的是杀人者(敌对方)视角，第二个参数指的是死者(受到伤害者)视角。
	function revive_process(&$pa,&$pd,$active)
	{
		global $log,$weather,$now,$gamevars;
		include_once GAME_ROOT.'./include/game/clubslct.func.php';

		if(empty($pa['nm'])) $pa['nm'] = $active && !$pa['type'] ? '你' : $pa['name'];
		if(empty($pd['nm'])) $pd['nm'] = !$active && !$pd['type'] ? '你' : $pd['name'];

		$revival_flag = 0;

		$dname = $pd['name']; $dnick = $pd['nick'];

		#光玉雨天气下，提供者有概率复活
		if (!$revival_flag && $weather == 18 && $gamevars['wth18pid'] == $pd['pid'])
		{
			# 计算雨势
			$wthlastime = $now - $gamevars['wth18stime'];
			# 雨势在前7分钟递增，后3分钟递减
			$wthlastime = $wthlastime <= 420 ? $wthlastime : 600 - $wthlastime;
			$wthpow = min(7,max(1,round($wthlastime / 60)));
			# 复活概率：基础10% + 效力x2 最高24%
			$wth18_obbs = 10 + diceroll($wthpow) + diceroll($wthpow);
			$wth18_dice = diceroll(99);
			if($wth18_dice < $wth18_obbs)
			{
				#奥罗拉复活效果
				$revival_flag = 18; //保存复活标记为通过光玉雨复活
				addnews($now,'wth18_revival',$dname,$dnick);
				$pd['hp'] = max($wth18_obbs,1);
				$pd['sp'] = max($wth18_obbs,1);
				$pd['state'] = 0;
				$log.= "<span class=\"lime\">但是，飞舞着的光玉们钻进了{$pd['nm']}的身体，让{$pd['nm']}重新站了起来！</span><br>";;
				return $revival_flag;
			}
		}

		#极光天气下，玩家有10%概率、NPC有1%概率无条件复活
		if (!$revival_flag && $weather == 17)
		{
			$aurora_rate = $pd['type'] ? 1 : 10; //玩家10%概率复活
			$aurora_dice = diceroll(99);
			if($aurora_dice<=$aurora_rate)
			{
				#奥罗拉复活效果
				$revival_flag = 17; //保存复活标记为通过奥罗拉复活
				addnews($now,'aurora_revival',$dname,$dnick);
				$pd['hp'] = max($aurora_dice,1);
				$pd['sp'] = max($aurora_dice,1);
				$pd['state'] = 0;
				$log.= "<span class=\"lime\">但是，空气中弥漫着的奥罗拉让{$pd['nm']}重新站了起来！</span><br>";;
				return $revival_flag;
			}
		}

		# 「涅槃」复活：
		if (!$revival_flag && isset($pd['skill_c19_nirvana']))
		{
			# 「涅槃」复活效果：
			$revival_flag = 'nirvan'; //保存复活标记为通过技能复活
			addnews($now,'revival',$dname,$dnick);
			# 添加「涅槃」激活次数
			set_skillpara('c19_nirvana','active_t',get_skillpara('c19_nirvana','active_t',$pd['clbpara'])+1,$pd['clbpara']);
			$pd['state'] = 0;
			$pd['hp'] = 1; $pd['sp'] = 1;
			# 将多出的rp转化为生命和防御力
			if($pd['rp'])
			{
				$tot_rp = abs(round($pd['rp']/2));
				if($tot_rp)
				{
					$pd['mhp'] += $tot_rp; $pd['def'] += $tot_rp;
				}
				$pd['rp'] = 0;
			}
			$log .= '<span class="lime">但是，'.$pd['nm'].'涅槃重生了！</span><br>';
			return $revival_flag;
		}

		return $revival_flag;
	}

	# 执行死透了后的事件：
	function final_kill_events(&$pa,&$pd,$active,$last=0)
	{
		global $log,$now,$alivenum,$deathnum,$db,$gtablepre,$tablepre;

		if(empty($pa['nm'])) $pa['nm'] = $active && !$pa['type'] ? '你' : $pa['name'];
		if(empty($pd['nm'])) $pd['nm'] = !$active && !$pd['type'] ? '你' : $pd['name'];

		$pd['hp'] = 0; $pd['bid'] = $pa['pid'];	$pd['action'] = '';
		$pd['endtime'] = $pd['deathtime'] = $now;

		# 初始化遗言
		if (!$pd['type'])
		{
			//死者是玩家，增加击杀数并保存系统状况。
			$pa['killnum'] ++;
			$alivenum --;
			if(!empty($last)) $log .= "<span class='evergreen'>{$pd['nm']}用尽最后的力气喊道：“".$last."”</span><br>";
		}
		else
		{
			//死者是NPC，加载NPC遗言
			if(!empty($last)) $log .= npc_chat_rev ($pd,$pa, 'death' );
		}
		$deathnum ++;

		# 初始化killmsg
		if(!$pa['type'])
		{
			global $db,$tablepre;
			$pname = $pa['name'];
			$result = $db->query("SELECT killmsg FROM {$gtablepre}users WHERE username = '$pname'");
			$killmsg = $db->result($result,0);
			if(!empty($killmsg)) $log .= "<span class=\"evergreen\">{$pa['nm']}对{$pd['nm']}说：“{$killmsg}”</span><br>";
		}
		else
		{
			$log .= npc_chat_rev ($pa,$pd,'kill');
		}

		# 杀人rp结算
		get_killer_rp($pa,$pd,$active);
		# 执行死亡事件（灵魂绑定等）
		check_death_events($pa,$pd,$active);
		# 检查成就 大补丁：击杀者是玩家时才会检查成就
		if(!$pa['type'])
		{
			include_once GAME_ROOT.'./include/game/achievement.func.php';
			check_battle_achievement_rev($pa,$pd);
		}
		# 保存游戏进行状态
		player_save($pd);
		save_gameinfo();
		return;
	}

	# 特殊死亡事件（灵魂绑定等）
	function check_death_events(&$pa,&$pd,$active)
	{
		global $db,$tablepre,$log,$now,$nosta;

		# 静流下线事件：
		if($pd['type'] == 15)
		{
			//静流AI
			global $gamevars;
			$gamevars['sanmadead'] = 1;
			save_gameinfo();
		}

		# 保存击杀女主的记录
		if($pd['type'] == 14)
		{
			$pa['clbpara']['achvars']['kill_n14'] += 1;
			# 不一定是一击秒杀……但是先这样吧^ ^;
			if($pd['name'] == '守卫者 静流' && $pa['final_damage'] >= $pd['mhp']) $pa['clbpara']['achvars']['ach505'] = 1;
		}

		# Process 百命猫 Kills
		if($pd['name'] == '是TSEROF啦！'){
			// 确保 clbpara 是数组
			if(!is_array($pd['clbpara'])) {
				if(is_string($pd['clbpara'])) {
					$pd['clbpara'] = json_decode($pd['clbpara'], true);
				}
				if(!is_array($pd['clbpara'])) {
					$pd['clbpara'] = array();
				}
			}

			// 确保 lifedestroyed 字段存在且为数字
			if(!isset($pd['clbpara']['lifedestroyed']) || !is_numeric($pd['clbpara']['lifedestroyed'])) {
				$pd['clbpara']['lifedestroyed'] = 0;
			}
			$pd['clbpara']['lifedestroyed'] += 1;
			//make her disappear from map if all life are destroyed.
			if($pd['clbpara']['lifedestroyed'] > 111){
				$pd['hp'] = 0;
				$pd['map'] = 254; # Stay with the corpses, dear kitty.
			}
		}

		# 保存击杀种火或小兵的记录
		if(empty($pa['clbpara']['achvars']['kill_minion']) && ($pd['type'] == 90 || $pd['type'] == 91 || $pd['type'] == 92)) $pa['clbpara']['achvars']['kill_minion'] = 1;

		# 成就504，保存在RF高校用过的武器记录
		if($pa['pls'] == 2) $pa['clbpara']['achvars']['ach504'][$pa['wep_kind']] = 1;


		# 快递被劫事件：
		if(isset($pd['clbpara']['post']))
		{
			$log.="<span class='sienna'>某样东西从{$pd['name']}身上掉了出来……</span><br>";
			//获取快递信息
			$iid = $pd['clbpara']['postid'];
			//获取金主信息
			$sponsorid = $pd['clbpara']['sponsor'];
			$result = $db->query("SELECT * FROM {$tablepre}gambling WHERE uid = '$sponsorid'");
			$sordata = $db->fetch_array($result);
			//发一条news 表示快递被劫走了
			addnews($now,'gpost_failed',$sordata['uname'],$pd['itm'.$iid]);
			//消除快递相关参数
			unset($pd['clbpara']['post']);unset($pd['clbpara']['postid']);unset($pd['clbpara']['sponsor']);
			//解除快递锁
			$db->query("UPDATE {$tablepre}gambling SET bnid=0 WHERE uid='$sponsorid'");
		}

		# 灵魂绑定事件：
		foreach(get_equip_list() as $equip)
		{
			// ……我为什么不把这个装备名数组放进resources里……用了一万遍了
			// 哈哈，放了！
			if(!empty($pd[$equip.'s']) && strpos($pd[$equip.'sk'],'v')!==false)
			{
				$log .= "伴随着{$pd['nm']}的死亡，<span class=\"yellow\">{$pd[$equip]}</span>化作灰烬消散了。<br>";
				include_once GAME_ROOT.'./include/game/itemmain.func.php';
				destory_single_equip($pd,$equip);
			}
		}
		for($i=0;$i<=6;$i++)
		{
			if(!empty($pd['itms'.$i]) && strpos($pd['itmsk'.$i],'v')!==false)
			{
				$log .= "伴随着{$pd['nm']}的死亡，<span class=\"yellow\">{$pd['itm'.$i]}</span>化作灰烬消散了。<br>";
				include_once GAME_ROOT.'./include/game/itemmain.func.php';
				destory_single_item($pd,$i);
			}
		}

		# 带有“天然”属性的副武器，在死亡时会掉到地图上……
		if(!empty($pd['wep2e']) && !empty($pd['wep2sk']) && in_array('z',get_itmsk_array($pd['wep2sk'])))
		{
			$db->query("INSERT INTO {$tablepre}mapitem (itm, itmk, itme, itms, itmsk ,pls) VALUES ('{$pd['wep2']}', '{$pd['wep2k']}', '{$pd['wep2e']}', '{$pd['wep2s']}', '{$pd['wep2sk']}', '{$pd['pls']}')");
			include_once GAME_ROOT.'./include/game/itemmain.func.php';
			destory_single_equip($pd,'wep2');
		}

		#「掠夺」判定：
		if(isset($pa['skill_c4_loot']))
		{
			//获取抢钱率
			$sk_p = get_skillvars('c4_loot','goldr');
			$lootgold = $pa['lvl'] * $sk_p;
			$log.="<span class='yellow'>「掠夺」使{$pa['nm']}获得了{$lootgold}元！</span><br>";
		}

		# 「天威」技能判定
		if(isset($pa['bskill_c6_godpow']) && $pa['final_damage'] <= $pd['mhp'] * get_skillvars('c6_godpow','mhpr'))
		{
			$rageback = get_skillvars('c6_godpow','rageback');
			if(!empty($rageback))
			{
				$pa['rage'] = min(255,$pa['rage']+$rageback);
				$log .= '<span class="yellow">「天威」使'.$pa['nm'].'的怒气回复了'.$rageback.'点！</span><br>';
			}
		}

		# 「浴血」技能判定
		if(isset($pa['skill_c12_bloody']))
		{
			if($pa['hp'] <= $pa['mhp']*0.3) $sk_lvl = 2;
			elseif($pa['hp'] <= $pa['mhp']*0.5) $sk_lvl = 1;
			else $sk_lvl = 0;
			$sk_att_vars = get_skillvars('c12_bloody','attgain',$sk_lvl);
			$sk_def_vars = get_skillvars('c12_bloody','defgain',$sk_lvl);
			$pa['att'] += $sk_att_vars; $pa['def'] += $sk_def_vars;
			$log .= '<span class="yellow">「浴血」使'.$pa['nm'].'的攻击增加了'.$sk_att_vars.'点，防御增加了'.$sk_def_vars.'点！</span><br>';
		}

		# 佣兵死亡时，自动解除与雇主的雇佣关系
		if(isset($pd['clbpara']['oid']))
		{
			$odata = fetch_playerdata_by_pid($pd['clbpara']['oid']);
			include_once GAME_ROOT.'./include/game/revclubskills_extra.func.php';
			$log .= "<span clas='red'>由于战死，";
			skill_merc_fire('c11_merc',$pd['clbpara']['mkey'],$pd,1);
		}
		# 灵俑死亡时，从创造者的灵俑队列中删除
		if(isset($pd['clbpara']['zombieoid']))
		{
			$odata = fetch_playerdata_by_pid($pd['clbpara']['zombieoid']);
			$mkey = array_search($pd['pid'],$odata['clbpara']['mate']);
			unset($odata['clbpara']['mate'][$mkey]);
			$zkey = array_search($pd['pid'],$odata['clbpara']['zombieid']);
			unset($odata['clbpara']['zombieid'][$zkey]);
			player_save($odata);
			$w_log = "<span class=\"grey\">你的灵俑{$pd['name']}归于尘土了……</span><br>";
			logsave($odata['pid'],$now,$w_log,'c');
		}

		return;
	}

	# 怒气上涨事件
	function rgup_rev(&$pa,&$pd,$active)
	{
		# 攻击命中的情况下，计算pa(攻击方)因攻击行为获得的怒气
		if($pa['hitrate_times'] > 0)
		{
			# pa(攻击方)拥有重击辅助属性，每次攻击额外获得1~2点怒气
			if(!empty($pa['ex_keys']) && in_array('c',$pa['ex_keys']))
			{
				$pa_rgup = rand(1,2);
				$pa['rage'] = min(255,$pa['rage']+$pa_rgup);
				# 成功发动战斗技时，额外返还10%怒气
				if(isset($pa['bskill']) && isset($pa['bskill_'.$pa['bskill']]))
				{
					$bsk = $pa['bskill'];
					$bsk_cost = get_skillragecost($bsk,'ragecost');
					if($bsk_cost)
					{
						$pa['rage'] += round($bsk_cost*0.1);
						# 必杀技能额外返还15点怒气
						if($bsk == 'c9_lb') $pa['rage'] += get_skillvars('c9_lb','rageback');
					}
				}
			}
		}
		# 无论攻击是否命中，计算pd(防守方)因挨打获得的怒气
		$rgup = round(($pa['lvl'] - $pd['lvl'])/3);
		# 单次获得怒气上限：15
		$rgup = min(15,max(1,$rgup));
		# 「灭气」技能效果
		if(isset($pd['skill_c1_burnsp'])) $rgup += rand(1,2);
		$pd['rage'] = min(255,$pd['rage']+$rgup);
		return;
	}

	# 战斗后结算rp事件
	function get_killer_rp(&$pa,&$pd,$active)
	{
		# 杀人rp结算
		$rpup = $pd['type'] ? 20 : max(80,$pd['rp']);
		if ($pa['clbpara']['BGMBrand'] == 'azure'){
			$check = diceroll(20);
			if ($check > 17){
				$pa['log'] .= "<span class=\"ltazure\">你想到了蓝凝的天真烂漫及没心没肺，<br>因此没受到杀人的罪恶感影响。<br></span>";
				$rpup = 0;
			}
		}
		rpup_rev($pa,$rpup);
		return;
	}

	# rp上涨事件
	function rpup_rev(&$pa,$rpup)
	{
		# 「转业」效果判定
		if(!check_skill_unlock('c19_reincarn',$pa))
		{
			$sk = 'c19_reincarn';
			$sk_lvl = get_skilllvl($sk,$pa);
			if($rpup > 0)
			{
				$sk_var = get_skillvars($sk,'rpgain',$sk_lvl);
				$rpup = round($rpup*(1-($sk_var/100)));
			}
			else
			{
				$sk_var = get_skillvars($sk,'rploss',$sk_lvl);
				$rpup = round($rpup*(1+($sk_var/100)));
			}
		}
		$pa['rp'] += $rpup;
	}

	# 经验上涨事件
	function expup_rev(&$pa,&$pd,$active)
	{
		global $log,$baseexp;

		# 「洁净」技能判定：战斗时无法获得经验值
		if(!empty($pa['clbpara']['skill']) && in_array('npc_purity', $pa['clbpara']['skill']))
		{
			$log.='<span class="yellow">「洁净」使'.$pa['nm'].'无法获得经验值！</span><br>';
			return;
		}

		# 攻击命中的情况下，计算获得经验
		if($pa['hitrate_times'] > 0)
		{
			$expup = round ( ($pd['lvl'] - $pa['lvl']) / 3 );
			$expup = $expup > 0 ? $expup : 1;
		}
		# 攻击未命中，也许有其他渠道获得经验
		else
		{
			#「反思」技能效果
			if(isset($pa['skill_c5_review'])) $expup = 1;
		}
		if(isset($pa['bskill_c10_decons']) && $pa['final_damage'] > $pd['hp'])
		{
			$sk_up = ceil($pd['lvl'] - ($pa['lvl']*0.15));
			if($sk_up > 0)
			{
				$log.='<span class="yellow">「解构」使'.$pa['nm'].'获得了额外'.$sk_up.'点经验！</span><br>';
				$expup += $sk_up;
			}
		}
		if(!empty($expup)) $pa['exp'] += $expup;
		//$log .= "$isplayer 的经验值增加 $expup 点<br>";

		//升到下级所需的exp 直接在这里套公式计算 不用global了
		$pa['upexp'] = round(($pa['lvl']*$baseexp)+(($pa['lvl']+1)*$baseexp));

		if ($pa['exp'] >= $pa['upexp'])
		{
			lvlup_rev ($pa,$pd,$active);
		}
		return;
	}

	# 等级提升事件
	function lvlup_rev(&$pa,&$pd,$active)
	{
		global $log,$baseexp,$upexp;
		if(empty($pa['nm'])) $pa['nm'] = $active ? '你' : $pa['name'];
		$up_exp_temp = round ( (2 * $pa['lvl'] + 1) * $baseexp );
		if ($pa['exp'] >= $up_exp_temp && $pa['lvl'] < 255)
		{
			$sklanginfo = Array ('wp' => '殴熟', 'wk' => '斩熟', 'wg' => '射熟', 'wc' => '投熟', 'wd' => '爆熟', 'wf' => '灵熟', 'all' => '全系熟练度' );
			$sknlist = Array (1 => 'wp', 2 => 'wk', 3 => 'wc', 4 => 'wg', 5 => 'wd', 9 => 'wf', 12 => 'all' );
			$skname = isset($sknlist[$pa['club']]) ? $sknlist[$pa['club']] : 0;
			//升级判断
			$lvup = 1 + floor (($pa['exp'] - $up_exp_temp)/$baseexp/2);
			$lvup = $lvup > 255 - $pa['lvl'] ? 255 - $pa['lvl'] : $lvup;
			$lvuphp = $lvupatt = $lvupdef = $lvupskill = $lvupsp = $lvupspref = 0;
			//升级数值计算
			for($i = 0; $i < $lvup; $i += 1)
			{
				if ($pa['club'] == 12) {
					$lvuphp += rand ( 14, 18 );
				} else {
					$lvuphp += rand ( 8, 10 );
				}
				$lvupsp += rand( 4,6);
				if ($pa['club'] == 12) {
					$lvupatt += rand ( 4, 6 );
					$lvupdef += rand ( 5, 8 );
				} else {
					$lvupatt += rand ( 2, 4 );
					$lvupdef += rand ( 3, 5 );
				}

				if ($skname == 'all') {
					$lvupskill += rand ( 2, 4 );
				}elseif ($skname == 'wf') {
					$lvupskill += rand ( 3, 5 );
				}elseif ($skname == 'wd') {
					$lvupskill += rand ( 6, 8 );
				}elseif($skname){
					$lvupskill += rand ( 4, 6 );
				}
				$lvupspref += round($pa['msp'] * 0.1);
			}
			//应用升级
			$pa['lvl'] += $lvup;
			$up_exp_temp = round ( (2 * $pa['lvl'] + 1) * $baseexp );
			if ($pa['lvl'] >= 255) {
				$pa['lvl'] = 255;
				$pa['exp'] = $up_exp_temp;
			}
			$pa['upexp'] = $up_exp_temp;
			$pa['hp'] += $lvuphp;
			$pa['mhp'] += $lvuphp;
			$pa['sp'] += $lvupsp;
			$pa['msp'] += $lvupsp;
			$pa['att'] += $lvupatt;
			$pa['def'] += $lvupdef;
			$pa['skillpoint'] += $lvup;
			if(!empty($skname))
			{
				if ($skname == 'all') {
					$pa['wp'] += $lvupskill;
					$pa['wk'] += $lvupskill;
					$pa['wg'] += $lvupskill;
					$pa['wc'] += $lvupskill;
					$pa['wd'] += $lvupskill;
					$pa['wf'] += $lvupskill;
				} elseif ($skname) {
					$pa[$skname] += $lvupskill;
				}
			}
			$pa['sp'] = min($lvupspref+$pa['sp'],$pa['msp']);

			if ($skname) {
				$sklog = "，{$sklanginfo[$skname]}+{$lvupskill}";
			}
			$lvlup_log = "<span class=\"yellow\">{$pa['nm']}升了{$lvup}级！生命上限+{$lvuphp}，体力上限+{$lvupsp}，攻击+{$lvupatt}，防御+{$lvupdef}";
			if(isset($sklog)) $lvlup_log .= $sklog;
			$lvlup_log .= "，体力恢复了{$lvupspref}，获得了{$lvup}点技能点！</span><br>";
			if(!$pa['type'])
			{
				if($pa['nm'] == '你') $log.= $lvlup_log;
				else $pa['lvlup_log'] = $lvlup_log;
			}
		} elseif ($pa['lvl'] >= 255) {
			$pa['lvl'] = 255;
			$pa['exp'] = $up_exp_temp;
		}
		$upexp = round(($pa['lvl']*$baseexp)+(($pa['lvl']+1)*$baseexp));
		return;
	}

	/*
	function kill($death, $dname, $dtype = 0, $dpid = 0, $annex = '', &$revival_flag=0) {
		global $now, $db, $tablepre, $gtablepre;
		global $alivenum, $deathnum, $name, $w_state, $type, $pid, $typeinfo, $pls, $lwinfo, $w_achievement;
		global $weather;

		if (! $death || ! $dname) {
			return;
		}

		if ($death == 'N') {
			$w_state = 20;
		} elseif ($death == 'P') {
			$w_state = 21;
		} elseif ($death == 'K') {
			$w_state = 22;
		} elseif ($death == 'G') {
			$w_state = 23;
		} elseif ($death == 'J') {
			$w_state = 23;
		} elseif ($death == 'C') {
			$w_state = 24;
		} elseif ($death == 'D') {
			$w_state = 25;
		} elseif ($death == 'F') {
			$w_state = 29;
		} elseif ($death == 'dn') {
			$w_state = 28;
		} else {
			$w_state = 10;
		}

		$killmsg = '';
		$result = $db->query ( "SELECT killmsg FROM {$gtablepre}users WHERE username = '$name'" );
		$killmsg = $db->result ( $result, 0 );

		if (! $dtype) {
			//$alivenum = $db->result($db->query("SELECT COUNT(*) FROM {$tablepre}players WHERE hp>0 AND type=0"), 0);
			$alivenum --;
		}
		$deathnum ++;


		if ($dtype) {
			$lwname = $typeinfo [$dtype] . ' ' . $dname;
			if (is_array ( $lwinfo [$dtype] )) {
				$lastword = $lwinfo [$dtype] [$dname];
			} else {
				$lastword = $lwinfo [$dtype];
			}

			$db->query ( "INSERT INTO {$tablepre}chat (type,`time`,send,recv,msg) VALUES ('3','$now','$lwname','$pls','$lastword')" );
		} else {
			$lwname = $typeinfo [$dtype] . ' ' . $dname;
			$result = $db->query ( "SELECT lastword FROM {$gtablepre}users WHERE username = '$dname'" );
			$lastword = $db->result ( $result, 0 );

			$db->query ( "INSERT INTO {$tablepre}chat (type,`time`,send,recv,msg) VALUES ('3','$now','$lwname','$pls','$lastword')" );
		}
		$result = $db->query("SELECT nick FROM {$tablepre}players WHERE name = '$name' AND type = '$type'");
		$knick = $db->result($result, 0);
		addnews ( $now, 'death' . $w_state, $dname, $dtype, $knick.' '.$name, $annex, $lastword );

		$result = $db->query("SELECT * FROM {$tablepre}players WHERE pid=$dpid" );
		$res=$db->fetch_array($result);

		$revivaled=false;
		//依次判定复活效果
		if (!$revival_flag && $weather == 17)
		{
			//include_once GAME_ROOT.'./include/game/dice.func.php';
			$aurora_rate = $dtype ? 1 : 10; //NPC概率1% 玩家概率10%
			$aurora_dice = diceroll(100);
			if($aurora_dice<=$aurora_rate)
			{
				//奥罗拉复活效果
				addnews($now,'aurora_revival',$res['name']);
				$res['hp'] += min($res['mhp'],max($aurora_dice,1)); $res['sp'] += min($res['msp'],max($aurora_dice,1));
				$res['state']=0;
				$alivenum++;
				$revival_flag = 17;
			}
		}
		if (!$revival_flag && $res['type']==0 && $res['club']==99 && ($death=="N" || $death=="P" || $death=="K" || $death=="G" || $death=="C" ||$death=="D" || $death=="F" || $death=="J" || $death=="trap"))
		{
			addnews($now,'revival',$res['name']);	//玩家春哥附体称号的处理
			$res['hp'] = $res['mhp']; $res['sp'] = $res['msp'];
			$res['club'] = 17; $res['state'] = 0;
			/*$db->query ( "UPDATE {$tablepre}players SET hp=mhp WHERE pid=$dpid" );
			$db->query ( "UPDATE {$tablepre}players SET sp=msp WHERE pid=$dpid" );
			$db->query ( "UPDATE {$tablepre}players SET club=17 WHERE pid=$dpid" );
			$db->query ( "UPDATE {$tablepre}players SET state=0 WHERE pid=$dpid" );
			$alivenum++;
			$revivaled = 99;
		}
		if (!$revivaled)
		{
			if($dtype == 15){//静流AI
				global $gamevars;
				unset($gamevars['act']);
				$gamevars['sanmadead'] = 1;
				save_gameinfo();
			}
			//$db->query ( "UPDATE {$tablepre}players SET hp='0',endtime='$now',deathtime='$now',bid='$pid',state='$w_state' WHERE pid=$dpid" );
		}

		player_save($res);
		save_gameinfo();
		return $killmsg;
	}

	function lvlup(&$lvl, &$exp, $isplayer = 1) {
		global $baseexp;
		$up_exp_temp = round ( (2 * $lvl + 1) * $baseexp );
		if ($exp >= $up_exp_temp && $lvl < 255) {
			if ($isplayer) {
				$perfix = '';
			} else {
				$perfix = 'w_';
			}
			global ${$perfix . 'name'}, ${$perfix . 'hp'}, ${$perfix . 'mhp'}, ${$perfix . 'sp'}, ${$perfix . 'msp'}, ${$perfix . 'att'}, ${$perfix . 'def'}, ${$perfix . 'upexp'}, ${$perfix . 'club'}, ${$perfix . 'type'}, ${$perfix . 'skillpoint'};
			global ${$perfix . 'wp'}, ${$perfix . 'wk'}, ${$perfix . 'wc'}, ${$perfix . 'wg'}, ${$perfix . 'wd'}, ${$perfix . 'wf'};
			$sklanginfo = Array ('wp' => '殴熟', 'wk' => '斩熟', 'wg' => '射熟', 'wc' => '投熟', 'wd' => '爆熟', 'wf' => '灵熟', 'all' => '全系熟练度' );
			$sknlist = Array (1 => 'wp', 2 => 'wk', 3 => 'wc', 4 => 'wg', 5 => 'wd', 9 => 'wf', 16 => 'all' );
			$skname = $sknlist [${$perfix . 'club'}];
			//升级判断
			$lvup = 1 + floor ( ($exp - $up_exp_temp) / $baseexp / 2 );
			$lvup = $lvup > 255 - $lvl ? 255 - $lvl : $lvup;
			$lvuphp = $lvupatt = $lvupdef = $lvupskill = $lvupsp = $lvupspref = 0;
			for($i = 0; $i < $lvup; $i += 1) {
				if (${$perfix . 'club'} == 13) {
					$lvuphp += rand ( 14, 18 );
				} else {
					$lvuphp += rand ( 8, 10 );
				}
				$lvupsp += rand( 4,6);
				if (${$perfix . 'club'} == 14) {
					$lvupatt += rand ( 4, 6 );
					$lvupdef += rand ( 5, 8 );
				} else {
					$lvupatt += rand ( 2, 4 );
					$lvupdef += rand ( 3, 5 );
				}

				if ($skname == 'all') {
					$lvupskill += rand ( 2, 4 );
				} elseif ($skname == 'wd' || $skname == 'wf') {
					$lvupskill += rand ( 3, 5 );
				}elseif($skname){
					$lvupskill += rand ( 4, 6 );
				}
				$lvupspref += round(${$perfix . 'msp'} * 0.1);
			}
			$lvl += $lvup;
			$up_exp_temp = round ( (2 * $lvl + 1) * $baseexp );
			if ($lvl >= 255) {
				$lvl = 255;
				$exp = $up_exp_temp;
			}
			${$perfix . 'upexp'} = $up_exp_temp;
			${$perfix . 'hp'} += $lvuphp;
			${$perfix . 'mhp'} += $lvuphp;
			${$perfix . 'sp'} += $lvupsp;
			${$perfix . 'msp'} += $lvupsp;
			${$perfix . 'att'} += $lvupatt;
			${$perfix . 'def'} += $lvupdef;
			${$perfix . 'skillpoint'} += $lvup;
			if ($skname == 'all') {
				${$perfix . 'wp'} += $lvupskill;
				${$perfix . 'wk'} += $lvupskill;
				${$perfix . 'wg'} += $lvupskill;
				${$perfix . 'wc'} += $lvupskill;
				${$perfix . 'wd'} += $lvupskill;
				${$perfix . 'wf'} += $lvupskill;
			} elseif ($skname) {
				${$perfix . $skname} += $lvupskill;
			}

			if (${$perfix . 'sp'}+$lvupspref >= ${$perfix . 'msp'}) {
				$lvupspref =  ${$perfix . 'msp'} - ${$perfix . 'sp'};

			}
			${$perfix . 'sp'} += $lvupspref;
			if ($skname) {
				$sklog = "，{$sklanginfo[$skname]}+{$lvupskill}";
			}
			if ($isplayer) {
				global $log;
				$log .= "<span class=\"yellow\">你升了{$lvup}级！生命上限+{$lvuphp}，体力上限+{$lvupsp}，攻击+{$lvupatt}，防御+{$lvupdef}{$sklog}，体力恢复了{$lvupspref}，获得了{$lvup}点技能点！</span><br>";
			} elseif (! $w_type) {
				global $w_pid, $now;
				$w_log = "<span class=\"yellow\">你升了{$lvup}级！生命上限+{$lvuphp}，体力上限+{$lvupsp}，攻击+{$lvupatt}，防御+{$lvupdef}{$sklog}，体力恢复了{$lvupspref}，获得了{$lvup}点技能点！</span><br>";
				logsave ( $w_pid, $now, $w_log,'s');
			}
		} elseif ($lvl >= 255) {
			$lvl = 255;
			$exp = $up_exp_temp;
		}
		return;
	}*/

	//玩家被攻击时的生命恢复未实现

	function calculate_rest_upsp($rtime,&$pa)
	{
		global $sleep_time,$db,$tablepre,$log;

		# 治疗姿态下恢复速率变为3倍
		if($pa['pose'] == 5) $rtime *= 3;
		$upsp = round ($pa['msp'] * $rtime / $sleep_time / 100 );

		# 灵子视界下，恢复速率受种火数量加成
		if($pa['horizon'] && $pa['sp'] < $pa['msp'])
		{
			$result = $db->query("SELECT pid FROM {$tablepre}players WHERE type=92 AND pls={$pa['pls']} AND hp>0 ");
			$nums = $db->num_rows($result);
			if($nums)
			{
				$log .= "在你闭目养神之际……似乎有什么东西戳了戳你的脸……<br>感觉身体轻松了不少。<br>";
				$upsp += $nums * 10 * $rtime;
			}
		}
		return $upsp;
	}
	function calculate_rest_uphp($rtime,&$pa)
	{
		global $heal_time,$db,$tablepre,$log;
		# 治疗姿态下恢复速率变为3倍
		if($pa['pose'] == 5) $rtime *= 3;
		$uphp = round ($pa['mhp'] * $rtime / $heal_time / 100 );

		# 灵子视界下，恢复速率受种火数量加成
		if($pa['horizon'] && $pa['hp'] < $pa['mhp'])
		{
			$result = $db->query("SELECT pid FROM {$tablepre}players WHERE type=92 AND pls={$pa['pls']} AND hp>0 ");
			$nums = $db->num_rows($result);
			if($nums)
			{
				$log .= "在你专心治疗伤口时……似乎有什么东西靠了过来……<br>伤口好像不那么疼了。<br>";
				$uphp += $nums * 10 * $rtime;
			}
		}
		return $uphp;
	}
	//静养获得怒气
	function calculate_rest_rageup($rtime,&$pa)
	{
		global $rage_time;
		$max_rage = 255;
		$rageup = round ($max_rage * $rtime / $rage_time / 100 );
		if (strpos ( $pa['inf'], 'h' ) !== false) {//脑袋受伤不容易愤怒（
			$rageup = round ( $rageup / 2 );
		}
		return $rageup;
	}
	function rest($command,&$data=NULL) {
		//global $now, $log, $mode, $cmd, $state, $endtime, $hp, $mhp, $sp, $msp, $sleep_time, $heal_time, $restinfo, $pose, $inf,$club,$exdmginf;
		global $now,$log,$mode,$cmd,$sleep_time,$heal_time,$restinfo,$exdmginf;
		global $pdata;

		if(!isset($data))
		{
			global $pdata;
			$data = &$pdata;
		}
		extract($data,EXTR_REFS);

		$resttime = $now - $endtime;
		$endtime = $now;

		//If you are dead, resting won't do you any good!
		if ($hp <= 0) {
			$log .= "你的大脑觉得你可能可以抢救一下，但你的心脏却突然掀开胸膛破口大骂：<span class=\"yellow\">“死都死了，治个屁！火化吧！”</span><br>
			看起来这下治疗也没有什么用处了。<br>";
			$log .= "你已经死亡，无法治疗。<br>";
			return;
		}

		if ($state == 1) rest_get_tips($resttime);

		if ($state == 1 || $state == 3) {
			$oldsp = $sp;
			$upsp = calculate_rest_upsp($resttime,$data);
			$sp += $upsp; $sp = min($sp, $msp);
			$upsp = $sp - $oldsp;
			$upsp=max(0,$upsp);
			if(!$upsp && $sp >= $msp) $log .= "已经不需要休息了。";
			else $log .= "你的体力恢复了<span class=\"yellow\">$upsp</span>点。";
		}

		if ($state == 2 || $state == 3) {
			$oldhp = $hp;
			$uphp = calculate_rest_uphp($resttime,$data);
			$hp += $uphp; $hp = min($hp, $mhp);
			$uphp = $hp - $oldhp;
			$uphp=max(0,$uphp);

			# 「起迹」标记清除：
			if($uphp > 0 && isset($clbpara['tl_oncemore_used'])) {
				unset($clbpara['tl_oncemore_used']);
				$log .= "<span class='yellow'>「起迹」技能恢复了效果！</span><br>";
			}

			if(!$uphp && $hp >= $mhp) $log .= "没有伤口需要治疗了。";
			else $log .= "你的生命恢复了<span class=\"yellow b\">$uphp</span>点。";
		}

		if($state == 3)
		{
			if($pose != 8)
			{
				$rageup = min(255-$rage,calculate_rest_rageup($resttime,$data));
				$rage += $rageup;
				$log .= "<br>但你在病床上辗转反侧，脑中回忆起种种倒霉遭遇，忍不住越想越气！<br>怒气增加了<span class=\"yellow\">$rageup</span>点！";
			}
			if (!empty($inf))
			{
				$refintv = 90;
				if ($pose == 5) {
					$refintv -= 30;
				}
				if (strpos ( $inf, 'b' ) !== false) {
					$refintv += 30;
				}
				$spinf = preg_replace("/[h|b|a|f]/", "", $inf);
				$spinflength = strlen($spinf);
				if($spinf){
					$refflag = false;
					do{
						$dice = rand(0,$refintv);
						if($dice + 15 < $resttime){
							$infno = rand(0,$spinflength-1);
							$refinfstr = substr($spinf,$infno,1);
							$inf = str_replace($refinfstr,'',$inf);
							$spinf = str_replace($refinfstr,'',$spinf);
							$log .= "<span class=\"yellow\">你从{$exdmginf[$refinfstr]}状态中恢复了！</span><br>";
							$spinflength -= 1;
							$refflag = true;
						}
						$resttime -= $refintv;
					} while ($resttime > 0 && $spinflength > 0);
					if(!$refflag){
						$log .= "也许是时间不够吧……你没有治好任何异常状态。<br>";
					}
				}
			}
		}

		$log .= '<br>';

		// 如果命令不是 rest 或 fishing，则退出休息状态
		if ($command != 'rest' && $command != 'fishing') {
			$state = 0;
			$endtime = $now;
			$mode = 'command';
		}
		return;
	}

	function rest_get_tips($resttime)
	{
		global $db, $tablepre, $plsinfo, $log;

		//睡眠时，每隔多少秒获得一条提示
		$rest_get_tip_rate = 30;
		//睡眠时，一次最多获得多少条提示
		$rest_get_tip_max = 15;
		//睡眠时会提示的NPC类别，依次是全息，豆腐，黑幕，真职人，DF，妖精，女主，武神，巫师，歌神，电掣
		$tip_npctype = array(2,5,6,11,12,13,14,21,24,26,89);
		//睡眠时会提示的道具名列表
		$tip_itemnamelist = array('肥料', '中药', '火把', '铁锤', '广域生命探测器', '★阔剑地雷★', '毒物说明书', '☆碧藍怒火☆', '☆白楼剑☆', '☆楼观剑☆', '钻石', '宅男装', '萝莉装', '女仆装', '伪娘装', '电子马克笔', '一个能打的都没有', '德国BOY的键盘', '葱娘の葱', '容嬷嬷的针', '新八的眼镜', '新华里的领带', '新华里的西服', '新华里的手表', '新华里的皮鞋', '新华里的投入', '新华里的震撼', '新华里的乱舞', '新华里的手势', '新华里的呐喊', '新华里的眼神', '新华里的增员', '红色方块', '绿色方块', '蓝色方块', '黄色方块', '金色方块', '银色方块', '水晶方块', '黑色方块', '白色方块', 'X方块', 'Y方块', '妹汁', '《BR大逃杀》', '《防身术图解》', '《剑道社教材》', '《枪械杂志》', '《飞镖投掷法》', '《化学课本》', '《太极拳指南》', '【腕力强化剂】', '【皮肤强化剂】', '【神经强化剂】', '【超级战士药剂】', '【肉体强化剂】', '【线粒体强化剂】', '提示纸条E', '提示纸条I', '提示纸条K', '提示纸条N', '弱点探测器', '【北斗百裂拳】', '【狂暴凶刃】', '【盖特机炮】', '幻符【杀人玩偶】', '【泰迪熊炸弹】', '【西方秋霜玉】', '预言挂坠', '【紫棠花色波纹疾走】', '弱爆了！', '《哲♂学》', '★全图唯一的野生巨大香蕉★', '残存的礼品盒', '残存的结婚喜糖-红', '残存的结婚喜糖-橙', '残存的结婚喜糖-黄', '残存的结婚喜糖-绿', '残存的结婚喜糖-青', '残存的结婚喜糖-蓝', '残存的结婚喜糖-紫', '糖衣炮弹-红', '糖衣炮弹-橙', '糖衣炮弹-黄', '糖衣炮弹-绿', '糖衣炮弹-青', '糖衣炮弹-蓝', '糖衣炮弹-紫', '密封的酒瓶', '音乐录像', '五线乐谱', '葱娘肉包', 'V家蔬菜汁', '破旧录音机', '神奇的八音盒', '魂之结晶', '歌手之魂', '【Alicemagic】', '【Crow Song】', '「奥西里斯之天空龙」-仮', '「欧贝利斯克之巨神兵」-仮', '「太阳神之翼神龙」-仮', '【流星一条】', '杨叔的眼镜', '蓝蓝路的大鞋', '动感超人手表', 'MIKU的内裤', '■DeathNote■', '■魔剑－雷瓦丁■', '★Unlimited Blade Works★', '★Unlimited Code Works★', '《ACFUN大逃杀攻略》', '《北斗神拳》', '《寒蝉鸣泣之时》', '《魔法少女奈叶》', '《网球王子》', '《新机动战记高达W》', '《东方永夜抄》', '【触手的萃取液】', '【圣防护罩-反射之力】', '【金蚕王】', '【我已经天下无敌了！】', '【残机碎片】', '【S2机关】', '【宇航服】', '【楼主头】', '【哥哥鞋】', '受王拳', '★闪光迎击神话★', '鲜红的生血', '《东方幻想乡》', '★I-力场★', '奇怪的按钮', '【主角光环】', '【测试用具】', '驱云弹');

		$get_tips_count = floor($resttime / $rest_get_tip_rate);
		if (rand(0,99) < $resttime) $get_tips_count += 1;//奖励骰
		$get_tips_count = min($get_tips_count, $rest_get_tip_max);
		if ($get_tips_count > 0)
		{
			$tips = array();
			//高伤雷提示
			if (rand(0,3) == 0)
			{
				$result = $db->query("SELECT * FROM {$tablepre}maptrap WHERE itme>=600");
				while($traparr = $db->fetch_array($result)){
					$traps[] = $traparr;
				}
				shuffle($traps);
				$tips[] = "你梦见自己在<span class=\"yellow b\">{$plsinfo[$traps[0]['pls']]}</span>被<span class=\"yellow b\">{$traps[0]['itm']}</span>炸上了天。<br>……<br>";
				$get_tips_count -= 1;
			}
			if ($get_tips_count > 0)
			{
				//重要NPC提示
				$enemytip_count = rand(0, ceil($get_tips_count/2));
				if ($enemytip_count > 0)
				{
					//小概率梦出一个高级小兵
					if ($enemytip_count > 1 && rand(0,99) < 30)
					{
						$summon_ids = addnpc(93,rand(0,24),1);
						if (!empty($summon_ids))
						{
							$tip_edata = fetch_playerdata_by_pid($summon_ids[0]);
							$tips[] = "你梦见<span class=\"red b\">{$tip_edata['name']}</span>在<span class=\"yellow b\">{$plsinfo[$tip_edata['pls']]}</span>游荡。<br>……<br>";
							$enemytip_count -= 1;
						}
					}
					$tip_edata_arr = array();
					$result = $db->query("SELECT name,type,pls FROM {$tablepre}players WHERE hp>0 AND type>0");
					while($r = $db->fetch_array($result)){
						if (in_array((int)$r['type'], $tip_npctype)) $tip_edata_arr[] = $r;
					}
					if (count($tip_edata_arr) == 0) $enemytip_count = 0;
					else
					{
						$tip_edata = array_randompick($tip_edata_arr, $enemytip_count);
						if (isset($tip_edata['name']))
						{
							$tips[] = "你梦见<span class=\"red b\">{$tip_edata['name']}</span>在<span class=\"yellow b\">{$plsinfo[$tip_edata['pls']]}</span>游荡。<br>……<br>";
							$enemytip_count = 1;
						}
						else
						{
							foreach($tip_edata as $ed) {
								$tips[] = "你梦见<span class=\"red b\">{$ed['name']}</span>在<span class=\"yellow b\">{$plsinfo[$ed['pls']]}</span>游荡。<br>……<br>";
							}
							$enemytip_count = count($tip_edata);
						}
					}
				}
				//特定道具提示
				$itemtip_count = $get_tips_count - $enemytip_count;
				if ($itemtip_count > 0)
				{
					$result = $db->query("SELECT itm,pls FROM {$tablepre}mapitem");
					while($r = $db->fetch_array($result)){
						if (in_array($r['itm'], $tip_itemnamelist)) $tip_mipool[] = $r;
					}
					if (count($tip_mipool) > 0)
					{
						$tip_mi = array_randompick($tip_mipool, $itemtip_count);
						if (isset($tip_mi['itm']))
						{
							$tips[] = "你梦见自己在<span class=\"yellow b\">{$plsinfo[$tip_mi['pls']]}</span>捡到了<span class=\"yellow b\">{$tip_mi['itm']}</span>。<br>……<br>";
						}
						else
						{
							foreach($tip_mi as $mi) {
								$tips[] = "你梦见自己在<span class=\"yellow b\">{$plsinfo[$mi['pls']]}</span>捡到了<span class=\"yellow b\">{$mi['itm']}</span>。<br>……<br>";
							}
						}
					}
				}
			}
			shuffle($tips);
			$log .= implode('',$tips);
		}
	}

	function array_randompick($arr, $num=1)
	{
		$array_rand = array_rand($arr, $num);
		if(is_array($array_rand)) {
			$ret = Array();
			foreach($array_rand as $v) {
				$ret[$v] = $arr[$v];
			}
		}else{
			$ret = $arr[$array_rand];
		}
		return $ret;
	}

?>
