# PHPDTS 游戏技术文档

## 项目概述

PHPDTS (PHP Death Tournament System) 是一个基于PHP的多人在线生存竞技游戏系统。游戏采用回合制机制，玩家在地图上移动、探索、战斗，最终目标是成为最后的生存者。

## 版本信息

- **文档版本**: nouveau_250609
- **生成时间**: 2025年6月9日
- **适用版本**: 当前开发版本

## 目录结构

```
phpdts/
├── admin.php                 # 管理员界面
├── api.php                   # API接口
├── game.php                  # 游戏主界面
├── user.php                  # 用户管理
├── command.php               # 命令处理
├── config.inc.php            # 主配置文件
├── include/                  # 核心功能库
│   ├── common.inc.php        # 公共包含文件
│   ├── game/                 # 游戏逻辑模块
│   ├── admin/                # 管理功能模块
│   └── ...
├── gamedata/                 # 游戏数据
│   ├── cache/                # 缓存文件
│   ├── sql/                  # 数据库结构
│   └── ...
├── templates/                # 模板文件
├── img/                      # 图片资源
├── map/                      # 地图文件
└── doc/                      # 文档目录
```

## 核心系统架构

### 1. 数据库架构

游戏使用MySQL数据库，主要表结构包括：

- `{prefix}_users`: 用户账户信息
- `{prefix}_players`: 游戏内角色数据
- `{prefix}_game`: 游戏状态信息
- `{prefix}_chat`: 聊天记录
- `{prefix}_mapitem`: 地图物品
- `{prefix}_maptrap`: 地图陷阱

### 2. 配置系统

- **主配置**: `config.inc.php` - 数据库连接、基础设置
- **游戏配置**: `gamedata/cache/gamecfg_1.php` - 游戏规则参数
- **资源配置**: `gamedata/cache/resources_1.php` - 游戏资源定义
- **战斗配置**: `gamedata/cache/combatcfg_1.php` - 战斗系统参数

### 3. 模板系统

使用自定义模板系统，模板文件位于 `templates/default/` 目录：

- 支持PHP代码嵌入
- 变量自动提取
- 模板缓存机制

## 主要功能模块

### 1. 用户系统
- 用户注册、登录、密码管理
- 用户资料编辑
- 积分系统（credits/credits2）
- 成就系统

### 2. 游戏核心
- 角色创建与管理
- 地图移动系统
- 探索机制
- 禁区系统

### 3. 战斗系统
- 回合制战斗
- 武器装备系统
- 技能系统
- 伤害计算

### 4. 物品系统
- 物品分类管理
- 背包系统
- 物品合成
- 商店系统

### 5. 社团系统
- 多种社团类型
- 社团专属技能
- 特殊机制（如枫火歌者的种火系统）

## 开发指南

### 环境要求

- PHP 7.4+
- MySQL 5.7+
- Web服务器（Apache/Nginx）

### 开发规范

1. **文件编码**: UTF-8
2. **代码风格**: 遵循PSR标准
3. **数据库**: 使用预处理语句防止SQL注入
4. **安全**: 输入验证、输出转义

### 调试工具

- `devtools.php`: 开发工具集合
- 日志系统: 记录在 `gamedata/` 目录
- 错误处理: 统一错误页面

## 部署说明

### 安装步骤

1. 上传文件到Web目录
2. 配置数据库连接
3. 运行安装脚本
4. 设置目录权限

### 配置要点

- 确保 `gamedata/` 目录可写
- 配置数据库连接参数
- 设置管理员账户

## 维护指南

### 日常维护

- 定期备份数据库
- 清理日志文件
- 监控系统性能

### 故障排除

- 检查错误日志
- 验证数据库连接
- 确认文件权限

## 扩展开发

### 添加新功能

1. 在 `include/game/` 下创建功能文件
2. 在相应模板中添加界面
3. 更新配置文件
4. 测试功能完整性

### 数据库变更

1. 在 `gamedata/sql/` 下添加SQL文件
2. 更新安装脚本
3. 提供升级脚本

## 技术支持

如需技术支持或报告问题，请参考：

- 项目文档目录 `doc/`
- 开发日志 `doc/etc/`
- 源代码注释

---

*本文档由系统自动生成，如有疑问请联系开发团队。*
