# 钓鱼功能实装与除错记录

本文档整合了钓鱼功能的实装和除错过程，包括功能设计、实现步骤和问题修复。

## 1. 功能设计

### 1.1 基本钓鱼功能

- 玩家可以在特定地点（雪之镇、清水池、夏之镇、索拉利斯、永恒的世界）进行钓鱼活动
- 钓鱼时，玩家有机会获得各种物品，包括鱼类和其他物品
- 钓到的物品会存入鱼篓子中，玩家可以从中选择获取物品
- 钓鱼效率受装备影响，如果玩家装备了钓竿（名称中包含"钓竿"或"钓鱼竿"），钓鱼效率会提高

### 1.2 属性提升功能

- 钓鱼过程中，玩家有机会随机提升基础属性（攻击力、防御力、最大生命值、最大体力值）
- 属性提升的概率和幅度可以通过配置文件进行调整
- 属性提升会在日志中显示，让玩家知道自己获得了什么提升

### 1.3 鱼篓子功能

- 钓到的物品会自动存入鱼篓子中
- 鱼篓子是一种特殊物品（Z类型），可以存储多个物品
- 玩家可以使用鱼篓子，查看里面的物品列表，并选择一个物品取出
- 如果鱼篓子中的物品被取完，鱼篓子会自动消失

## 2. 实现步骤

### 2.1 基本钓鱼功能实现

1. 创建 `fishing.func.php` 文件，实现钓鱼的核心逻辑
2. 在 `rest.php` 文件中添加钓鱼按钮和相关处理代码
3. 创建 `fishing.php` 文件，处理钓鱼请求
4. 创建 `templates/default/fishing.htm` 模板文件，显示钓鱼界面
5. 实现钓鱼物品的随机生成和获取逻辑
6. 实现鱼篓子功能，将钓到的物品存入鱼篓子中

### 2.2 属性提升功能实现

1. 在 `fishing.func.php` 文件中添加属性提升逻辑
2. 实现随机属性提升的概率和幅度计算
3. 在日志中显示属性提升信息

### 2.3 鱼篓子功能实现

1. 创建 `item.nouveau_booster1.php` 文件，实现鱼篓子的使用逻辑
2. 创建 `templates/default/fish_basket.htm` 模板文件，显示鱼篓子界面
3. 实现从鱼篓子中选择和获取物品的功能
4. 在 `command.php` 文件中添加对 `choose_fish` 命令的处理

## 3. 问题修复

### 3.1 钓鱼地点判断问题

**问题**：钓鱼功能只能在特定地点使用，但判断逻辑使用了地点名称字符串，而不是地点ID，导致可能出现判断错误。

**解决方案**：
- 修改钓鱼地点判断逻辑，使用地点ID（$pls）而不是地点名称字符串
- 在 `fishing.func.php` 文件中添加钓鱼地点ID列表，用于判断玩家是否在可钓鱼的地点

### 3.2 钓鱼与休息状态冲突问题

**问题**：当玩家在休息/治疗/治疗状态下点击钓鱼按钮时，会退出休息状态，而不是同时保持休息和钓鱼状态。

**解决方案**：
- 修改 `rest.php` 文件中的钓鱼按钮处理逻辑，使其在进入钓鱼状态的同时保持休息状态
- 在 `fishing.php` 文件中添加对休息状态的保持逻辑

### 3.3 鱼篓子使用问题

**问题**：鱼篓子功能存在多个问题，包括：
1. 物品名称显示为Unicode编码而不是实际的中文字符
2. 选择界面没有正确显示，只显示了字符串 "choose_fish"
3. 点击返回按钮没有反应，应该返回之前的步骤（背包界面）
4. 选择了物品并点击"取出选中物品"后，无法获得物品

**解决方案**：
1. 修改 `fishing.func.php` 文件中的 `json_encode` 调用，添加 `JSON_UNESCAPED_UNICODE` 选项，确保中文字符能够正确存储和显示
2. 创建专门的模板文件 `fish_basket.htm`，用于显示鱼篓子界面
3. 修改返回按钮的 JavaScript 代码，正确设置 `mode` 变量
4. 完全重写 `item.nouveau_booster1.php` 文件，使其结构更加清晰，并修复物品选择和获取功能

## 4. 最终实现

### 4.1 文件结构

- `include/game/fishing.func.php`：钓鱼功能的核心逻辑
- `include/game/item.nouveau_booster1.php`：鱼篓子的使用逻辑
- `include/game/fishing.php`：处理钓鱼请求
- `templates/default/fishing.htm`：钓鱼界面模板
- `templates/default/fish_basket.htm`：鱼篓子界面模板

### 4.2 功能流程

1. **开始钓鱼**：
   - 玩家在特定地点（雪之镇、清水池、夏之镇、索拉利斯、永恒的世界）点击钓鱼按钮
   - 系统检查玩家是否在可钓鱼的地点，如果是，则进入钓鱼状态
   - 如果玩家装备了钓竿（名称中包含"钓竿"或"钓鱼竿"），钓鱼效率会提高

2. **钓鱼过程**：
   - 系统随机生成钓鱼结果，包括物品和属性提升
   - 钓到的物品会自动存入鱼篓子中
   - 属性提升会在日志中显示

3. **使用鱼篓子**：
   - 玩家使用鱼篓子，会看到一个专门的界面，显示里面所有物品的列表
   - 玩家可以选择一个物品，然后点击"取出选中物品"按钮取出该物品
   - 如果玩家没有选择物品就点击"取出选中物品"按钮，会提示选择一个物品
   - 如果玩家不想取出任何物品，可以点击"返回"按钮返回到命令界面
   - 如果鱼篓子中的物品被取完，鱼篓子会自动消失

### 4.3 配置参数

- **钓鱼地点**：雪之镇、清水池、夏之镇、索拉利斯、永恒的世界
- **钓鱼效率提升**：如果玩家装备了钓竿（名称中包含"钓竿"或"钓鱼竿"），钓鱼效率会提高
- **属性提升概率**：可以通过配置文件进行调整
- **属性提升幅度**：可以通过配置文件进行调整

## 5. 总结

钓鱼功能是一个复杂的系统，包括多个子功能和交互逻辑。通过本次实装和除错，我们成功实现了一个完整的钓鱼系统，包括基本钓鱼功能、属性提升功能和鱼篓子功能。在实装过程中，我们遇到了多个问题，包括钓鱼地点判断问题、钓鱼与休息状态冲突问题和鱼篓子使用问题，并成功解决了这些问题。

最终，我们得到了一个功能完善、交互友好的钓鱼系统，为游戏增添了新的玩法和乐趣。
