# bothost 任务量化清单

> 目标：在**不修改 PHPDTS 主体代码**的前提下，在独立目录 `bothost/` 内实现可部署在服务器 A 的远程 BOT 守护方案。

## 任务点（量化）

1. **需求拆分与边界确认（1 点）**
   - 明确方案仅新增 `bothost/`，不改动仓库其他目录。
   - 确认通过 HTTP 直接拉起 `bot/revbotservice.php`，避免依赖目标机 shell 脚本。

2. **配置模型设计（2 点）**
   - 支持多目标服务器（`targets[]`）。
   - 每个目标支持 BOT 并发数（`workers`）与网络超时、重连、请求头等参数。

3. **远程拉起与守护（3 点）**
   - 每个 worker 长连接到目标 `revbotservice.php`。
   - 连接断开、超时、异常后自动重连。
   - 支持信号退出（SIGINT/SIGTERM）并停止所有 worker。

4. **状态检测与生命周期管理（3 点）**
   - 解析输出中的“当前游戏状态/BOT 初始化/行动完成/等待中”等关键行。
   - 维护每个 worker 的状态：连接态、重启次数、错误次数、最近输出。
   - 周期打印汇总，便于实时观测 bot 存活与游戏状态。

5. **可用性交付（2 点）**
   - 提供 `config.example.json`。
   - 提供运行文档（启动/停止/部署建议/限制说明）。

总计：**11 个任务点**。

## 关于“是否改动 PHPDTS 主体代码”

本实现**没有**改动 PHPDTS 主体（仓库根目录既有逻辑）。

说明：
- 通过复用已存在的 `bot/revbotservice.php` 机制实现远程触发与守护，不需要新增 PHP 接口。
- 若目标站点限制直接访问 `bot/revbotservice.php`（如 WAF、鉴权、执行时长限制），才需要在目标环境做运维层调整（非本仓库代码变更）。
