<?php

if(!defined('IN_GAME')) {
    exit('Access Denied');
}

// Nouveau Template Language Pack
// Multi-language support for Nouveau template

// 检测语言设置，默认中文
$nouveau_lang = isset($_COOKIE['nouveau_lang']) ? $_COOKIE['nouveau_lang'] : 'zh';
if(!in_array($nouveau_lang, ['zh', 'en'])) {
    $nouveau_lang = 'zh';
}

// 中文语言包
$language_zh = array(
    // 基础界面
    'title' => 'PHPDTS - 虚拟现实大逃杀',
    'index' => '首页',
    'messages' => '消息',
    'user' => '用户',
    'register' => '注册',
    'game' => '游戏',
    'map' => '地图',
    'news' => '新闻',
    'alive' => '在线',
    'winner' => '获胜者',
    'rank' => '排行榜',
    'help' => '帮助',
    'admin' => '管理',
    'report' => '论坛',
    'donate' => '支持',
    'vnworld' => 'VN世界',
    'homepage' => '主页',

    // 游戏界面
    'level' => '等级',
    'exp' => '经验',
    'team' => '队伍',
    'club' => '称号',
    'att' => '攻击',
    'def' => '防御',
    'money' => '金钱',
    'moneyunit' => '元',
    'inf' => '状态',
    'pose' => '姿态',
    'tactic' => '战术',
    'hp' => '生命值',
    'sp' => '技能值',
    'ss' => '特技值',
    'skillpoint' => '技能点',
    'rage' => '怒气',
    'killnum' => '击杀',
    'weather' => '天气',
    'gamedate' => '游戏时间',
    'combo' => '连击模式',
    'duel' => '决斗模式',

    // 武器技能
    'wp' => '刺击',
    'wk' => '斩击',
    'wg' => '打击',
    'wc' => '投掷',
    'wd' => '射击',
    'wf' => '特殊',
    'skill' => '技能',

    // 物品栏
    'pack' => '背包',

    // 聊天
    'chat' => '通讯频道',
    'send' => '发送',
    'refresh' => '刷新',
    'chatswitch' => '切换模式',
    'emoji' => '表情',

    // 用户界面
    'gender' => '性别',
    'icon' => '头像',
    'male' => '男性',
    'female' => '女性',

    // 操作
    'login' => '登录',
    'logout' => '登出',
    'submit' => '提交',
    'cancel' => '取消',
    'confirm' => '确认',
    'back' => '返回',
    'next' => '下一步',
    'previous' => '上一步',
    'save' => '保存',
    'load' => '加载',
    'delete' => '删除',
    'edit' => '编辑',
    'view' => '查看',
    'search' => '搜索',
    'filter' => '筛选',
    'sort' => '排序',
    'export' => '导出',
    'import' => '导入',
    
    // Status Messages
    'success' => 'SUCCESS',
    'error' => 'ERROR',
    'warning' => 'WARNING',
    'info' => 'INFO',
    'loading' => 'LOADING',
    'processing' => 'PROCESSING',
    'complete' => 'COMPLETE',
    'failed' => 'FAILED',
    'timeout' => 'TIMEOUT',
    'offline' => 'OFFLINE',
    'online' => 'ONLINE',
    'connected' => 'CONNECTED',
    'disconnected' => 'DISCONNECTED',
    
    // Game States
    'alive' => 'ALIVE',
    'dead' => 'TERMINATED',
    'injured' => 'INJURED',
    'healthy' => 'HEALTHY',
    'critical' => 'CRITICAL',
    'poisoned' => 'POISONED',
    'burned' => 'BURNED',
    'frozen' => 'FROZEN',
    'paralyzed' => 'PARALYZED',
    'confused' => 'CONFUSED',
    
    // Equipment
    'weapon' => 'WEAPON',
    'armor' => 'ARMOR',
    'accessory' => 'ACCESSORY',
    'item' => 'ITEM',
    'equipment' => 'EQUIPMENT',
    'inventory' => 'INVENTORY',
    'durability' => 'DURABILITY',
    'effect' => 'EFFECT',
    'quality' => 'QUALITY',
    'rarity' => 'RARITY',
    
    // Combat
    'battle' => 'COMBAT',
    'attack' => 'ATTACK',
    'defend' => 'DEFEND',
    'dodge' => 'EVADE',
    'block' => 'BLOCK',
    'critical' => 'CRITICAL',
    'miss' => 'MISS',
    'hit' => 'HIT',
    'damage' => 'DAMAGE',
    'heal' => 'HEAL',
    'buff' => 'ENHANCE',
    'debuff' => 'WEAKEN',
    
    // Locations
    'location' => 'LOCATION',
    'area' => 'AREA',
    'zone' => 'ZONE',
    'sector' => 'SECTOR',
    'district' => 'DISTRICT',
    'building' => 'BUILDING',
    'room' => 'ROOM',
    
    // Time
    'time' => 'TIME',
    'date' => 'DATE',
    'hour' => 'HOUR',
    'minute' => 'MINUTE',
    'second' => 'SECOND',
    'day' => 'DAY',
    'week' => 'WEEK',
    'month' => 'MONTH',
    'year' => 'YEAR',
    'now' => 'NOW',
    'today' => 'TODAY',
    'yesterday' => 'YESTERDAY',
    'tomorrow' => 'TOMORROW',
    
    // Numbers
    'first' => 'FIRST',
    'second' => 'SECOND',
    'third' => 'THIRD',
    'last' => 'LAST',
    'total' => 'TOTAL',
    'count' => 'COUNT',
    'number' => 'NUMBER',
    'amount' => 'AMOUNT',
    'quantity' => 'QUANTITY',
    
    // Nouveau特有界面
    'nouveau_welcome' => '欢迎使用NOUVEAU界面',
    'nouveau_version' => 'NOUVEAU v2.0',
    'nouveau_theme' => '主题',
    'nouveau_settings' => '界面设置',
    'nouveau_features' => '功能特性',
    'nouveau_help' => 'NOUVEAU帮助',
    'nouveau_about' => '关于NOUVEAU',
    'nouveau_feedback' => '反馈',
    'nouveau_beta' => '测试版本',
    'nouveau_stable' => '稳定版本',
    'nouveau_experimental' => '实验性',
    'nouveau_interface' => 'NOUVEAU界面',
    'nouveau_loading' => '正在加载NOUVEAU界面...',
    'nouveau_ready' => 'NOUVEAU界面就绪',
    'nouveau_error' => 'NOUVEAU界面加载失败',

    // 主题
    'theme_cyber_blue' => '赛博蓝',
    'theme_cyber_purple' => '霓虹紫',
    'theme_cyber_green' => '矩阵绿',
    'theme_cyber_orange' => '合成波橙',
    'theme_cyber_pink' => '蒸汽波粉',
    'theme_changed' => '主题已切换',
    'theme_cycle' => '循环主题',

    // 界面元素
    'command_interface' => '指令界面',
    'system_panel' => '系统面板',
    'system_log' => '系统日志',
    'quick_actions' => '快速操作',
    'status_info' => '状态信息',
    'combat_engaged' => '战斗开始',
    'recovery_mode' => '恢复模式',
    'system_terminated' => '系统终止',
    'spectator_mode' => '观察者模式',
    'energy_levels' => '能量等级',
    'game_stats' => '游戏统计',
    'detailed_info' => '详细信息',
    'fireseed_status' => '火种状态',
    'interface_ready' => '界面就绪',
    'processing' => '处理中',
    'operational' => '运行中',
    'offline' => '离线',
    'online' => '在线',
    'connected' => '已连接',
    'disconnected' => '已断开',
    'move' => '移动',
    'attack' => '攻击',
    'defend' => '防御',
    'use_item' => '使用物品',
    'escape' => '逃跑',
    'skills' => '技能',
    'continue' => '继续',
    'wake_up' => '醒来',
    'survivors' => '幸存者',
    'eliminated' => '已淘汰',
    'participants' => '参与者',
    'remaining' => '剩余',
    'session' => '会话',
    'next_session' => '下一场游戏',
    'final_transmission' => '最后传输',
    'termination_report' => '终止报告',
    'survival_time' => '生存时间',
    'eliminations' => '击杀数',
    'cause_termination' => '终止原因',
    'recovery_status' => '恢复状态',
    'recovery_time' => '恢复时间',
    'recovery_complete' => '恢复完成',
    'hp_recovery' => '生命恢复',
    'sp_recovery' => '技能恢复',
    'status_effects' => '状态效果',
    'clearing' => '清除中',
    'clear' => '清除',
    'current_vitals' => '当前生命体征',
    'health_points' => '生命值',
    'skill_points' => '技能值',
    'special_skills' => '特技值',
    'recovery_options' => '恢复选项',
    'recovery_tips' => '恢复提示',
    'recovery_benefits' => '恢复益处',
    'important_notes' => '重要提示',
    'combat_actions' => '战斗行动',
    'tactical_advice' => '战术建议',
    'combat_tips' => '战斗提示',
    'your_status' => '你的状态',
    'enemy_status' => '敌人状态',
    'threat' => '威胁',
    'hostile' => '敌对',
    'combat_warning' => '战斗警告',
    'combat_log' => '战斗日志',
    'special_abilities' => '特殊能力',
    'emergency' => '紧急情况',
    'self_destruct' => '自毁',
    'language' => '语言',
    'chinese' => '中文',
    'english' => 'English',
    'switch_language' => '切换语言',
    
    // Interface Elements
    'sidebar' => 'SIDEBAR',
    'header' => 'HEADER',
    'footer' => 'FOOTER',
    'navigation' => 'NAVIGATION',
    'menu' => 'MENU',
    'panel' => 'PANEL',
    'tab' => 'TAB',
    'button' => 'BUTTON',
    'link' => 'LINK',
    'form' => 'FORM',
    'input' => 'INPUT',
    'output' => 'OUTPUT',
    'display' => 'DISPLAY',
    'window' => 'WINDOW',
    'dialog' => 'DIALOG',
    'modal' => 'MODAL',
    'popup' => 'POPUP',
    'tooltip' => 'TOOLTIP',
    'notification' => 'NOTIFICATION',
    'alert' => 'ALERT',
    'banner' => 'BANNER',
    'card' => 'CARD',
    'list' => 'LIST',
    'table' => 'TABLE',
    'grid' => 'GRID',
    'chart' => 'CHART',
    'graph' => 'GRAPH',
    'progress' => 'PROGRESS',
    'status' => 'STATUS',
    'indicator' => 'INDICATOR',
    'badge' => 'BADGE',
    'label' => 'LABEL',
    'tag' => 'TAG',
    'category' => 'CATEGORY',
    'group' => 'GROUP',
    'section' => 'SECTION',
    'container' => 'CONTAINER',
    'wrapper' => 'WRAPPER',
    'content' => 'CONTENT',
    'text' => 'TEXT',
    'image' => 'IMAGE',
    'video' => 'VIDEO',
    'audio' => 'AUDIO',
    'media' => 'MEDIA',
    'file' => 'FILE',
    'document' => 'DOCUMENT',
    'data' => 'DATA',
    'database' => 'DATABASE',
    'server' => 'SERVER',
    'client' => 'CLIENT',
    'network' => 'NETWORK',
    'connection' => 'CONNECTION',
    'session' => 'SESSION',
    'cache' => 'CACHE',
    'memory' => 'MEMORY',
    'storage' => 'STORAGE',
    'backup' => 'BACKUP',
    'restore' => 'RESTORE',
    'update' => 'UPDATE',
    'upgrade' => 'UPGRADE',
    'download' => 'DOWNLOAD',
    'upload' => 'UPLOAD',
    'sync' => 'SYNC',
    'transfer' => 'TRANSFER',
    'copy' => 'COPY',
    'move' => 'MOVE',
    'rename' => 'RENAME',
    'create' => 'CREATE',
    'generate' => 'GENERATE',
    'build' => 'BUILD',
    'compile' => 'COMPILE',
    'execute' => 'EXECUTE',
    'run' => 'RUN',
    'start' => 'START',
    'stop' => 'STOP',
    'pause' => 'PAUSE',
    'resume' => 'RESUME',
    'restart' => 'RESTART',
    'reset' => 'RESET',
    'clear' => 'CLEAR',
    'clean' => 'CLEAN',
    'optimize' => 'OPTIMIZE',
    'configure' => 'CONFIGURE',
    'setup' => 'SETUP',
    'install' => 'INSTALL',
    'uninstall' => 'UNINSTALL',
    'enable' => 'ENABLE',
    'disable' => 'DISABLE',
    'activate' => 'ACTIVATE',
    'deactivate' => 'DEACTIVATE',
    'lock' => 'LOCK',
    'unlock' => 'UNLOCK',
    'secure' => 'SECURE',
    'protect' => 'PROTECT',
    'encrypt' => 'ENCRYPT',
    'decrypt' => 'DECRYPT',
    'verify' => 'VERIFY',
    'validate' => 'VALIDATE',
    'authenticate' => 'AUTHENTICATE',
    'authorize' => 'AUTHORIZE',
    'permission' => 'PERMISSION',
    'access' => 'ACCESS',
    'privilege' => 'PRIVILEGE',
    'role' => 'ROLE',
    'user' => 'USER',
    'admin' => 'ADMIN',
    'guest' => 'GUEST',
    'member' => 'MEMBER',
    'player' => 'PLAYER',
    'character' => 'CHARACTER',
    'avatar' => 'AVATAR',
    'profile' => 'PROFILE',
    'account' => 'ACCOUNT',
    'identity' => 'IDENTITY',
    'name' => 'NAME',
    'username' => 'USERNAME',
    'password' => 'PASSWORD',
    'email' => 'EMAIL',
    'phone' => 'PHONE',
    'address' => 'ADDRESS',
    'contact' => 'CONTACT',
    'information' => 'INFORMATION',
    'details' => 'DETAILS',
    'description' => 'DESCRIPTION',
    'summary' => 'SUMMARY',
    'overview' => 'OVERVIEW',
    'introduction' => 'INTRODUCTION',
    'tutorial' => 'TUTORIAL',
    'guide' => 'GUIDE',
    'manual' => 'MANUAL',
    'documentation' => 'DOCUMENTATION',
    'reference' => 'REFERENCE',
    'example' => 'EXAMPLE',
    'sample' => 'SAMPLE',
    'template' => 'TEMPLATE',
    'pattern' => 'PATTERN',
    'format' => 'FORMAT',
    'style' => 'STYLE',
    'design' => 'DESIGN',
    'layout' => 'LAYOUT',
    'structure' => 'STRUCTURE',
    'framework' => 'FRAMEWORK',
    'system' => 'SYSTEM',
    'platform' => 'PLATFORM',
    'environment' => 'ENVIRONMENT',
    'context' => 'CONTEXT',
    'scope' => 'SCOPE',
    'range' => 'RANGE',
    'limit' => 'LIMIT',
    'boundary' => 'BOUNDARY',
    'threshold' => 'THRESHOLD',
    'minimum' => 'MINIMUM',
    'maximum' => 'MAXIMUM',
    'average' => 'AVERAGE',
    'median' => 'MEDIAN',
    'standard' => 'STANDARD',
    'normal' => 'NORMAL',
    'default' => 'DEFAULT',
    'custom' => 'CUSTOM',
    'advanced' => 'ADVANCED',
    'basic' => 'BASIC',
    'simple' => 'SIMPLE',
    'complex' => 'COMPLEX',
    'easy' => 'EASY',
    'difficult' => 'DIFFICULT',
    'hard' => 'HARD',
    'soft' => 'SOFT',
    'fast' => 'FAST',
    'slow' => 'SLOW',
    'quick' => 'QUICK',
    'instant' => 'INSTANT',
    'immediate' => 'IMMEDIATE',
    'delayed' => 'DELAYED',
    'pending' => 'PENDING',
    'waiting' => 'WAITING',
    'ready' => 'READY',
    'busy' => 'BUSY',
    'idle' => 'IDLE',
    'active' => 'ACTIVE',
    'inactive' => 'INACTIVE',
    'enabled' => 'ENABLED',
    'disabled' => 'DISABLED',
    'available' => 'AVAILABLE',
    'unavailable' => 'UNAVAILABLE',
    'visible' => 'VISIBLE',
    'hidden' => 'HIDDEN',
    'public' => 'PUBLIC',
    'private' => 'PRIVATE',
    'open' => 'OPEN',
    'closed' => 'CLOSED',
    'locked' => 'LOCKED',
    'unlocked' => 'UNLOCKED',
    'secure' => 'SECURE',
    'insecure' => 'INSECURE',
    'safe' => 'SAFE',
    'unsafe' => 'UNSAFE',
    'stable' => 'STABLE',
    'unstable' => 'UNSTABLE',
    'reliable' => 'RELIABLE',
    'unreliable' => 'UNRELIABLE',
    'valid' => 'VALID',
    'invalid' => 'INVALID',
    'correct' => 'CORRECT',
    'incorrect' => 'INCORRECT',
    'true' => 'TRUE',
    'false' => 'FALSE',
    'yes' => 'YES',
    'no' => 'NO',
    'on' => 'ON',
    'off' => 'OFF',
    'up' => 'UP',
    'down' => 'DOWN',
    'left' => 'LEFT',
    'right' => 'RIGHT',
    'forward' => 'FORWARD',
    'backward' => 'BACKWARD',
    'inside' => 'INSIDE',
    'outside' => 'OUTSIDE',
    'above' => 'ABOVE',
    'below' => 'BELOW',
    'before' => 'BEFORE',
    'after' => 'AFTER',
    'during' => 'DURING',
    'while' => 'WHILE',
    'when' => 'WHEN',
    'where' => 'WHERE',
    'what' => 'WHAT',
    'who' => 'WHO',
    'why' => 'WHY',
    'how' => 'HOW',
    'which' => 'WHICH',
);

// 英文语言包
$language_en = array(
    // Basic Interface
    'title' => 'PHPDTS - Virtual Reality Battle Royale',
    'index' => 'INDEX',
    'messages' => 'MESSAGES',
    'user' => 'USER',
    'register' => 'REGISTER',
    'game' => 'GAME',
    'map' => 'MAP',
    'news' => 'NEWS',
    'alive' => 'ONLINE',
    'winner' => 'WINNERS',
    'rank' => 'RANKINGS',
    'help' => 'HELP',
    'admin' => 'ADMIN',
    'report' => 'FORUM',
    'donate' => 'SUPPORT',
    'vnworld' => 'VN WORLD',
    'homepage' => 'HOMEPAGE',

    // Game Interface
    'level' => 'LEVEL',
    'exp' => 'EXP',
    'team' => 'TEAM',
    'club' => 'CLUB',
    'att' => 'ATK',
    'def' => 'DEF',
    'money' => 'CREDITS',
    'moneyunit' => 'CR',
    'inf' => 'STATUS',
    'pose' => 'STANCE',
    'tactic' => 'TACTIC',
    'hp' => 'HP',
    'sp' => 'SP',
    'ss' => 'SS',
    'skillpoint' => 'SKILL PTS',
    'rage' => 'RAGE',
    'killnum' => 'KILLS',
    'weather' => 'WEATHER',
    'gamedate' => 'GAME TIME',
    'combo' => 'COMBO MODE',
    'duel' => 'DUEL MODE',

    // Weapon Skills
    'wp' => 'PIERCE',
    'wk' => 'BLADE',
    'wg' => 'BLUNT',
    'wc' => 'THROW',
    'wd' => 'SHOOT',
    'wf' => 'SPECIAL',
    'skill' => 'SKILL',

    // Inventory
    'pack' => 'SLOT',

    // Chat
    'chat' => 'COMMUNICATION CHANNEL',
    'send' => 'TRANSMIT',
    'refresh' => 'REFRESH',
    'chatswitch' => 'SWITCH MODE',
    'emoji' => 'EMOJI',

    // User Interface
    'gender' => 'GENDER',
    'icon' => 'AVATAR',
    'male' => 'MALE',
    'female' => 'FEMALE',

    // Actions
    'login' => 'LOGIN',
    'logout' => 'LOGOUT',
    'submit' => 'SUBMIT',
    'cancel' => 'CANCEL',
    'confirm' => 'CONFIRM',
    'back' => 'BACK',
    'next' => 'NEXT',
    'previous' => 'PREVIOUS',
    'save' => 'SAVE',
    'load' => 'LOAD',
    'delete' => 'DELETE',
    'edit' => 'EDIT',
    'view' => 'VIEW',
    'search' => 'SEARCH',
    'filter' => 'FILTER',
    'sort' => 'SORT',
    'export' => 'EXPORT',
    'import' => 'IMPORT',

    // Nouveau Specific
    'nouveau_welcome' => 'WELCOME TO NOUVEAU INTERFACE',
    'nouveau_version' => 'NOUVEAU v2.0',
    'nouveau_theme' => 'THEME',
    'nouveau_settings' => 'INTERFACE SETTINGS',
    'nouveau_features' => 'FEATURES',
    'nouveau_help' => 'NOUVEAU HELP',
    'nouveau_about' => 'ABOUT NOUVEAU',
    'nouveau_feedback' => 'FEEDBACK',
    'nouveau_beta' => 'BETA VERSION',
    'nouveau_stable' => 'STABLE VERSION',
    'nouveau_experimental' => 'EXPERIMENTAL',
    'nouveau_interface' => 'NOUVEAU INTERFACE',
    'nouveau_loading' => 'LOADING NOUVEAU INTERFACE...',
    'nouveau_ready' => 'NOUVEAU INTERFACE READY',
    'nouveau_error' => 'NOUVEAU INTERFACE FAILED TO LOAD',

    // Themes
    'theme_cyber_blue' => 'CYBER BLUE',
    'theme_cyber_purple' => 'NEON PURPLE',
    'theme_cyber_green' => 'MATRIX GREEN',
    'theme_cyber_orange' => 'SYNTHWAVE ORANGE',
    'theme_cyber_pink' => 'VAPORWAVE PINK',
    'theme_changed' => 'THEME CHANGED',
    'theme_cycle' => 'CYCLE THEME',

    // Interface Elements
    'command_interface' => 'COMMAND INTERFACE',
    'system_panel' => 'SYSTEM PANEL',
    'system_log' => 'SYSTEM LOG',
    'quick_actions' => 'QUICK ACTIONS',
    'status_info' => 'STATUS INFO',
    'combat_engaged' => 'COMBAT ENGAGED',
    'recovery_mode' => 'RECOVERY MODE',
    'system_terminated' => 'SYSTEM TERMINATED',
    'spectator_mode' => 'SPECTATOR MODE',
    'energy_levels' => 'ENERGY LEVELS',
    'game_stats' => 'GAME STATS',
    'detailed_info' => 'DETAILED INFO',
    'fireseed_status' => 'FIRESEED STATUS',
    'interface_ready' => 'INTERFACE READY',
    'processing' => 'PROCESSING',
    'operational' => 'OPERATIONAL',
    'offline' => 'OFFLINE',
    'online' => 'ONLINE',
    'connected' => 'CONNECTED',
    'disconnected' => 'DISCONNECTED',
    'move' => 'MOVE',
    'attack' => 'ATTACK',
    'defend' => 'DEFEND',
    'use_item' => 'USE ITEM',
    'escape' => 'ESCAPE',
    'skills' => 'SKILLS',
    'continue' => 'CONTINUE',
    'wake_up' => 'WAKE UP',
    'survivors' => 'SURVIVORS',
    'eliminated' => 'ELIMINATED',
    'participants' => 'PARTICIPANTS',
    'remaining' => 'REMAINING',
    'session' => 'SESSION',
    'next_session' => 'NEXT SESSION',
    'final_transmission' => 'FINAL TRANSMISSION',
    'termination_report' => 'TERMINATION REPORT',
    'survival_time' => 'SURVIVAL TIME',
    'eliminations' => 'ELIMINATIONS',
    'cause_termination' => 'CAUSE OF TERMINATION',
    'recovery_status' => 'RECOVERY STATUS',
    'recovery_time' => 'RECOVERY TIME',
    'recovery_complete' => 'RECOVERY COMPLETE',
    'hp_recovery' => 'HP RECOVERY',
    'sp_recovery' => 'SP RECOVERY',
    'status_effects' => 'STATUS EFFECTS',
    'clearing' => 'CLEARING',
    'clear' => 'CLEAR',
    'current_vitals' => 'CURRENT VITALS',
    'health_points' => 'HEALTH POINTS',
    'skill_points' => 'SKILL POINTS',
    'special_skills' => 'SPECIAL SKILLS',
    'recovery_options' => 'RECOVERY OPTIONS',
    'recovery_tips' => 'RECOVERY TIPS',
    'recovery_benefits' => 'RECOVERY BENEFITS',
    'important_notes' => 'IMPORTANT NOTES',
    'combat_actions' => 'COMBAT ACTIONS',
    'tactical_advice' => 'TACTICAL ADVICE',
    'combat_tips' => 'COMBAT TIPS',
    'your_status' => 'YOUR STATUS',
    'enemy_status' => 'ENEMY STATUS',
    'threat' => 'THREAT',
    'hostile' => 'HOSTILE',
    'combat_warning' => 'COMBAT WARNING',
    'combat_log' => 'COMBAT LOG',
    'special_abilities' => 'SPECIAL ABILITIES',
    'emergency' => 'EMERGENCY',
    'self_destruct' => 'SELF-DESTRUCT',
    'language' => 'LANGUAGE',
    'chinese' => '中文',
    'english' => 'English',
    'switch_language' => 'SWITCH LANGUAGE',
);

// 根据语言设置选择语言包
$language = ($nouveau_lang === 'en') ? $language_en : $language_zh;

?>
