<?php
// 钓鱼物品抽选池
// 格式：'物品名称' => array('类型', '效果', '数量', '属性', '概率权重')

$fishing_items = array(
    // 常见鱼类 - 高概率
    '小鲫鱼' => array('HH', '1', '1', '', 100),
    '鲤鱼' => array('HH', '2', '1', '', 80),
    '黄鳝' => array('HH', '3', '1', '', 70),
    '草鱼' => array('HH', '4', '1', '', 60),
    '鲶鱼' => array('HH', '5', '1', '', 50),
    
    // 中等稀有度鱼类 - 中等概率
    '鲈鱼' => array('HH', '8', '1', '', 40),
    '鲑鱼' => array('HH', '10', '1', '', 30),
    '金枪鱼' => array('HH', '15', '1', '', 20),
    '河豚' => array('HH', '20', '1', 'p', 15),
    
    // 稀有鱼类 - 低概率
    '大马哈鱼' => array('HH', '25', '1', '', 10),
    '鲟鱼' => array('HH', '30', '1', '', 8),
    '剑鱼' => array('HH', '40', '1', '', 5),
    '彩虹鱼' => array('HH', '50', '1', 'z', 3),
    
    // 非常稀有鱼类 - 极低概率
    '金鱼' => array('HH', '100', '1', 'z', 2),
    '龙鱼' => array('HH', '200', '1', 'Z', 1),
    
    // 其他水生物 - 各种概率
    '海藻' => array('HB', '10', '1', '', 50),
    '水草' => array('HB', '15', '1', '', 40),
    '贝壳' => array('HS', '5', '1', '', 30),
    '珍珠' => array('HS', '50', '1', '', 5),
    '海星' => array('HS', '20', '1', '', 20),
    '螃蟹' => array('HB', '15', '1', '', 25),
    '龙虾' => array('HB', '25', '1', '', 15),
    
    // 垃圾物品 - 高概率
    '破鞋' => array('XX', '0', '1', '', 60),
    '塑料袋' => array('XX', '0', '1', '', 70),
    '空罐头' => array('XX', '0', '1', '', 65),
    '废轮胎' => array('XX', '0', '1', '', 40),
    
    // 特殊物品 - 极低概率
    '古代硬币' => array('MA', '100', '1', 'M', 2),
    '生锈的钥匙' => array('Y', '1', '1', '', 3),
    '神秘宝箱' => array('X', '1', '1', '', 1),
    '幸运鱼饵' => array('X', '1', '1', 'f', 2),
    
    // 钓竿类物品 - 极低概率
    '简易钓竿' => array('DA', '15', '1', '', 3),
    '高级钓竿' => array('DA', '25', '1', 'z', 2),
    '传说中的钓鱼竿' => array('DA', '40', '1', 'Z', 1),
    
    // 索拉利斯特有物品 - 只在索拉利斯可钓到
    '外星鱼' => array('HB', '50', '1', 'Z', 2),
    '奇异水晶' => array('MA', '100', '1', 'Z', 1),
    '未知生物组织' => array('HH', '30', '1', 'z', 3),
    '索拉利斯之泪' => array('HS', '80', '1', 'Z', 1),
    
    // 永恒的世界特有物品 - 只在永恒的世界可钓到
    '云朵鱼' => array('HB', '40', '1', 'Z', 2),
    '天空宝石' => array('MA', '120', '1', 'Z', 1),
    '彩虹水滴' => array('HS', '60', '1', 'z', 3),
    '永恒之羽' => array('DA', '50', '1', 'Z', 1)
);

// 钓鱼地点配置
// 不同地点可以钓到不同的鱼（使用地点ID作为键）
$fishing_places = array(
    // 3 - 雪之镇（靠海的北海道，可以钓鱼）
    3 => array('小鲫鱼', '鲤鱼', '黄鳝', '鲶鱼', '鲈鱼', '鲑鱼', '大马哈鱼', '海藻', '水草', '贝壳', '海星', '破鞋', '塑料袋', '空罐头', '简易钓竿'),
    
    // 7 - 清水池（是一个湖泊，可以钓鱼）
    7 => array('小鲫鱼', '鲤鱼', '草鱼', '鲶鱼', '鲈鱼', '彩虹鱼', '金鱼', '水草', '贝壳', '破鞋', '塑料袋', '简易钓竿', '高级钓竿'),
    
    // 12 - 夏之镇（设定中靠海，可以钓鱼）
    12 => array('鲈鱼', '鲑鱼', '金枪鱼', '河豚', '大马哈鱼', '鲟鱼', '剑鱼', '海藻', '贝壳', '海星', '螃蟹', '龙虾', '珍珠', '塑料袋', '空罐头', '废轮胎', '神秘宝箱', '高级钓竿'),
    
    // 4 - 索拉利斯（致敬了1961年的波兰科幻小说Solaris，可以钓上外星鱼和其他部件）
    4 => array('外星鱼', '奇异水晶', '未知生物组织', '索拉利斯之泪', '海藻', '水草', '贝壳', '海星', '塑料袋', '空罐头', '高级钓竿'),
    
    // 24 - 永恒的世界（设定中是一片云海，可以钓上奇幻风格的东西）
    24 => array('云朵鱼', '天空宝石', '彩虹水滴', '永恒之羽', '彩虹鱼', '金鱼', '龙鱼', '传说中的钓鱼竿'),
    
    // 默认地点（其他所有地点）
    'default' => array('小鲫鱼', '鲤鱼', '黄鳝', '破鞋', '塑料袋', '空罐头')
);

// 钓鱼时间影响
// 不同时间段可能影响钓鱼概率
$fishing_time_bonus = array(
    'morning' => array('小鲫鱼' => 1.2, '鲤鱼' => 1.1, '草鱼' => 1.2),
    'noon' => array('鲶鱼' => 1.2, '鲈鱼' => 1.1),
    'evening' => array('鲑鱼' => 1.3, '金枪鱼' => 1.2, '大马哈鱼' => 1.1),
    'night' => array('彩虹鱼' => 1.5, '金鱼' => 1.3, '龙鱼' => 1.2, '神秘宝箱' => 1.5, '传说中的钓鱼竿' => 2.0, '外星鱼' => 1.8, '云朵鱼' => 1.8)
);

// 天气影响
// 不同天气可能影响钓鱼概率
$fishing_weather_bonus = array(
    '晴朗' => array('小鲫鱼' => 1.2, '鲤鱼' => 1.1, '草鱼' => 1.2, '云朵鱼' => 1.5, '天空宝石' => 1.3),
    '多云' => array('鲶鱼' => 1.2, '鲈鱼' => 1.1, '彩虹水滴' => 1.5),
    '下雨' => array('鲑鱼' => 1.3, '金枪鱼' => 1.2, '大马哈鱼' => 1.1, '简易钓竿' => 1.5, '索拉利斯之泪' => 1.5),
    '起雾' => array('彩虹鱼' => 1.5, '金鱼' => 1.3, '龙鱼' => 1.2, '神秘宝箱' => 1.5, '高级钓竿' => 1.5, '外星鱼' => 1.5, '奇异水晶' => 1.3)
);
?>
