# PHPDTS 配置系统详解

## 配置系统概述

PHPDTS 采用分层配置系统，将不同类型的配置分别存储在不同的文件中，便于管理和维护。配置系统支持版本化管理，可以为不同的游戏房间使用不同的配置版本。

## 配置文件层次结构

### 1. 主配置文件

#### config.inc.php - 核心配置
```php
<?php
// 数据库配置
$dbhost = 'localhost';           // 数据库主机
$dbuser = 'phpdts';             // 数据库用户名
$dbpw = 'password';             // 数据库密码
$dbname = 'phpdts';             // 数据库名称
$tablepre = 'bra_';             // 游戏数据表前缀
$gtablepre = 'acbra2_';         // 全局数据表前缀

// 游戏配置
$gamecfg = 1;                   // 游戏配置版本号
$groomid = 1;                   // 当前房间ID

// Cookie配置
$cookiedomain = '';             // Cookie域名
$cookiepath = '/';              // Cookie路径
$cookiepre = 'phpdts_';         // Cookie前缀

// 主从数据库配置
$slave_level = 0;               // 从数据库级别
$slave_dbhost = '';             // 从数据库主机
$slave_dbuser = '';             // 从数据库用户名
$slave_dbpw = '';               // 从数据库密码
$slave_dbname = '';             // 从数据库名称
?>
```

### 2. 系统配置文件

#### gamedata/system.php - 系统级配置
```php
<?php
// 系统基础配置
$charset = 'utf-8';             // 字符编码
$gzipcompress = 1;              // 是否启用GZIP压缩
$templateid = 'default';        // 默认模板ID
$language = 'schinese';         // 语言设置

// 安全配置
$admin_cmd_list = array(        // 管理员命令权限列表
    'command' => 1,             // 普通命令权限等级
    'admin' => 5,               // 管理员权限等级
    'super' => 10               // 超级管理员权限等级
);
?>
```

#### gamedata/admincfg.php - 管理员配置
```php
<?php
// 查看资料行数限制
$showlimit = 50;

// 用户组名称定义
$urgroup = array(
    '<span class="red">封停</span>',
    '正常', '管理员2', '管理员3', '管理员4', '管理员5',
    '管理员6', '管理员7', '管理员8', '管理员9', '站长'
);

// 用户性别定义
$ursex = array('0'=>'未定','m'=>'男','f'=>'女');
?>
```

### 3. 游戏规则配置

#### gamedata/cache/gamecfg_1.php - 游戏核心配置
```php
<?php
// 禁区系统配置
$areahour = 25;                 // 禁区间隔时间(小时)
$areaadd = 4;                   // 每次增加的禁区数量
$areawarntime = 60;             // 禁区提示时间(秒)
$arealimit = 3;                 // 激活结束时的禁区回数
$areaesc = 1;                   // 是否自动逃避禁区

// 游戏基础参数
$validlimit = 300;              // 游戏人数限制
$combolimit = 50;               // 连斗时人数限制
$deathlimit = 160;              // 连斗最小死亡人数
$baseexp = 9;                   // 等级提升基本经验值
$splimit = 400;                 // 初始体力最大值
$hplimit = 400;                 // 初始生命最大值
$moneylimit = 65500;            // 携带金钱上限

// 冷却时间配置
$coldtimeon = 0;                // 是否启动冷却时间
$movecoldtime = 821;            // 移动冷却时间(微秒)
$searchcoldtime = 873;          // 探索冷却时间(微秒)
$itemusecoldtime = 555;         // 使用物品冷却时间(微秒)

// 恢复系统配置
$sleep_time = 3;                // 体力恢复时间(秒/点)
$heal_time = 6;                 // 生命恢复时间(秒/点)
$rage_time = 6;                 // 怒气增长时间(秒/点)

// 探索系统配置
$event_obbs = 5;                // 随机事件几率(%)
$item_obbs = 70;                // 道具发现基础几率(%)
$enemy_obbs = 70;               // 敌人发现基础几率(%)
$corpse_obbs = 50;              // 尸体发现几率(%)

// 场外支援系统
$gshoplist = array(             // 允许购买的道具类型
    1=>'■ 补给品 ■', 2=>'■ 药剂 ■', 3=>'■ 钝器 ■',
    4=>'■ 锐器 ■', 5=>'■ 远程兵器 ■', 6=>'■ 投掷兵器 ■'
);
$credits2_values = 2;           // 切糕与游戏币兑换比率
$sponsor_title = '场外热心玩家'; // 赞助者头衔
?>
```

### 4. 资源定义配置

#### gamedata/cache/resources_1.php - 游戏资源定义
```php
<?php
// 基础资源定义
$nowep = '拳头';                // 空手武器名称
$noarb = '内衣';                // 无防具名称
$noitm = '--';                  // 无道具显示
$nosta = '∞';                   // 无限耐久度显示
$nospk = '--';                  // 无属性显示

// 游戏状态描述
$gstate = array(
    0 => '<font color="grey">已结束</font>',
    10 => '即将开始',
    20 => '开放激活',
    30 => '停止激活',
    40 => '<font color="yellow">连斗中</font>',
    50 => '<font color="red">死斗中</font>',
    60 => '<font color="red">紧急状态！</font>'
);

// 胜利模式描述
$gwin = array(
    0 => '程序故障', 1 => '全部死亡', 2 => '最后幸存',
    3 => '锁定解除', 4 => '无人参加', 5 => '核爆全灭',
    6 => 'GM中止', 7 => '幻境解离'
);

// 社团信息定义
$clubinfo = array(
    0=>'无', 1=>'街头霸王', 2=>'见敌必斩', 3=>'灌篮高手',
    4=>'狙击鹰眼', 5=>'拆弹专家', 6=>'宛如疾风', 7=>'锡安成员',
    8=>'黑衣组织', 9=>'超能力者', 10=>'天赋异禀', 11=>'富家子弟',
    12=>'全能兄贵', 13=>'铁拳无敌', 15=>'L5状态', 17=>'走路萌物',
    19=>'晶莹剔透', 20=>'元素大师', 21=>'码语行人', 22=>'枫火歌者'
);

// 地点信息定义
$plsinfo = array(
    0=>'介绍', 1=>'学校', 2=>'宿舍', 3=>'雪之镇', 4=>'索拉利斯',
    5=>'体育馆', 6=>'图书馆', 7=>'清水池', 8=>'小树林', 9=>'实验室',
    10=>'医务室', 11=>'食堂', 12=>'夏之镇', 13=>'教学楼', 14=>'操场',
    // ... 更多地点定义
);

// 物品类型信息
$iteminfo = array(
    'WP'=>'钝器', 'WK'=>'锐器', 'WG'=>'远程兵器', 'WF'=>'投掷兵器',
    'WC'=>'爆炸物', 'WD'=>'电子兵器', 'WB'=>'灵力兵器',
    'D'=>'防具', 'HH'=>'生命恢复', 'HS'=>'体力恢复', 'HB'=>'综合恢复',
    'Y'=>'工具', 'Z'=>'特殊工具', 'X'=>'特殊物品', 'A'=>'材料'
);
?>
```

### 5. 专用功能配置

#### gamedata/cache/club22cfg.php - 枫火歌者社团配置
```php
<?php
// 枫火歌者社团专用配置
$fireseed_recruit_rate = 100;           // 收纳种火成功率
$fireseed_follow_bonus_rate = 1;        // 跟随时强化倍率
$fireseed_search_rate = 60;             // 探物检定成功率
$fireseed_drain_rate = 50;              // 削减NPC HP成功率

// 强化倍率配置
$fireseed_enhance_multipliers = array(
    '◆焰火' => 1,
    '✦烈焰火' => 8,
    '★华焰火★' => 32,
    '☾真焰火☽' => 64,
    '☼焰火☼' => 128
);

// 种火部署状态
$fireseed_deploy_modes = array(
    0 => '跟随',    // 战斗时增加攻击/防御
    1 => '探物',    // 收集地图掉落物品
    2 => '索敌',    // 削减NPC生命值
    3 => '隐藏'     // 无额外效果
);
?>
```

#### gamedata/cache/fishing.php - 钓鱼系统配置
```php
<?php
// 钓鱼物品抽选池
$fishing_items = array(
    '小鲫鱼' => array('HH', '1', '1', '', 100),
    '鲤鱼' => array('HH', '2', '1', '', 80),
    // ... 更多钓鱼物品定义
);

// 钓鱼地点配置
$fishing_places = array(
    3 => array('小鲫鱼', '鲤鱼', '黄鳝'),      // 雪之镇
    7 => array('小鲫鱼', '鲤鱼', '草鱼'),      // 清水池
    12 => array('鲈鱼', '鲑鱼', '金枪鱼'),     // 夏之镇
    4 => array('外星鱼', '奇异水晶'),          // 索拉利斯
    24 => array('云朵鱼', '天空宝石')          // 永恒的世界
);
?>
```

## 配置加载机制

### 1. 配置文件加载顺序
```php
// 在 common.inc.php 中的加载顺序
require GAME_ROOT.'./gamedata/system.php';         // 系统配置
require config('resources',$gamecfg);              // 资源配置
require config('gamecfg',$gamecfg);                // 游戏配置
require config('combatcfg',$gamecfg);              // 战斗配置
require config('clubskills',$gamecfg);             // 社团技能配置
require config('dialogue',$gamecfg);               // 对话配置
require config('audio',$gamecfg);                  // 音频配置
```

### 2. 动态配置加载函数
```php
function config($name, $gamecfg) {
    return GAME_ROOT."./gamedata/cache/{$name}_{$gamecfg}.php";
}
```

### 3. 配置版本管理
- 通过 `$gamecfg` 变量控制配置版本
- 不同房间可以使用不同的配置版本
- 支持配置热更新（重新加载配置文件）

## 配置最佳实践

### 1. 配置文件组织原则
- **功能分离**: 不同功能的配置放在不同文件中
- **版本控制**: 使用版本号管理配置变更
- **安全考虑**: 敏感配置（如数据库密码）单独存放
- **性能优化**: 频繁访问的配置使用缓存

### 2. 配置修改流程
1. 备份原配置文件
2. 修改配置参数
3. 验证配置语法
4. 测试配置效果
5. 部署到生产环境

### 3. 配置安全注意事项
- 配置文件应包含访问控制检查
- 敏感信息不应明文存储
- 定期检查配置文件权限
- 避免在配置中使用用户输入

---

*本文档详细介绍了PHPDTS的配置系统架构，为系统管理和功能扩展提供参考。*
