--
-- 表的结构 `bra_game`
-- 储存当前游戏信息
--

DROP TABLE IF EXISTS bra_game;
CREATE TABLE bra_game (
  `gamenum` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `gamestate` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `groomid` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `groomnums` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `groomownid` char(15) NOT NULL default '',
  `starttime` int(10) unsigned NOT NULL DEFAULT '0',
  `winmode` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `winner` char(15) NOT NULL DEFAULT '',
  `arealist` varchar(255) NOT NULL DEFAULT '',
  `areanum` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `areatime` int(10) unsigned NOT NULL DEFAULT '0',
  `areawarn` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `validnum` smallint(5) unsigned NOT NULL DEFAULT '0',
  `alivenum` smallint(5) unsigned NOT NULL DEFAULT '0',
  `deathnum` smallint(5) unsigned NOT NULL DEFAULT '0',
  `afktime` int(10) unsigned NOT NULL DEFAULT '0',
  `optime` int(10) unsigned NOT NULL DEFAULT '0',
  `weather` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `hack` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `hdamage` int(10) unsigned NOT NULL DEFAULT '0',
  `hplayer` char(15) NOT NULL DEFAULT '',
  `combonum` smallint(5) unsigned NOT NULL DEFAULT '0',
  `gamevars` text NOT NULL,
  `noisevars` varchar(1000) NOT NULL DEFAULT '',
  `rdown` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `bdown` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ldown` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `kdown` tinyint(1) unsigned NOT NULL DEFAULT '0',

  PRIMARY KEY (`groomid`)

) TYPE=MyISAM;

--
-- 插入初始数据 `bra_game`
--

INSERT INTO bra_game (gamenum) VALUES (0);

--
-- 表的结构 `bra_users`
-- 储存用户的激活信息
--

DROP TABLE IF EXISTS bra_users;
CREATE TABLE bra_users (
  `uid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `username` char(15) NOT NULL DEFAULT '',
  `password` char(32) NOT NULL DEFAULT '',
  `groupid` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `roomid` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `lastgame` smallint(5) unsigned NOT NULL DEFAULT '0',
  `ip` char(15) NOT NULL DEFAULT '',
  `credits` int(10) NOT NULL DEFAULT '0',
  `credits2` mediumint(9) NOT NULL DEFAULT '0',
  `achievement` text NOT NULL,
  `achrev` text NOT NULL,
  `daily` varchar(255) NOT NULL DEFAULT '',
  `nick` text NOT NULL,
  `nicks` text NOT NULL,
  `nicksrev` text NOT NULL default '',
  `validgames` smallint(5) unsigned NOT NULL DEFAULT '0',
  `wingames` smallint(5) unsigned NOT NULL DEFAULT '0',
  `gender` char(1) NOT NULL DEFAULT '0',
  `icon` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `club` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `motto` char(30) NOT NULL DEFAULT '',
  `killmsg` char(30) NOT NULL DEFAULT '',
  `lastword` char(30) NOT NULL DEFAULT '',
  `u_templateid` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY  (uid),
  UNIQUE KEY username (username)

) TYPE=MyISAM;

--
-- 插入初始数据 `bra_users`
--


--
-- 表的结构 `bra_winners`
-- 储存每局获胜者的信息
--

DROP TABLE IF EXISTS bra_winners;
CREATE TABLE bra_winners (
  `gid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `nick` text NOT NULL,
  `skillpoint` smallint unsigned NOT NULL default '0',
  `name` char(15) NOT NULL DEFAULT '',
  `pass` char(32) NOT NULL DEFAULT '',
  `gd` char(1) NOT NULL DEFAULT 'm',
  `sNo` smallint(5) unsigned NOT NULL DEFAULT '0',
  `icon` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `club` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `endtime` int(10) unsigned NOT NULL DEFAULT '0',
  `hp` smallint(5) unsigned NOT NULL DEFAULT '0',
  `mhp` smallint(5) unsigned NOT NULL DEFAULT '0',
  `sp` smallint(5) unsigned NOT NULL DEFAULT '0',
  `msp` smallint(5) unsigned NOT NULL DEFAULT '0',
  `ss` smallint unsigned NOT NULL default '0',
  `mss` smallint unsigned NOT NULL default '0',
  `att` smallint(5) unsigned NOT NULL DEFAULT '0',
  `def` smallint(5) unsigned NOT NULL DEFAULT '0',
  `pls` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `lvl` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `exp` smallint(5) unsigned NOT NULL DEFAULT '0',
  `money` smallint(5) unsigned NOT NULL DEFAULT '0',
  `bid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `inf` char(10) NOT NULL DEFAULT '',
  `rage` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `pose` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `tactic` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `killnum` smallint(5) unsigned NOT NULL DEFAULT '0',
  `killnum2` smallint(5) unsigned NOT NULL DEFAULT '0',
  `state` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `wp` smallint(5) unsigned NOT NULL DEFAULT '0',
  `wk` smallint(5) unsigned NOT NULL DEFAULT '0',
  `wg` smallint(5) unsigned NOT NULL DEFAULT '0',
  `wc` smallint(5) unsigned NOT NULL DEFAULT '0',
  `wd` smallint(5) unsigned NOT NULL DEFAULT '0',
  `wf` smallint(5) unsigned NOT NULL DEFAULT '0',
  `teamID` char(15) NOT NULL DEFAULT '',
  `teamPass` char(15) NOT NULL DEFAULT '',
  `teamMate` text NOT NULL default '',
  `teamIcon` smallint unsigned NOT NULL default '0',
  wep char(30) NOT NULL default '',
  wepk char(40) not null default '',
  wepe int(10) unsigned NOT NULL DEFAULT '0',
  weps char(10) not null default '0',
  wepsk char(40) not null default '',
  wep2 char(30) NOT NULL default '',
  wep2k char(40) not null default '',
  wep2e int(10) unsigned NOT NULL DEFAULT '0',
  wep2s char(10) not null default '0',
  wep2sk char(40) not null default '',
  arb char(30) NOT NULL default '',
  arbk char(40) not null default '',
  arbe int(10) unsigned NOT NULL DEFAULT '0',
  arbs char(10) not null default '0',
  arbsk char(40) not null default '',
  arh char(30) NOT NULL default '',
  arhk char(40) not null default '',
  arhe int(10) unsigned NOT NULL DEFAULT '0',
  arhs char(10) not null default '0',
  arhsk char(40) not null default '',
  ara char(30) NOT NULL default '',
  arak char(40) not null default '',
  arae int(10) unsigned NOT NULL DEFAULT '0',
  aras char(10) not null default '0',
  arask char(40) not null default '',
  arf char(30) NOT NULL default '',
  arfk char(40) not null default '',
  arfe int(10) unsigned NOT NULL DEFAULT '0',
  arfs char(10) not null default '0',
  arfsk char(40) not null default '',
  art char(30) NOT NULL default '',
  artk char(40) not null default '',
  arte int(10) unsigned NOT NULL DEFAULT '0',
  arts char(10) not null default '0',
  artsk char(40) not null default '',
  itm0 char(30) NOT NULL default '',
  itmk0 char(40) not null default '',
  itme0 int(10) unsigned NOT NULL DEFAULT '0',
  itms0 char(10) not null default '0',
  itmsk0 char(40) not null default '',
  itm1 char(30) NOT NULL default '',
  itmk1 char(40) not null default '',
  itme1 int(10) unsigned NOT NULL DEFAULT '0',
  itms1 char(10) not null default '0',
  itmsk1 char(40) not null default '',
  itm2 char(30) NOT NULL default '',
  itmk2 char(40) not null default '',
  itme2 int(10) unsigned NOT NULL DEFAULT '0',
  itms2 char(10) not null default '0',
  itmsk2 char(40) not null default '',
  itm3 char(30) NOT NULL default '',
  itmk3 char(40) not null default '',
  itme3 int(10) unsigned NOT NULL DEFAULT '0',
  itms3 char(10) not null default '0',
  itmsk3 char(40) not null default '',
  itm4 char(30) NOT NULL default '',
  itmk4 char(40) not null default '',
  itme4 int(10) unsigned NOT NULL DEFAULT '0',
  itms4 char(10) not null default '0',
  itmsk4 char(40) not null default '',
  itm5 char(30) NOT NULL default '',
  itmk5 char(40) not null default '',
  itme5 int(10) unsigned NOT NULL DEFAULT '0',
  itms5 char(10) not null default '0',
  itmsk5 char(40) not null default '',
  itm6 char(30) NOT NULL default '',
  itmk6 char(40) not null default '',
  itme6 int(10) unsigned NOT NULL DEFAULT '0',
  itms6 char(10) not null default '0',
  itmsk6 char(40) not null default '',
  `motto` char(30) NOT NULL DEFAULT '',
  `wmode` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `vnum` smallint(5) unsigned NOT NULL DEFAULT '0',
  `gtime` int(10) unsigned NOT NULL DEFAULT '0',
  `gstime` int(10) unsigned NOT NULL DEFAULT '0',
  `getime` int(10) unsigned NOT NULL DEFAULT '0',
  `hdmg` int(10) unsigned NOT NULL DEFAULT '0',
  `hdp` char(15) NOT NULL DEFAULT '',
  `hkill` smallint(5) unsigned NOT NULL DEFAULT '0',
  `hkp` char(15) NOT NULL DEFAULT '',
  
  UNIQUE KEY (gid)
) TYPE=MyISAM;


--
-- 表的结构 `bra_players`
-- 储存角色数据的激活信息，包括PC和NPC。
--

DROP TABLE IF EXISTS bra_players;
CREATE TABLE bra_players (
  pid smallint unsigned NOT NULL auto_increment,
  type tinyint NOT NULL default 0,
  name char(15) NOT NULL default '',
  pass char(32) NOT NULL default '',
  gd char(1) NOT NULL default 'm',
  sNo smallint unsigned NOT NULL default 0,
  icon smallint unsigned NOT NULL default 0,
  club tinyint unsigned NOT NULL default 0,
  endtime int(10) unsigned NOT NULL default 0,
  hp smallint unsigned NOT NULL default 0,
  mhp smallint unsigned NOT NULL default 0,
  sp smallint unsigned NOT NULL default 0,
  msp smallint unsigned NOT NULL default 0,
  att smallint unsigned NOT NULL default 0,
  def smallint unsigned NOT NULL default 0,
  pls tinyint unsigned NOT NULL default 0,
  lvl tinyint unsigned NOT NULL default 0,
  `exp` smallint unsigned NOT NULL default 0,
  money smallint unsigned NOT NULL default 0,
  bid smallint unsigned NOT NULL default 0,
  `inf` char(10) not null default '',
  rage tinyint unsigned NOT NULL default 0,
  pose tinyint(1) unsigned NOT NULL default 0,
  tactic tinyint(1) unsigned NOT NULL default 0,
  killnum smallint unsigned NOT NULL default 0,
  state tinyint unsigned NOT NULL default 0,
  `wp` smallint unsigned not null default 0,
  `wk` smallint unsigned not null default 0,
  `wg` smallint unsigned not null default 0,
  `wc` smallint unsigned not null default 0,
  `wd` smallint unsigned not null default 0,
  `wf` smallint unsigned not null default 0,
  `teamID` char(15) not null default '',
  `teamPass` char(15) not null default '',
  wep char(30) NOT NULL default '',
  wepk char(5) not null default '',
  wepe smallint unsigned NOT NULL default 0,
  weps char(5) not null default 0,
  wepsk char(5) not null default '',
  arb char(30) NOT NULL default '',
  arbk char(5) not null default '',
  arbe smallint unsigned NOT NULL default 0,
  arbs char(5) not null default 0,
  arbsk char(5) not null default '',
  arh char(30) NOT NULL default '',
  arhk char(5) not null default '',
  arhe smallint unsigned NOT NULL default 0,
  arhs char(5) not null default 0,
  arhsk char(5) not null default '',
  ara char(30) NOT NULL default '',
  arak char(5) not null default '',
  arae smallint unsigned NOT NULL default 0,
  aras char(5) not null default 0,
  arask char(5) not null default '',
  arf char(30) NOT NULL default '',
  arfk char(5) not null default '',
  arfe smallint unsigned NOT NULL default 0,
  arfs char(5) not null default 0,
  arfsk char(5) not null default '',
  art char(30) NOT NULL default '',
  artk char(5) not null default '',
  arte smallint unsigned NOT NULL default 0,
  arts char(5) not null default 0,
  artsk char(5) not null default '',
  itm0 char(30) NOT NULL default '',
  itmk0 char(5) not null default '',
  itme0 smallint unsigned NOT NULL default 0,
  itms0 char(5) not null default 0,
  itmsk0 char(5) not null default '',
  itm1 char(30) NOT NULL default '',
  itmk1 char(5) not null default '',
  itme1 smallint unsigned NOT NULL default 0,
  itms1 char(5) not null default 0,
  itmsk1 char(5) not null default '',
  itm2 char(30) NOT NULL default '',
  itmk2 char(5) not null default '',
  itme2 smallint unsigned NOT NULL default 0,
  itms2 char(5) not null default 0,
  itmsk2 char(5) not null default '',
  itm3 char(30) NOT NULL default '',
  itmk3 char(5) not null default '',
  itme3 smallint unsigned NOT NULL default 0,
  itms3 char(5) not null default 0,
  itmsk3 char(5) not null default '',
  itm4 char(30) NOT NULL default '',
  itmk4 char(5) not null default '',
  itme4 smallint unsigned NOT NULL default 0,
  itms4 char(5) not null default 0,
  itmsk4 char(5) not null default '',
  itm5 char(30) NOT NULL default '',
  itmk5 char(5) not null default '',
  itme5 smallint unsigned NOT NULL default 0,
  itms5 char(5) not null default 0,
  itmsk5 char(5) not null default '',

  PRIMARY KEY  (pid),
  INDEX TYPE (type, sNo),
  INDEX NAME (name, type)
) TYPE=MyISAM;
