import { NestFactory } from '@nestjs/core';
import { SwaggerModule, DocumentBuilder } from '@nestjs/swagger';
import { AppModule } from './app.module';

async function bootstrap() {
  const app = await NestFactory.create(AppModule);
  app.enableCors();

  const documentConfig = new DocumentBuilder()
    .setTitle('ygopro-tips-biu-generator')
    .setDescription('YGOPro Tips 生成工具')
    .setVersion('1.0')
    .addTag('tips')
    .build();

  const document = SwaggerModule.createDocument(app, documentConfig);
  SwaggerModule.setup('docs', app, document);

  await app.listen(3000);
}
bootstrap();
