import { Controller, Get } from '@nestjs/common';
import { AppService } from './app.service';
import { ApiOkResponse, ApiOperation, ApiTags } from '@nestjs/swagger';

@Controller()
@ApiTags('tips')
export class AppController {
  constructor(private readonly appService: AppService) {}

  @Get('tips.json')
  @ApiOperation({
    summary: '获取提示',
    description: '获取 SRVPro 需要的 tips.json 文件。',
  })
  @ApiOkResponse({ type: [String] })
  async getTips(): Promise<string[]> {
    return await this.appService.getTips();
  }
}
