import { Replay } from './Replay';
import { promises as fs } from 'fs';

interface ReplayParseResult {
  replay: Replay;
  path: string;
}
async function runForSingleFile(path: string): Promise<ReplayParseResult> {
  console.error(`Reading ${path}`);
  return {
    path,
    replay: await Replay.fromFile(path),
  };
}

async function runForDirectory(dir: string) {
  const files = (await fs.readdir(dir)).filter((f) => f.endsWith('yrp'));
  const res: ReplayParseResult[] = [];
  for (const file of files) {
    const path = `${dir}/${file}`;
    res.push(await runForSingleFile(path));
  }
  return res;
}

async function main() {
  const res = await runForDirectory(process.argv[2] || './replay');
  console.log(JSON.stringify(res, null, 2));
}
main();
