// types/lua-format.d.ts
declare module "lua-format" {
  /** 配置项，与 index.js/luamin.js 的用法一致 */
  export interface LuaFormatSettings {
    RenameVariables?: boolean;
    RenameGlobals?: boolean;
    SolveMath?: boolean;
    Indentation?: string;
  }

  /** 美化 Lua 源码 */
  export function Beautify(code: string, settings?: LuaFormatSettings): string;

  /** 压缩 Lua 源码 */
  export function Minify(code: string, settings?: LuaFormatSettings): string;

  /** 另一种压缩/混淆方式 */
  export function Uglify(code: string, settings?: LuaFormatSettings): string;

  // CommonJS 默认导出是对象形式
  const _default: {
    Beautify: typeof Beautify;
    Minify: typeof Minify;
    Uglify: typeof Uglify;
  };
  export default _default;
}
