export interface LuaFormatSettings {
  RenameVariables?: boolean;
  RenameGlobals?: boolean;
  SolveMath?: boolean;
  Indentation?: string;
}

/** 美化 Lua 源码 */
export declare function Beautify(
  code: string,
  settings?: LuaFormatSettings,
): string;

/** 压缩 Lua 源码 */
export declare function Minify(
  code: string,
  settings?: LuaFormatSettings,
): string;

/** 另一种压缩/混淆方式 */
export declare function Uglify(
  code: string,
  settings?: LuaFormatSettings,
): string;
