import { Injectable } from '@nestjs/common';

@Injectable()
export class MatchService {
  matchText(text: string) {
    if (!text) {
      return [];
    }
    const exactMatches = text.match(/QQ:\s*\d{8,10}/g);
    if (exactMatches) {
      return exactMatches.map((info) => info.replace(/^QQ:\s*/, ''));
    }
    return text.match(/\d{9,10}/g) || [];
  }
}
