import { Module } from '@nestjs/common';
import { ConfigModule, ConfigService } from '@nestjs/config';
import { loadConfig } from './utility/config';
import { HttpModule } from '@nestjs/axios';
import { HamiFetcherService } from './hami-fetcher/hami-fetcher.service';
import { OcrService } from './ocr/ocr.service';
import { BlacklistService } from './blacklist/blacklist.service';
import { BlacklistController } from './blacklist/blacklist.controller';
import { MatchService } from './match/match.service';

@Module({
  imports: [
    ConfigModule.forRoot({
      load: [loadConfig],
      ignoreEnvVars: true,
      ignoreEnvFile: true,
      isGlobal: true,
    }),
    HttpModule.registerAsync({
      inject: [ConfigService],
      useFactory: async (configService: ConfigService) =>
        configService.get('http'),
    }),
  ],
  providers: [HamiFetcherService, OcrService, BlacklistService, MatchService],
  controllers: [BlacklistController],
})
export class AppModule {}
