import yaml from 'yaml';
import * as fs from 'fs';
import { HttpModuleOptions } from '@nestjs/axios';
import * as os from 'os';

export interface Config {
  host: string;
  port: number;
  http?: HttpModuleOptions;
  hamiUsername: string;
  hamiBlacklistSearch: string;
  twintUrl: string;
  twintToken: string;
  cocurrency: number;
}

const defaultConfig: Config = {
  host: '::',
  port: 3000,
  http: {},
  hamiUsername: 'Hamimelon7',
  hamiBlacklistSearch: '蔷蔷挂人板',
  twintUrl: 'http://twint',
  twintToken: 'twintToken',
  cocurrency: os.cpus().length,
};

export async function loadConfig(): Promise<Config> {
  let readConfig: Partial<Config> = {};
  try {
    const configText = await fs.promises.readFile('./config.yaml', 'utf-8');
    readConfig = yaml.parse(configText);
  } catch (e) {
    console.error(`Failed to read config: ${e.toString()}`);
  }
  return {
    ...defaultConfig,
    ...readConfig,
    ...process.env,
  };
}
