import { ConsoleLogger, Injectable } from '@nestjs/common';
import { HttpService } from '@nestjs/axios';
import { lastValueFrom } from 'rxjs';
import { recognize } from 'node-tesseract-ocr';
import PQueue from 'p-queue';
import { ConfigService } from '@nestjs/config';
import { MatchService } from 'src/match/match.service';

@Injectable()
export class OcrService extends ConsoleLogger {
  constructor(
    private http: HttpService,
    private config: ConfigService,
    private match: MatchService,
  ) {
    super('OcrService');
  }

  private queue = new PQueue({
    concurrency: parseInt(this.config.get('cocurrency')),
  });

  private async checkImageProcess(url: string): Promise<string[]> {
    try {
      const { data } = await lastValueFrom(
        this.http.get<Buffer>(url, {
          responseType: 'arraybuffer',
          timeout: 30000,
        }),
      );
      const text = await recognize(data);
      return this.match.matchText(text);
    } catch (e) {
      this.error(`Failed to check url ${url}: ${e.message}`);
    }
  }

  checkImage(url: string) {
    return this.queue.add(() => this.checkImageProcess(url));
  }
}
