export interface TwintReturn {
  data: TwintData[];
  message: string;
  statusCode: number;
  success: boolean;
}

export interface TwintData {
  cashtags: string[];
  conversation_id: string;
  datestamp: string;
  datetime: string;
  geo: string;
  hashtags: string[];
  id: number;
  id_str: string;
  lang: string;
  likes_count: number;
  link: string;
  mentions: string[];
  name: string;
  near: string;
  photos: string[];
  place: string;
  quote_url: string;
  replies_count: number;
  reply_to: string[];
  retweet: boolean;
  retweet_date: string;
  retweet_id: string;
  retweets_count: number;
  source: string;
  thumbnail: string;
  timestamp: string;
  timezone: string;
  trans_dest: string;
  trans_src: string;
  translate: string;
  tweet: string;
  urls: string[];
  user_id: number;
  user_id_str: string;
  user_rt: string;
  user_rt_id: string;
  username: string;
  video: number;
}

export interface HamiData extends TwintData {
  accounts: string[];
}

export class HamiResult implements HamiData {
  static fromData(data: HamiData): HamiResult {
    const result = new HamiResult();
    Object.assign(result, data);
    return result;
  }

  cashtags: string[];
  conversation_id: string;
  datestamp: string;
  datetime: string;
  geo: string;
  hashtags: string[];
  id: number;
  id_str: string;
  lang: string;
  likes_count: number;
  link: string;
  mentions: string[];
  name: string;
  near: string;
  photos: string[];
  place: string;
  quote_url: string;
  replies_count: number;
  reply_to: string[];
  retweet: boolean;
  retweet_date: string;
  retweet_id: string;
  retweets_count: number;
  source: string;
  thumbnail: string;
  timestamp: string;
  timezone: string;
  trans_dest: string;
  trans_src: string;
  translate: string;
  tweet: string;
  urls: string[];
  user_id: number;
  user_id_str: string;
  user_rt: string;
  user_rt_id: string;
  username: string;
  video: number;
  accounts: string[];
}
