import { ApiProperty } from '@nestjs/swagger';
import { HttpException } from '@nestjs/common';

export interface BlankReturnMessage {
  statusCode: number;
  message: string;
  success: boolean;
}

export interface ReturnMessage<T> extends BlankReturnMessage {
  data?: T;
}

export class BlankReturnMessageDto implements BlankReturnMessage {
  @ApiProperty({ description: '返回状态' })
  statusCode: number;
  @ApiProperty({ description: '返回信息' })
  message: string;
  @ApiProperty({ description: '是否成功' })
  success: boolean;
  constructor(statusCode: number, message?: string) {
    this.statusCode = statusCode;
    this.message = message || 'success';
    this.success = statusCode < 400;
  }

  toException() {
    return new HttpException(this, this.statusCode);
  }
}

type AnyClass = new (...args: any[]) => any;
type ClassOrArray = AnyClass | [AnyClass];
type TypeFromClass<T> = T extends new (...args: any[]) => infer U ? U : never;
export type ParseType<T extends ClassOrArray> = T extends [infer U]
  ? TypeFromClass<U>[]
  : TypeFromClass<T>;

function getClass(o: ClassOrArray) {
  return o instanceof Array ? o[0] : o;
}

export function ReturnMessageDto<T extends ClassOrArray>(type: T) {
  const cl = class SpecificReturnMessage extends BlankReturnMessageDto {
    data?: ParseType<T>;
    constructor(statusCode: number, message?: string, data?: ParseType<T>) {
      super(statusCode, message);
      this.data = data;
    }
  };
  ApiProperty({ description: '返回数据', type })(cl.prototype, 'data');
  Object.defineProperty(cl, 'name', {
    value: `${getClass(type).name}ReturnMessageDto`,
  });
  return cl;
}
