import { ConsoleLogger, Injectable } from '@nestjs/common';
import { HamiFetcherService } from '../hami-fetcher/hami-fetcher.service';
import { OcrService } from '../ocr/ocr.service';
import { HamiData, HamiResult, TwintData } from '../dto/hami.dto';
import _ from 'lodash';
import { MatchService } from 'src/match/match.service';

@Injectable()
export class BlacklistService extends ConsoleLogger {
  constructor(
    private fetcher: HamiFetcherService,
    private ocr: OcrService,
    private match: MatchService,
  ) {
    super('BlacklistService');
  }
  async fetchBlacklist(since: string) {
    const twintData = await this.fetcher.fetchBlacklist(since);
    this.log(`Fetched ${twintData.length} tweets of blacklist.`);
    const checkedData = await Promise.all(
      twintData.map((data) => this.checkTweet(data)),
    );
    const result = checkedData
      .filter((data) => data.accounts?.length)
      .map((data) => HamiResult.fromData(data));
    this.log(`Found ${result.length} valid tweets.`);
    return result;
  }

  async checkTweet(data: TwintData): Promise<HamiData> {
    const urls = data.photos || [];
    const accounts = [
      ...(
        await Promise.all(urls.map((url) => this.ocr.checkImage(url)))
      ).flat(),
      ...this.match.matchText(data.tweet),
    ];
    if (accounts.length) {
      this.log(`Found account ${accounts.join(', ')} in tweet ${data.link}`);
    }
    return {
      ...data,
      accounts: _.uniq(accounts),
    };
  }
}
