import { Controller, Get, Query } from '@nestjs/common';
import { BlacklistService } from './blacklist.service';
import { ApiOkResponse, ApiOperation, ApiQuery } from '@nestjs/swagger';
import {
  BlankReturnMessageDto,
  ReturnMessageDto,
} from '../dto/ReturnMessage.dto';
import { HamiResult } from '../dto/hami.dto';

const HamiResultDto = ReturnMessageDto([HamiResult]);

@Controller('blacklist')
export class BlacklistController {
  constructor(private blacklist: BlacklistService) {}

  @Get()
  @ApiOperation({ summary: '获取黑名单' })
  @ApiQuery({ name: 'since', description: '获取黑名单的起始时间' })
  @ApiOkResponse({ type: HamiResultDto })
  async getBlacklist(@Query('since') since: string) {
    if (!since) {
      throw new BlankReturnMessageDto(400, 'since is required');
    }
    const data = await this.blacklist.fetchBlacklist(since);
    return new HamiResultDto(200, 'success', data);
  }
}
