import { Entity, Index, OneToMany } from 'typeorm';
import { BlacklistAccount } from './blacklist-account.entity';
import {
  DateColumn,
  IdBase,
  NotColumn,
  StringColumn,
  StringIdBase,
} from 'nicot';

interface TwintData {
  cashtags: string[];
  conversation_id: string;
  datestamp: string;
  datetime: string;
  geo: string;
  hashtags: string[];
  id: number;
  id_str: string;
  lang: string;
  likes_count: number;
  link: string;
  mentions: string[];
  name: string;
  near: string;
  photos: string[];
  place: string;
  quote_url: string;
  replies_count: number;
  reply_to: string[];
  retweet: boolean;
  retweet_date: string;
  retweet_id: string;
  retweets_count: number;
  source: string;
  thumbnail: string;
  timestamp: string;
  timezone: string;
  trans_dest: string;
  trans_src: string;
  translate: string;
  tweet: string;
  urls: string[];
  user_id: number;
  user_id_str: string;
  user_rt: string;
  user_rt_id: string;
  username: string;
  video: number;
}

export interface HamiData extends TwintData {
  accounts: string[];
}

@Entity()
export class Blacklist extends StringIdBase({ length: 32 }) {
  @StringColumn(100, {
    description: 'Twitter link',
    required: true,
  })
  link: string;

  @Index()
  @DateColumn({
    description: 'Tweet time',
    required: true,
  })
  time: Date;

  @StringColumn(500, {
    description: 'Tweet content',
    required: true,
  })
  content: string;

  @NotColumn()
  @OneToMany(
    () => BlacklistAccount,
    (blacklistAccount) => blacklistAccount.blacklist,
    { cascade: true },
  )
  accounts: BlacklistAccount[];

  fromData(data: HamiData) {
    this.link = data.link;
    this.id = data.id_str;
    this.time = new Date(data.datetime.slice(0, -4));
    this.content = data.tweet.replace(/\s*https:\/\/t\.co\/.*/, '');
    this.accounts = data.accounts.map((account) => {
      const ent = new BlacklistAccount();
      ent.account = account;
      return ent;
    });
    return this;
  }
}
