import { Entity, Index, ManyToOne, Unique } from 'typeorm';
import { Blacklist } from './blacklist.entity';
import { IdBase, NotColumn, QueryEqual, StringColumn } from 'nicot';

@Unique(['account', 'blacklist'])
@Entity()
export class BlacklistAccount extends IdBase() {
  @Index()
  @QueryEqual()
  @StringColumn(11, {
    required: true,
    description: 'QQ account number.',
  })
  account: string;

  @QueryEqual()
  @StringColumn(32, {
    required: true,
    description: 'Blacklist ID.',
  })
  blacklistId: string;

  @NotColumn()
  @ManyToOne(() => Blacklist, (blacklist) => blacklist.accounts, {
    onDelete: 'CASCADE',
  })
  blacklist: Blacklist;
}
