import { Entity } from 'typeorm';
import { BoolColumn, IdBase, IntColumn, StringColumn } from 'nicot';

@Entity()
export class Ad extends IdBase() {
  @StringColumn(100, {
    description: 'Ad link',
    required: false,
  })
  link: string;

  @StringColumn(10000, {
    description: 'Ad content',
    required: true,
  })
  content: string;

  @IntColumn('int', {
    description: 'Ad view count',
    default: 0,
    unsigned: true,
  })
  viewCount: number;

  @IntColumn('int', {
    description: 'Ad click count',
    default: 0,
    unsigned: true,
  })
  clickCount: number;

  @BoolColumn({
    description: 'Ad is enabled',
    default: true,
  })
  enabled: boolean;
}
