import { Controller, Header } from '@nestjs/common';
import { BlacklistAccount } from '../entities/blacklist-account.entity';
import { BlacklistAccountService } from './blacklist-account.service';
import { RestfulFactory } from 'nicot';

const dec = new RestfulFactory(BlacklistAccount, {
  relations: ['blacklist'],
});
class FindAllBlacklistAccountDto extends dec.findAllDto {}

@Controller('blacklist')
export class BlacklistAccountController {
  constructor(
    private readonly blacklistAccountService: BlacklistAccountService,
  ) {}

  @dec.findAll()
  @Header(
    'Cache-Control',
    'public, max-age=600, stale-while-revalidate=600, stale-if-error=604800',
  )
  findAll(@dec.findAllParam() param: FindAllBlacklistAccountDto) {
    return this.blacklistAccountService.findAll(param);
  }
}
