import { Injectable } from '@nestjs/common';
import { BlankReturnMessageDto, CrudService } from 'nicot';
import { Ad } from '../entities/ad.entity';
import { InjectDataSource } from '@nestjs/typeorm';
import { DataSource, FindOptionsWhere } from 'typeorm';

@Injectable()
export class AdService extends CrudService(Ad) {
  constructor(@InjectDataSource() db: DataSource) {
    super(db.getRepository(Ad));
  }

  async getAd(id?: number) {
    const cond: FindOptionsWhere<Ad> = id ? { id } : { enabled: true };
    const activeAds = await this.repo.find({
      where: cond,
      select: {
        id: true,
        content: true,
      },
    });
    if (!activeAds.length) {
      return null;
    }
    const randomIndex = Math.floor(Math.random() * activeAds.length);
    await this.repo.increment(
      { id: activeAds[randomIndex].id },
      'viewCount',
      1,
    );
    return activeAds[randomIndex];
  }

  async clickAd(id: number) {
    const ad = await this.repo.findOne({
      where: {
        // enabled: true,
        id,
      },
      select: {
        link: true,
      },
    });
    if (!ad) {
      throw new BlankReturnMessageDto(404, 'Ad not found').toException();
    }
    if (!ad.link) {
      return '';
    }
    await this.repo.increment({ id }, 'clickCount', 1);
    return ad.link;
  }
}
