import {
  Controller,
  DefaultValuePipe,
  Get,
  Param,
  ParseIntPipe,
  Query,
} from '@nestjs/common';
import { AdService } from './ad.service';
import {
  ApiOkResponse,
  ApiOperation,
  ApiParam,
  ApiQuery,
} from '@nestjs/swagger';
import { ReturnMessageDto, StringReturnMessageDto } from 'nicot';
import { Ad } from '../entities/ad.entity';

const AdReturnMessageDto = ReturnMessageDto(Ad);

@Controller('ad')
export class AdController {
  constructor(private ad: AdService) {}

  @Get('random')
  @ApiOperation({ summary: 'Get ad' })
  @ApiQuery({ name: 'id', type: Number, required: false })
  @ApiOkResponse({ type: AdReturnMessageDto })
  async getAd(
    @Query('id', new DefaultValuePipe(0), new ParseIntPipe()) id: number,
  ) {
    return new AdReturnMessageDto(200, 'success', await this.ad.getAd(id));
  }

  @Get('click/:id')
  @ApiOperation({ summary: 'Click ad' })
  @ApiParam({ name: 'id', type: Number })
  @ApiOkResponse({ type: StringReturnMessageDto })
  async clickAd(@Param('id', new ParseIntPipe()) id: number) {
    return new StringReturnMessageDto(
      200,
      'success',
      await this.ad.clickAd(id),
    );
  }
}
