#!/bin/bash

echo '' > /var/lib/cloudflare-warp/cfwarp_service_log.txt
daemonPid=0

initProxy() {
	warp-svc &
	daemonPid=$!
	daemonReady=1
	while [[ "$daemonReady" != "0" ]]; do
		echo "Waiting for daemon start"
		grep "cloudflare-warp/warp_service" /var/lib/cloudflare-warp/cfwarp_service_log.txt
		daemonReady=$?
	done
	echo "Daemon started"

	if [[ ! -f "/var/lib/cloudflare-warp/reg.json" ]]; then
	if [[ -n "$WARP_LICENSE" ]]; then
		warp-cli --accept-tos registration license "$WARP_LICENSE"
	else
		warp-cli --accept-tos registration new
	fi
	fi
	warp-cli mode proxy
	warp-cli proxy port $LOCAL_PROXY_PORT
	warp-cli connect
}

restartProxy() {
	kill $daemonPid
	initProxy
}

watcher() {
	workedOnce=0
	while true; do
		echo "Checking proxy status"
		curl -x localhost:$LOCAL_PROXY_PORT -o /dev/null -s https://www.google.com/
		checkResult=$?
		if [[ $checkResult -gt 0 ]]; then
			if [[ $workedOnce -eq 0 ]]; then
				echo "Proxy is still starting up"
			else
				echo "Proxy is down, restarting"
				restartProxy
			fi
			sleep 10
		else
			echo "Proxy is up"
			workedOnce=1
			sleep 5
		fi
	done
}

initProxy
watcher &

"$@"
