#!/bin/bash

echo '' > /var/lib/cloudflare-warp/cfwarp_service_log.txt
warp-svc &

daemonReady=1
while [[ "$daemonReady" != "0" ]]; do
	echo "Waiting for daemon start"
	grep "cloudflare-warp/warp_service" /var/lib/cloudflare-warp/cfwarp_service_log.txt
	daemonReady=$?
done
echo "Daemon started"

if [[ ! -f "/var/lib/cloudflare-warp/reg.json" ]]; then
	if [[ -n "$WARP_LICENSE" ]]; then
		warp-cli --accept-tos set-license "$WARP_LICENSE"
	else
		warp-cli --accept-tos register
	fi
fi

warp-cli set-mode proxy
warp-cli set-proxy-port $LOCAL_PROXY_PORT
warp-cli connect

"$@"
