import os

import twint
from dacite import from_dict
from flask import Flask, request
app = Flask(__name__)

accessToken = os.environ.get("ACCESS_TOKEN")

allow_list = ["Search", "Profile","Favorites"]

def makeResponse(statusCode, message, data):
    return { 'success': statusCode < 400, 'statusCode': statusCode, 'message': message, 'data': data }, statusCode


@app.route("/<methodname>", methods=['POST'])
def encrypt(methodname):
    if accessToken and request.headers.get("Authorization") != accessToken:
        return makeResponse(403, "Access denied", None)
    if methodname not in allow_list:
        return makeResponse(404, "Method not found", None)
    config_data = request.json
    set_proxy(config_data)
    tweets = []
    c = from_dict(data_class=twint.Config,data=config_data)
    c.Store_object = True
    c.Store_object_tweets_list = tweets
    method = getattr(twint.run, methodname)
    method(c)
    data = []
    for tweets in tweets:
        data.append(tweets.__dict__)
    return makeResponse(200, "success", data)


def set_proxy(c):
    env_list = ["Proxy_host","Proxy_port","Proxy_type","Tor_control_port","Tor_control_password"]
    for i in env_list:
        e =  os.environ.get(i)
        if e:
            c[i] = e


if __name__ == '__main__':
    app.run(debug=True, host='0.0.0.0')
