#!/bin/bash
if [ -z $TAIKO_SONGS_URL ]; then 
	export TAIKO_SONGS_URL=$TAIKO_URL/songs/
fi
if [ -z $TAIKO_ASSETS_URL ]; then 
	export TAIKO_ASSETS_URL=$TAIKO_URL/assets/
fi
echo "{\"songs_baseurl\":\"$TAIKO_SONGS_URL\",\"assets_baseurl\":\"$TAIKO_ASSETS_URL\",\"multiplayer_baseurl\":\"$TAIKO_MULTIPLAYER_URL\",\"email\":\"$TAIKO_EMAIL\",\"redis_host\":\"$TAIKO_REDIS_HOST\",\"redis_port\":$TAIKO_REDIS_PORT,\"redis_password\":\"$TAIKO_REDIS_PASSWORD\",\"redis_db\":$TAIKO_REDIS_DB,\"git_url\":\"$TAIKO_GIT_URL\"}" | tee ./config.json
echo "{\"commit\":\"$(git log --pretty=%H -1)\",\"commit_short\":\"$(git log --pretty=%h -1)\",\"version\": \"$TAIKO_VERSION\"}" | tee ./version.json

pm2-docker start ./docker/pm2-docker.json
