﻿function StringsJa(){
	this.id = "ja"
	this.name = "日本語"
	this.regex = /^ja$/
	this.font = "TnT, Meiryo, sans-serif"
	
	this.titleProceed = "クリックするかEnterを押す！"
	this.categories = {
		"J-POP": "J-POP",
		"アニメ": "アニメ",
		"ボーカロイド™曲": "ボーカロイド™曲",
		"バラエティ": "バラエティ",
		"クラシック": "クラシック",
		"ゲームミュージック": "ゲームミュージック",
		"ナムコオリジナル": "ナムコオリジナル"
	}
	this.selectSong = "曲をえらぶ"
	this.selectDifficulty = "むずかしさをえらぶ"
	this.back = "もどる"
	this.random = "ランダム"
	this.randomSong = "ランダムに曲をえらぶ"
	this.tutorial = "あそびかた説明"
	this.aboutSimulator = "このシミュレータについて"
	this.browse = "参照する…"
	this.defaultSongList = "デフォルト曲リスト"
	this.songOptions = "演奏オプション"
	this.none = "なし"
	this.auto = "オート"
	this.netplay = "ネットプレイ"
	this.easy = "かんたん"
	this.normal = "ふつう"
	this.hard = "むずかしい"
	this.oni = "おに"
	this.sessionStart = "オンラインセッションを開始する！"
	this.sessionEnd = "オンラインセッションを終了する"
	this.loading = "ロード中..."
	this.cancel = "キャンセル"
	this.note = {
		don: "ドン",
		ka: "カッ",
		daiDon: "ドン(大)",
		daiKa: "カッ(大)",
		drumroll: "連打ーっ!!",
		daiDrumroll: "連打(大)ーっ!!",
		balloon: "ふうせん"
	}
	this.combo = "コンボ"
	this.clear = "クリア"
	this.good = "良"
	this.ok = "可"
	this.bad = "不可"
	this.pauseOptions = [
		"演奏をつづける",
		"はじめからやりなおす",
		"「曲をえらぶ」にもどる"
	]
	this.results = "成績発表"
	this.points = "点"
	this.maxCombo = "最大コンボ数"
	this.drumroll = "連打数"
}
function StringsEn(){
	this.id = "en"
	this.name = "English"
	this.regex = /^en$|^en-/
	this.font = "TnT, Meiryo, sans-serif"
	
	this.titleProceed = "Click or Press Enter!"
	this.categories = {
		"J-POP": "Pop",
		"アニメ": "Anime",
		"ボーカロイド™曲": "VOCALOID™ Music",
		"バラエティ": "Variety",
		"クラシック": "Classical",
		"ゲームミュージック": "Game Music",
		"ナムコオリジナル": "NAMCO Original"
	}
	this.selectSong = "Select Song"
	this.selectDifficulty = "Select Difficulty"
	this.back = "Back"
	this.random = "Random"
	this.randomSong = "Random Song"
	this.tutorial = "How to Play"
	this.aboutSimulator = "About Simulator"
	this.browse = "Browse…"
	this.defaultSongList = "Default Song List"
	this.songOptions = "Song Options"
	this.none = "None"
	this.auto = "Auto"
	this.netplay = "Netplay"
	this.easy = "Easy"
	this.normal = "Normal"
	this.hard = "Hard"
	this.oni = "Extreme"
	this.sessionStart = "Begin an Online Session!"
	this.sessionEnd = "End Online Session"
	this.loading = "Loading..."
	this.cancel = "Cancel"
	this.note = {
		don: "Don",
		ka: "Ka",
		daiDon: "DON",
		daiKa: "KA",
		drumroll: "Drum rollー!!",
		daiDrumroll: "DRUM ROLLー!!",
		balloon: "Balloon"
	}
	this.combo = "Combo"
	this.clear = "Clear"
	this.good = "GOOD"
	this.ok = "OK"
	this.bad = "BAD"
	this.pauseOptions = [
		"Continue",
		"Retry",
		"Back to Select Song"
	]
	this.results = "Results"
	this.points = "pts"
	this.maxCombo = "MAX Combo"
	this.drumroll = "Drumroll"
}
function StringsCn(){
	this.id = "cn"
	this.name = "中文简体"
	this.regex = /^zh$|^zh-CN$/
	this.font = "Microsoft YaHei, sans-serif"
	
	this.titleProceed = "点击或按回车！"
	this.categories = {
		"J-POP": "流行音乐",
		"アニメ": "卡通动画音乐",
		"ボーカロイド™曲": "VOCALOID™ Music",
		"バラエティ": "综合音乐",
		"クラシック": "古典音乐",
		"ゲームミュージック": "游戏音乐",
		"ナムコオリジナル": "NAMCO原创音乐"
	}
	this.selectSong = "选择乐曲"
	this.selectDifficulty = "选择难度"
	this.back = "返回"
	this.random = "随机"
	this.randomSong = "随机选曲"
	this.tutorial = "操作说明"
	this.aboutSimulator = "游戏信息"
	this.browse = "浏览…"
	this.defaultSongList = "默认歌曲列表"
	this.songOptions = "选项"
	this.none = "无"
	this.auto = "自动"
	this.netplay = "网络对战"
	this.easy = "简单"
	this.normal = "普通"
	this.hard = "困难"
	this.oni = "魔王"
	this.sessionStart = "开始在线会议!"
	this.sessionEnd = "结束在线会话"
	this.loading = "读取中..."
	this.cancel = "取消"
	this.note = {
		don: "咚",
		ka: "咔",
		daiDon: "咚(大)",
		daiKa: "咔(大)",
		drumroll: "连打ー!!",
		daiDrumroll: "连打(大)ー!!",
		balloon: "气球"
	}
	this.combo = "连段"
	this.clear = "通关"
	this.good = "良"
	this.ok = "可"
	this.bad = "不可"
	this.pauseOptions = [
		"继续演奏",
		"从头开始",
		"返回「选择乐曲」"
	]
	this.results = "发表成绩"
	this.points = "点"
	this.maxCombo = "最多连段数"
	this.drumroll = "连打数"
}
function StringsTw(){
	this.id = "tw"
	this.name = "中文繁體"
	this.regex = /^zh-HK$|^zh-TW$/
	this.font = "Microsoft YaHei, sans-serif"
	
	this.titleProceed = "點擊或按回車！"
	this.categories = {
		"J-POP": "流行音樂",
		"アニメ": "卡通動畫音樂",
		"ボーカロイド™曲": "VOCALOID™ Music",
		"バラエティ": "綜合音樂",
		"クラシック": "古典音樂",
		"ゲームミュージック": "遊戲音樂",
		"ナムコオリジナル": "NAMCO原創音樂"
	}
	this.selectSong = "選擇樂曲"
	this.selectDifficulty = "選擇難度"
	this.back = "返回"
	this.random = "隨機"
	this.randomSong = "隨機選曲"
	this.tutorial = "操作说明"
	this.aboutSimulator = "游戏信息"
	this.browse = "浏览…"
	this.defaultSongList = "默认歌曲列表"
	this.songOptions = "選項"
	this.none = "無"
	this.auto = "自動"
	this.netplay = "网络对战"
	this.easy = "簡單"
	this.normal = "普通"
	this.hard = "困難"
	this.oni = "魔王"
	this.sessionStart = "開始在線會議!"
	this.sessionEnd = "結束在線會話"
	this.loading = "讀取中..."
	this.cancel = "取消"
	this.note = {
		don: "咚",
		ka: "咔",
		daiDon: "咚(大)",
		daiKa: "咔(大)",
		drumroll: "連打ー!!",
		daiDrumroll: "連打(大)ー!!",
		balloon: "氣球"
	}
	this.combo = "連段"
	this.clear = "通關"
	this.good = "良"
	this.ok = "可"
	this.bad = "不可"
	this.pauseOptions = [
		"繼續演奏",
		"從頭開始",
		"返回「選擇樂曲」"
	]
	this.results = "發表成績"
	this.points = "點"
	this.maxCombo = "最多連段數"
	this.drumroll = "連打數"
}
function StringsKo(){
	this.id = "ko"
	this.name = "한국어"
	this.regex = /^ko$/
	this.font = "Microsoft YaHei, sans-serif"
	
	this.titleProceed = "클릭하거나 Enter를 누릅니다!"
	this.categories = {
		"J-POP": "POP",
		"アニメ": "애니메이션",
		"ボーカロイド™曲": "VOCALOID™ Music",
		"バラエティ": "버라이어티",
		"クラシック": "클래식",
		"ゲームミュージック": "게임",
		"ナムコオリジナル": "남코 오리지널"
	}
	this.selectSong = "곡 선택"
	this.selectDifficulty = "난이도 선택"
	this.back = "돌아간다"
	this.random = "랜덤"
	this.randomSong = "랜덤"
	this.tutorial = "지도 시간"
	this.aboutSimulator = "게임 정보"
	this.browse = "찾아보기…"
	this.defaultSongList = "기본 노래 목록"
	this.songOptions = "옵션"
	this.none = "없음"
	this.auto = "오토"
	this.netplay = "넷 플레이"
	this.easy = "쉬움"
	this.normal = "보통"
	this.hard = "어려움"
	this.oni = "귀신"
	this.sessionStart = "온라인 세션 시작!"
	this.sessionEnd = "온라인 세션 끝내기"
	this.loading = "로딩 중..."
	this.cancel = "취소"
	this.note = {
		don: "쿵",
		ka: "딱",
		daiDon: "쿵(대)",
		daiKa: "딱(대)",
		drumroll: "연타ー!!",
		daiDrumroll: "연타(대)ー!!",
		balloon: "풍선"
	}
	this.combo = "콤보"
	this.clear = "클리어"
	this.good = "얼쑤"
	this.ok = "좋다"
	this.bad = "에구"
	this.pauseOptions = [
		"연주 계속하기",
		"처음부터 다시",
		"「곡 선택」으로"
	]
	this.results = "성적 발표"
	this.points = "점"
	this.maxCombo = "최대 콤보 수"
	this.drumroll = "연타 횟수"
}
var allStrings = {
	"ja": new StringsJa(),
	"en": new StringsEn(),
	"cn": new StringsCn(),
	"tw": new StringsTw(),
	"ko": new StringsKo()
}
