function SongSelect(){
 
    var _this=this;
    var _songs;
	var _selectedSong = {title:'', folder:'', difficulty:''};
	var _preview;
	var _preview_to;
	var _diffNames={
		easy:"かんたん",
		normal:"ふつう",
		hard:"むずかしい",
		oni:"おに"
	}

	this.startPreview = function(id, prvtime, first_open=true) {
		var start = Date.now();
		setTimeout(function(){
			bgm.pause();
		}, 400);

		_preview = new Audio('/songs/' + id + '/main.mp3');
		_preview.onloadeddata = function() {
			var end = Date.now();
			var delay = end - start;
			var no_delay = first_open ? 0 : 300;

			_preview.currentTime = prvtime/1000;
			_preview.volume = 0.5;

			_preview.addEventListener('ended', function(){
				this.currentTime = prvtime/1000;
				this.play();
			}, false);
			
			_preview_to = setTimeout(function(){
				_preview.play();
			}, delay <= 1000 && first_open ? 1000 : no_delay);
		}
	};

	this.endPreview = function() {
		clearTimeout(_preview_to);
		if (_preview) {
			_preview.pause();
		};
	};
    
    this.run = function(){
            
		_this.createCode();
		_this.display();
		$(window).resize(_this.display);
		
		var menuLoop = setInterval(_this.refresh, 20);
		$("#song-container").show();

		$('#songsel-help').click(function(){
			bgm.pause();
			_this.endPreview();
			assets.sounds['don'].playAsset();

			new Tutorial();
		});
		
		$(".difficulty").click(function(e){
			_this.endPreview();
			assets.sounds["diffsel"].pause();
			assets.sounds["diffsel"].currentTime = 0;
			assets.sounds["don"].playAsset();

			clearInterval(menuLoop);
			var difficultyElement = (e.target.className=="stars" || e.target.className=="diffname") ? e.target.parentElement : e.target;
			_selectedSong.difficulty = difficultyElement.classList[1]+'.osu';
			var parentID = $(this).parent().closest(".song").attr("id");
			var songID = parseInt(parentID.substr(5, parentID.length-1));
			_selectedSong.title = $(this).parent().closest('.song').data('title');
			_selectedSong.folder = songID;
            
            bgm.pause();
			new loadSong(_selectedSong, e.shiftKey);
		});
		
		$(".song").hover(function(){
			if(!$(this).hasClass("opened"))
				$(this).css("background", "rgba(255, 233, 125, 0.90)");
		},
		function(){
			if(!$(this).hasClass("opened"))
				$(this).css("background", "rgba(255, 220, 47, 0.90)");
		});
		
		$(".song").click(function(e){
			if (!$(e.target).parents('.difficulties').length) {
				if ($(".opened").length && $(".opened").attr('id') == $(this).attr('id')) {
					_this.endPreview();
					bgm.play();
					assets.sounds["cancel"].playAsset();
					$(".difficulty").hide();
					$(".opened").removeClass("opened", 300);

					assets.sounds["diffsel"].pause();
					assets.sounds["diffsel"].currentTime = 0;
					setTimeout(function(){
						assets.sounds["song-select"].playAsset();
					}, 300);

					$('.songsel-title').fadeOut(200, function(){
						$('.songsel-title').attr('alt', '曲をえらぶ').html('曲をえらぶ').css('left', -300);
						$('.songsel-title').animate({left:0, opacity:"show"}, 400);
					});

					return;
				}


				if(!$('.opened').length) {
					_this.startPreview($(this).data('song-id'), $(this).data('preview'));
					assets.sounds["don"].playAsset();
					assets.sounds["song-select"].pause();
					assets.sounds["song-select"].currentTime = 0;
					setTimeout(function(){
						assets.sounds["diffsel"].playAsset();
					}, 300);

					$('.songsel-title').fadeOut(200, function(){
						$('.songsel-title').attr('alt', 'むずかしさをえらぶ').html('むずかしさをえらぶ').css('left', -300);
						$('.songsel-title').animate({left:0, opacity:"show"}, 400);
					});
				} else {
					_preview.pause();
					_this.startPreview($(this).data('song-id'), $(this).data('preview'), false);
					assets.sounds["ka"].playAsset();
				}
			};

			$(".difficulty").hide();
			$(".opened").removeClass("opened", 300);
			$(this).addClass("opened", 300, "linear", function(){
				$(this).find(".difficulty").show();
				$(this).css("background", "rgba(255, 220, 47, 0.90)");
			});
		});

	}

	this.createCode = function(){
		bgm = new BufferedLoop(
			{url: '/assets/audio/bgm_songsel.ogg', duration: 1.442},
			{url: '/assets/audio/bgm_songsel_loop.ogg', duration: 2.064}
		);
		bgm.play();
		
		setTimeout(function(){
			assets.sounds["song-select"].playAsset();
		}, 200);
		
		var songElements = [0]
		
		for(var i=0; i<assets.songs.length; i++){
			
			var song = assets.songs[i];
			var songTitle = song.title;
			var skipChars = [];
			var charElements = [0]
			var diffElements = [0]
			
			for (var c=0; c<songTitle.length; c++) {
				if (skipChars.indexOf(c) > -1) {
					continue;
				};
				
				var ch = songTitle.charAt(c) == " " ? "\xa0" : songTitle.charAt(c);
				
				var isApos = false;
				if (songTitle.charAt(c+1) == "'") {
					ch = ch + "'";
					skipChars.push(c+1);
					isApos = true;
				};
				
				var cl = ch == "\xa0" ? "song-title-char song-title-space" : "song-title-char";
				cl = isApos ? cl + " song-title-apos" : cl;
				
				charElements.push(
					["span", {
						class: cl,
						alt: ch
					}, ch]
				)
			};
			
			for(var diff in _diffNames){
				var diffName = diff;
				var diffLevel = song.stars[diff];
				if (!diffLevel) {
					continue;
				}
				
				var starsDisplay = [0]
				for(var x=1; x<=diffLevel; x++){
					starsDisplay.push("\u2605")
					starsDisplay.push(["br"])
				}
				
				var diffTxt=_diffNames[diffName]
				
				diffElements.push(
					["li", {
						class: "difficulty " + diffName
					},
						["span", {
							class: "diffname"
						}, diffTxt],
						["span", {
							class: "stars"
						}, starsDisplay]
					]
				)
			
			}
			
			songElements.push(
				["div", {
					id: "song-" + song.id,
					class: "song",
					"data-title": songTitle,
					"data-song-id": song.id,
					"data-preview": song.preview
				},
					["div", {
						class: /^[\x00-\xFF]*$/.test(songTitle) ? "song-title alpha-title" : "song-title"
					}, charElements],
					["ul", {
						class: "difficulties"
					}, diffElements]
				]
			)
		}
		
		element(
			document.getElementById("song-container"),
			songElements
		)
		$('.difficulty').hide();
	}
    
    this.display = function(){
    }
    
    this.refresh = function(){
        
    }
	
	$("#screen").load("/src/views/songselect.html", _this.run);
    
}