﻿function StringsJa(){
	this.id = "ja"
	this.name = "日本語"
	this.regex = /^ja$/
	this.font = "TnT, Meiryo, sans-serif"
	
	this.taikoWeb = "たいこウェブ"
	this.titleProceed = "クリックするかEnterを押す！"
	this.titleDisclaimer = "この非公式シミュレーターはバンダイナムコとは関係がありません。"
	this.titleCopyright = "Taiko no Tatsujin ©&™ 2011 BANDAI NAMCO Entertainment Inc."
	this.categories = {
		"J-POP": "J-POP",
		"アニメ": "アニメ",
		"ボーカロイド™曲": "ボーカロイド™曲",
		"バラエティ": "バラエティ",
		"クラシック": "クラシック",
		"ゲームミュージック": "ゲームミュージック",
		"ナムコオリジナル": "ナムコオリジナル"
	}
	this.selectSong = "曲をえらぶ"
	this.selectDifficulty = "むずかしさをえらぶ"
	this.back = "もどる"
	this.random = "ランダム"
	this.randomSong = "ランダムに曲をえらぶ"
	this.howToPlay = "あそびかた説明"
	this.aboutSimulator = "このシミュレータについて"
	this.browse = "参照する…"
	this.defaultSongList = "デフォルト曲リスト"
	this.songOptions = "演奏オプション"
	this.none = "なし"
	this.auto = "オート"
	this.netplay = "ネットプレイ"
	this.easy = "かんたん"
	this.normal = "ふつう"
	this.hard = "むずかしい"
	this.oni = "おに"
	this.sessionStart = "オンラインセッションを開始する！"
	this.sessionEnd = "オンラインセッションを終了する"
	this.loading = "ロード中..."
	this.waitingForP2 = "他のプレイヤーを待っている..."
	this.cancel = "キャンセル"
	this.note = {
		don: "ドン",
		ka: "カッ",
		daiDon: "ドン(大)",
		daiKa: "カッ(大)",
		drumroll: "連打ーっ!!",
		daiDrumroll: "連打(大)ーっ!!",
		balloon: "ふうせん"
	}
	this.combo = "コンボ"
	this.clear = "クリア"
	this.good = "良"
	this.ok = "可"
	this.bad = "不可"
	this.pauseOptions = [
		"演奏をつづける",
		"はじめからやりなおす",
		"「曲をえらぶ」にもどる"
	]
	this.results = "成績発表"
	this.points = "点"
	this.maxCombo = "最大コンボ数"
	this.drumroll = "連打数"
	
	this.tutorial = {
		basics: [
			"Hit the drum when the notes reach the taiko!",
			"For red notes, hit the face of the drum (%s or %s)...",
			"...and for blue notes, hit the rim! (%s or %s)",
			"USB controllers are also supported!"
		],
		otherControls: "Other controls",
		otherTutorial: [
			"%s \u2014 pause game",
			"%s while selecting difficulty \u2014 enable autoplay mode",
			"%s while selecting difficulty \u2014 enable 2P mode"
		],
		ok: "OK"
	}
	this.about = {
		bugReporting: [
			"このシミュレータは現在開発中です。",
			"バグが発生した場合は、報告してください。",
			"Gitリポジトリかメールでバグを報告してください。"
		],
		diagnosticWarning: "以下の端末診断情報も併せて報告してください！",
		issueTemplate: "###### 下記の問題を説明してください。 スクリーンショットと診断情報を含めてください。"
	}
	this.session = {
		multiplayerSession: "オンラインセッション",
		linkTutorial: "Share this link with your friend to start playing together! Do not leave this screen while they join.",
		cancel: "キャンセル"
	}
	this.browserSupport = {
		browserWarning: "サポートされていないブラウザを実行しています (%s)",
		details: "詳しく",
		failedTests: "このテストは失敗しました：",
		supportedBrowser: "%sなどのサポートされているブラウザを使用してください"
	}
}
function StringsEn(){
	this.id = "en"
	this.name = "English"
	this.regex = /^en$|^en-/
	this.font = "TnT, Meiryo, sans-serif"
	
	this.taikoWeb = "Taiko Web"
	this.titleProceed = "Click or Press Enter!"
	this.titleDisclaimer = "This unofficial simulator is unaffiliated with BANDAI NAMCO."
	this.titleCopyright = "Taiko no Tatsujin ©&™ 2011 BANDAI NAMCO Entertainment Inc."
	this.categories = {
		"J-POP": "Pop",
		"アニメ": "Anime",
		"ボーカロイド™曲": "VOCALOID™ Music",
		"バラエティ": "Variety",
		"クラシック": "Classical",
		"ゲームミュージック": "Game Music",
		"ナムコオリジナル": "NAMCO Original"
	}
	this.selectSong = "Select Song"
	this.selectDifficulty = "Select Difficulty"
	this.back = "Back"
	this.random = "Random"
	this.randomSong = "Random Song"
	this.howToPlay = "How to Play"
	this.aboutSimulator = "About Simulator"
	this.browse = "Browse…"
	this.defaultSongList = "Default Song List"
	this.songOptions = "Song Options"
	this.none = "None"
	this.auto = "Auto"
	this.netplay = "Netplay"
	this.easy = "Easy"
	this.normal = "Normal"
	this.hard = "Hard"
	this.oni = "Extreme"
	this.sessionStart = "Begin an Online Session!"
	this.sessionEnd = "End Online Session"
	this.loading = "Loading..."
	this.waitingForP2 = "Waiting for Another Player..."
	this.cancel = "Cancel"
	this.note = {
		don: "Don",
		ka: "Ka",
		daiDon: "DON",
		daiKa: "KA",
		drumroll: "Drum rollー!!",
		daiDrumroll: "DRUM ROLLー!!",
		balloon: "Balloon"
	}
	this.combo = "Combo"
	this.clear = "Clear"
	this.good = "GOOD"
	this.ok = "OK"
	this.bad = "BAD"
	this.pauseOptions = [
		"Continue",
		"Retry",
		"Back to Select Song"
	]
	this.results = "Results"
	this.points = "pts"
	this.maxCombo = "MAX Combo"
	this.drumroll = "Drumroll"
	
	this.tutorial = {
		basics: [
			"Hit the drum when the notes reach the taiko!",
			"For red notes, hit the face of the drum (%s or %s)...",
			"...and for blue notes, hit the rim! (%s or %s)",
			"USB controllers are also supported!"
		],
		otherControls: "Other controls",
		otherTutorial: [
			"%s \u2014 pause game",
			"%s while selecting difficulty \u2014 enable autoplay mode",
			"%s while selecting difficulty \u2014 enable 2P mode"
		],
		ok: "OK"
	}
	this.about = {
		bugReporting: [
			"This simulator is still in development.",
			"Please report any bugs you find.",
			"You can report bugs either via our Git repository or email."
		],
		diagnosticWarning: "Be sure to include the following diagnostic data!",
		issueTemplate: "###### Describe the problem you are having below. Please include a screenshot and the diagnostic information."
	}
	this.session = {
		multiplayerSession: "Multiplayer Session",
		linkTutorial: "Share this link with your friend to start playing together! Do not leave this screen while they join.",
		cancel: "Cancel"
	}
	this.browserSupport = {
		browserWarning: "You are running an unsupported browser (%s)",
		details: "Details...",
		failedTests: "The following tests have failed:",
		supportedBrowser: "Please use a supported browser such as %s"
	}
}
function StringsCn(){
	this.id = "cn"
	this.name = "简体中文"
	this.regex = /^zh$|^zh-CN$|^zh-SG$/
	this.font = "Microsoft YaHei, sans-serif"
	
	this.taikoWeb = "太鼓网页"
	this.titleProceed = "点击或按回车！"
	this.titleDisclaimer = "这款非官方模拟器与BANDAI NAMCO无关。"
	this.titleCopyright = "Taiko no Tatsujin ©&™ 2011 BANDAI NAMCO Entertainment Inc."
	this.categories = {
		"J-POP": "流行音乐",
		"アニメ": "卡通动画音乐",
		"ボーカロイド™曲": "VOCALOID™ Music",
		"バラエティ": "综合音乐",
		"クラシック": "古典音乐",
		"ゲームミュージック": "游戏音乐",
		"ナムコオリジナル": "NAMCO原创音乐"
	}
	this.selectSong = "选择乐曲"
	this.selectDifficulty = "选择难度"
	this.back = "返回"
	this.random = "随机"
	this.randomSong = "随机选曲"
	this.howToPlay = "操作说明"
	this.aboutSimulator = "关于模拟器"
	this.browse = "浏览…"
	this.defaultSongList = "默认歌曲列表"
	this.songOptions = "选项"
	this.none = "无"
	this.auto = "自动"
	this.netplay = "网络对战"
	this.easy = "简单"
	this.normal = "普通"
	this.hard = "困难"
	this.oni = "魔王"
	this.sessionStart = "开始在线会话!"
	this.sessionEnd = "结束在线会话"
	this.loading = "加载中..."
	this.waitingForP2 = "Waiting for Another Player..."
	this.cancel = "取消"
	this.note = {
		don: "咚",
		ka: "咔",
		daiDon: "咚(大)",
		daiKa: "咔(大)",
		drumroll: "连打ー!!",
		daiDrumroll: "连打(大)ー!!",
		balloon: "气球"
	}
	this.combo = "连段"
	this.clear = "通关"
	this.good = "良"
	this.ok = "可"
	this.bad = "不可"
	this.pauseOptions = [
		"继续演奏",
		"从头开始",
		"返回「选择乐曲」"
	]
	this.results = "发表成绩"
	this.points = "点"
	this.maxCombo = "最多连段数"
	this.drumroll = "连打数"
	
	this.tutorial = {
		basics: [
			"Hit the drum when the notes reach the taiko!",
			"For red notes, hit the face of the drum (%s or %s)...",
			"...and for blue notes, hit the rim! (%s or %s)",
			"USB controllers are also supported!"
		],
		otherControls: "Other controls",
		otherTutorial: [
			"%s \u2014 pause game",
			"%s while selecting difficulty \u2014 enable autoplay mode",
			"%s while selecting difficulty \u2014 enable 2P mode"
		],
		ok: "确定"
	}
	this.about = {
		bugReporting: [
			"This simulator is still in development.",
			"Please report any bugs you find.",
			"You can report bugs either via our Git repository or email."
		],
		diagnosticWarning: "Be sure to include the following diagnostic data!",
		issueTemplate: "###### Describe the problem you are having below. Please include a screenshot and the diagnostic information."
	}
	this.session = {
		multiplayerSession: "Multiplayer Session",
		linkTutorial: "Share this link with your friend to start playing together! Do not leave this screen while they join.",
		cancel: "取消"
	}
	this.browserSupport = {
		browserWarning: "You are running an unsupported browser (%s)",
		details: "Details...",
		failedTests: "The following tests have failed:",
		supportedBrowser: "Please use a supported browser such as %s"
	}
}
function StringsTw(){
	this.id = "tw"
	this.name = "正體中文"
	this.regex = /^zh-HK$|^zh-TW$/
	this.font = "Microsoft YaHei, sans-serif"
	
	this.taikoWeb = "太鼓網頁"
	this.titleProceed = "點擊或按確認！"
	this.titleDisclaimer = "這款非官方模擬器與BANDAI NAMCO無關。"
	this.titleCopyright = "Taiko no Tatsujin ©&™ 2011 BANDAI NAMCO Entertainment Inc."
	this.categories = {
		"J-POP": "流行音樂",
		"アニメ": "卡通動畫音樂",
		"ボーカロイド™曲": "VOCALOID™ Music",
		"バラエティ": "綜合音樂",
		"クラシック": "古典音樂",
		"ゲームミュージック": "遊戲音樂",
		"ナムコオリジナル": "NAMCO原創音樂"
	}
	this.selectSong = "選擇樂曲"
	this.selectDifficulty = "選擇難度"
	this.back = "返回"
	this.random = "隨機"
	this.randomSong = "隨機選曲"
	this.howToPlay = "操作說明"
	this.aboutSimulator = "關於模擬器"
	this.browse = "開啟檔案…"
	this.defaultSongList = "默認歌曲列表"
	this.songOptions = "選項"
	this.none = "無"
	this.auto = "自動"
	this.netplay = "網上對打"
	this.easy = "簡單"
	this.normal = "普通"
	this.hard = "困難"
	this.oni = "魔王"
	this.sessionStart = "開始多人模式!"
	this.sessionEnd = "結束多人模式"
	this.loading = "讀取中..."
	this.waitingForP2 = "Waiting for Another Player..."
	this.cancel = "取消"
	this.note = {
		don: "咚",
		ka: "咔",
		daiDon: "咚(大)",
		daiKa: "咔(大)",
		drumroll: "連打ー!!",
		daiDrumroll: "連打(大)ー!!",
		balloon: "氣球"
	}
	this.combo = "連段"
	this.clear = "通關"
	this.good = "良"
	this.ok = "可"
	this.bad = "不可"
	this.pauseOptions = [
		"繼續演奏",
		"從頭開始",
		"返回「選擇樂曲」"
	]
	this.results = "發表成績"
	this.points = "分"
	this.maxCombo = "最多連段數"
	this.drumroll = "連打數"
	
	this.tutorial = {
		basics: [
			"Hit the drum when the notes reach the taiko!",
			"For red notes, hit the face of the drum (%s or %s)...",
			"...and for blue notes, hit the rim! (%s or %s)",
			"USB controllers are also supported!"
		],
		otherControls: "Other controls",
		otherTutorial: [
			"%s \u2014 pause game",
			"%s while selecting difficulty \u2014 enable autoplay mode",
			"%s while selecting difficulty \u2014 enable 2P mode"
		],
		ok: "確定"
	}
	this.about = {
		bugReporting: [
			"This simulator is still in development.",
			"Please report any bugs you find.",
			"You can report bugs either via our Git repository or email."
		],
		diagnosticWarning: "Be sure to include the following diagnostic data!",
		issueTemplate: "###### Describe the problem you are having below. Please include a screenshot and the diagnostic information."
	}
	this.session = {
		multiplayerSession: "Multiplayer Session",
		linkTutorial: "Share this link with your friend to start playing together! Do not leave this screen while they join.",
		cancel: "取消"
	}
	this.browserSupport = {
		browserWarning: "You are running an unsupported browser (%s)",
		details: "Details...",
		failedTests: "The following tests have failed:",
		supportedBrowser: "Please use a supported browser such as %s"
	}
}
function StringsKo(){
	this.id = "ko"
	this.name = "한국어"
	this.regex = /^ko$|^ko-/
	this.font = "Microsoft YaHei, sans-serif"
	
	this.taikoWeb = "태고 웹"
	this.titleProceed = "클릭하거나 Enter를 누릅니다!"
	this.titleDisclaimer = "이 비공식 시뮬레이터는 반다이 남코와 관련이 없습니다."
	this.titleCopyright = "Taiko no Tatsujin ©&™ 2011 BANDAI NAMCO Entertainment Inc."
	this.categories = {
		"J-POP": "POP",
		"アニメ": "애니메이션",
		"ボーカロイド™曲": "VOCALOID™ Music",
		"バラエティ": "버라이어티",
		"クラシック": "클래식",
		"ゲームミュージック": "게임",
		"ナムコオリジナル": "남코 오리지널"
	}
	this.selectSong = "곡 선택"
	this.selectDifficulty = "난이도 선택"
	this.back = "돌아간다"
	this.random = "랜덤"
	this.randomSong = "랜덤"
	this.howToPlay = "지도 시간"
	this.aboutSimulator = "게임 정보"
	this.browse = "찾아보기…"
	this.defaultSongList = "기본 노래 목록"
	this.songOptions = "옵션"
	this.none = "없음"
	this.auto = "오토"
	this.netplay = "넷 플레이"
	this.easy = "쉬움"
	this.normal = "보통"
	this.hard = "어려움"
	this.oni = "귀신"
	this.sessionStart = "온라인 세션 시작!"
	this.sessionEnd = "온라인 세션 끝내기"
	this.loading = "로딩 중..."
	this.waitingForP2 = "Waiting for Another Player..."
	this.cancel = "취소"
	this.note = {
		don: "쿵",
		ka: "딱",
		daiDon: "쿵(대)",
		daiKa: "딱(대)",
		drumroll: "연타ー!!",
		daiDrumroll: "연타(대)ー!!",
		balloon: "풍선"
	}
	this.combo = "콤보"
	this.clear = "클리어"
	this.good = "얼쑤"
	this.ok = "좋다"
	this.bad = "에구"
	this.pauseOptions = [
		"연주 계속하기",
		"처음부터 다시",
		"「곡 선택」으로"
	]
	this.results = "성적 발표"
	this.points = "점"
	this.maxCombo = "최대 콤보 수"
	this.drumroll = "연타 횟수"
	
	this.tutorial = {
		basics: [
			"Hit the drum when the notes reach the taiko!",
			"For red notes, hit the face of the drum (%s or %s)...",
			"...and for blue notes, hit the rim! (%s or %s)",
			"USB controllers are also supported!"
		],
		otherControls: "Other controls",
		otherTutorial: [
			"%s \u2014 pause game",
			"%s while selecting difficulty \u2014 enable autoplay mode",
			"%s while selecting difficulty \u2014 enable 2P mode"
		],
		ok: "확인"
	}
	this.about = {
		bugReporting: [
			"This simulator is still in development.",
			"Please report any bugs you find.",
			"You can report bugs either via our Git repository or email."
		],
		diagnosticWarning: "Be sure to include the following diagnostic data!",
		issueTemplate: "###### Describe the problem you are having below. Please include a screenshot and the diagnostic information."
	}
	this.session = {
		multiplayerSession: "Multiplayer Session",
		linkTutorial: "Share this link with your friend to start playing together! Do not leave this screen while they join.",
		cancel: "취소"
	}
	this.browserSupport = {
		browserWarning: "You are running an unsupported browser (%s)",
		details: "Details...",
		failedTests: "The following tests have failed:",
		supportedBrowser: "Please use a supported browser such as %s"
	}
}
var allStrings = {
	"ja": new StringsJa(),
	"en": new StringsEn(),
	"cn": new StringsCn(),
	"tw": new StringsTw(),
	"ko": new StringsKo()
}
