# taiko-web
A web-based Taiko no Tatsujin simulator.

Still in development. Works best with Chrome.

## Setup
Please see the [Setup](https://github.com/bui/taiko-web/wiki/Setup) page for setup instructions.

## Docker Image

The Docker image of this project is at https://hub.docker.com/r/nanahira/taiko-web .

Currently all-in-one Docker image is not available. To run this project in Docker, you would need the following external containers.

* `mongo`
* `mongo-express` if needed.
* `redis`

For the image built here, you would also need to run 2 of the containers with different start commands (for main app and multiplayer server).

* Main app: `gunicorn -b 0.0.0.0:34801 app:app`
* Multiplayer server: `python server.py`

### Ports

* `34801` Main port.
* `34802` Server port.

### Volumes

The below volumes are only needed for the Taiko Web main container. The multiplayer server container does not need one.

* `/usr/src/app/public/songs` The song folder for Taiko Web.

* `/usr/src/app/config.py` The configuration file. The following is an example.

```python
# The full URL base asset URL, with trailing slash.
ASSETS_BASEURL = 'http://taiko.example.com/assets/'

# The full URL base song URL, with trailing slash.
SONGS_BASEURL = 'http://taiko.example.com/songs/'

# The full URL base websocket URL, with trailing slash.
MULTIPLAYER_BASEURL = 'ws://taiko.example.com/p2'

# The email address to display in the "About Simulator" menu.
EMAIL = 'taiko@example.com'

# Whether to use the user account system.
ACCOUNTS = True

# Custom JavaScript file to load with the simulator.
CUSTOM_JS = ''

# MongoDB server settings.
MONGO = {
    'host': ['host': 'mnogodb://root:password@mongo:27017'],
    'database': 'taiko'
}

# Redis server settings, used for sessions + cache.
REDIS = {
    'CACHE_TYPE': 'redis',
    'CACHE_REDIS_HOST': '127.0.0.1',
    'CACHE_REDIS_PORT': 6379,
    'CACHE_REDIS_PASSWORD': None,
    'CACHE_REDIS_DB': None
}

# Secret key used for sessions.
SECRET_KEY = 'change-me'

# Git repository base URL.
URL = 'https://github.com/bui/taiko-web/'

```

### Environment Variables

* `TAIKO_VERSION` The version string written in `version.json`. eg. `Koishi`

### Example deployment files

`docker-compose.yml`:

```yaml
version: '2.4'
volumes:
  taiko_assets:
  taiko_src:
services:
  mongo:
    restart: always
    image: mongo
    volumes:
      - ./db:/data/db
    environment:
      MONGO_INITDB_ROOT_USERNAME: root
      MONGO_INITDB_ROOT_PASSWORD: password
  mongo-express:
    restart: always
    image: mongo-express
    environment:
      ME_CONFIG_BASICAUTH_USERNAME: user
      ME_CONFIG_BASICAUTH_PASSWORD: pass
      ME_CONFIG_MONGODB_ADMINUSERNAME: root
      ME_CONFIG_MONGODB_ADMINPASSWORD: password
      ME_CONFIG_REQUEST_SIZE: '1024m'
      ME_CONFIG_SITE_BASEURL: '/mongo/'
      ME_CONFIG_SITE_COOKIESECRET: secret1
      ME_CONFIG_SITE_SESSIONSECRET: secret2
  nginx:
    restart: always
    image: nginx
    ports:
      - '80:80'
    volumes:
      - ./songs:/usr/src/app/public/songs:ro
      - taiko_assets:/usr/src/app/public/assets:ro
      - taiko_src:/usr/src/app/public/src:ro
      - ./conf.d:/etc/nginx/conf.d:ro
  redis:
    restart: always
    image: redis:alpine
  taiko-web:
    restart: always
    image: nanahira/taiko-web
    volumes:
      - ./songs:/usr/src/app/public/songs
      - taiko_assets:/usr/src/app/public/assets
      - taiko_src:/usr/src/app/public/src
      - ./config.py:/usr/src/app/config.py:ro
    environment:
      TAIKO_VERSION: Version
    command: gunicorn --workers=2 -b 0.0.0.0:34801 app:app
  taiko-web-server:
    restart: always
    image: nanahira/taiko-web
    command: python server.py

```

`taiko-web-nginx.conf` mounted on `/etc/nginx/conf.d` (HTTP configuration. To use HTTPS, please refer to Nginx documentations and change lines on this file and `config.py`) :

```
gzip_vary on;
gzip_comp_level 6;
gzip_disable msie6;
gzip_proxied any;
gzip_types text/plain text/css text/javascript application/javascript application/json application/x-javascript text/xml application/xml application/xml+rss;

set_real_ip_from  172.16.0.0/12; # change here if necessary
real_ip_header    X-Forwarded-For;
real_ip_recursive on;

map $http_upgrade $connection_upgrade {
  default upgrade;
  '' close;
}

server {
  listen 80;
  server_name taiko.example.com;
  server_tokens off;

  location / {
    proxy_set_header X-Real-IP $remote_addr;
    proxy_set_header Host $host;
    proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
    proxy_set_header X-Forwarded-Proto http; # change to https here if necessary
    proxy_set_header Upgrade $http_upgrade;
    proxy_set_header Connection $connection_upgrade;
    proxy_read_timeout 7200s;
    proxy_max_temp_file_size 50000m;
    proxy_pass http://taiko-web:34801;
  }

  location ~ ^/(assets|songs|src)/ {
    root   /taiko-web/public;
    location ~ ^/songs/([0-9]+)/preview\.mp3$ {
      expires 30d;
      try_files $uri /api/preview?id=$1;
    }
    location ~ ^/songs/([0-9]+)/main\.(mp3|ogg)$ {
      expires max;
    }
    location ~ ^/songs/([0-9]+)/*\.(tja|osu)$ {
      add_header Cache-Control no-store;
      expires -1;
    }
    location ~ ^/src/ {
      expires 1h;
    }
  }

  location /p2 {
    proxy_set_header X-Real-IP $remote_addr;
    proxy_set_header Host $host;
    proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
    proxy_set_header X-Forwarded-Proto http; # change to https here if necessary
    proxy_set_header Upgrade $http_upgrade;
    proxy_set_header Connection $connection_upgrade;
    proxy_http_version 1.1;
    proxy_pass http://taiko-web-server:34802;
  }
  location /mongo {
    proxy_set_header X-Real-IP $remote_addr;
    proxy_set_header Host $host;
    proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
    proxy_set_header X-Forwarded-Proto http; # change to https here if necessary
    proxy_set_header Upgrade $http_upgrade;
    proxy_set_header Connection $connection_upgrade;
    proxy_pass http://mongo-express:8081;
  }
}
```

## Source

For legal reasons, the source of Taiko Web would be no longer provided on GitHub or other public Git platforms. But it's available inside this Docker image at `/usr/src/app` with the entire git history. Apology that this would make the repo become large.

Please use `docker cp` to grab the source from this image.
