#!/bin/bash
set -x
set -o errexit

SRC_PATH=$1
DST_PATH=$2 
SEQUENCE=$3

OLDIFS="$IFS"
IFS=$'\n'
for file in $(find "$SRC_PATH" -name '*.zip'); do
  DIR_NAME=$SEQUENCE
  DST_FULL_PATH="$DST_PATH/$DIR_NAME"
  mkdir -p "$DST_FULL_PATH"
  TMP_PATH=/tmp/_writer_workspace/$SEQUENCE
  mkdir -p $TMP_PATH
  echo "Extracting $file"
  7z x -o$TMP_PATH "$file"

  for zipFile in $(find "$TMP_PATH" -name "*.tja"); do
    mv "$zipFile" "$DST_FULL_PATH/main.tja"
  done
  
  for zipFile in $(find "$TMP_PATH" -name "*.ogg"); do
    mv "$zipFile" "$DST_FULL_PATH/main.ogg"
  done

  rm -rf "$TMP_PATH"
  SEQUENCE=$((SEQUENCE + 1))
done
IFS="$OLDIFS"
