#!/bin/bash
set -x
set -o errexit

SRC_PATH=$1
DST_PATH=$2
SEQUENCE=$3

OLDIFS="$IFS"
IFS=$'\n'
for file in $(find "$SRC_PATH" -name '*.tja' | sed "s/.tja//g"); do
  DIR_NAME=$SEQUENCE
  DST_FULL_PATH="$DST_PATH/$DIR_NAME"
  mkdir -p "$DST_FULL_PATH"
  cp -rf "$file.tja" $DST_FULL_PATH/main.tja
  cp -rf "$file.ogg" $DST_FULL_PATH/main.ogg
  SEQUENCE=$((SEQUENCE + 1))
done
IFS="$OLDIFS"
