// Generated by CoffeeScript 2.6.1
(function() {
  var Replay, ReplayReader, fs, lzma, replayHeader;

  lzma = require('lzma');

  fs = require('fs');

  replayHeader = (function() {
    // Deck = require './Deck.js'
    class replayHeader {
      constructor() {
        this.id = 0;
        this.version = 0;
        this.flag = 0;
        this.seed = 0;
        this.dataSizeRaw = [];
        this.hash = 0;
        this.props = [];
      }

      getDataSize() {
        return this.dataSizeRaw[0] + this.dataSizeRaw[1] * 0x100 + this.dataSizeRaw[2] * 0x10000 + this.dataSizeRaw[3] * 0x1000000;
      }

      getIsTag() {
        return this.flag & replayHeader.replayTagFlag > 0;
      }

      getIsCompressed() {
        return this.flag & replayHeader.replayCompressedFlag > 0;
      }

      getLzmaHeader() {
        var bytes;
        bytes = [].concat(this.props.slice(0, 5), this.dataSizeRaw, [0, 0, 0, 0]);
        return Buffer.from(bytes);
      }

    };

    replayHeader.replayCompressedFlag = 0x1;

    replayHeader.replayTagFlag = 0x2;

    replayHeader.replayDecodedFlag = 0x4;

    Object.defineProperty(replayHeader.prototype, 'dataSize', {
      get: replayHeader.getDataSize
    });

    Object.defineProperty(replayHeader.prototype, 'isTag', {
      get: replayHeader.getIsTag
    });

    Object.defineProperty(replayHeader.prototype, 'isCompressed', {
      get: replayHeader.getIsCompressed
    });

    return replayHeader;

  }).call(this);

  ReplayReader = class ReplayReader {
    constructor(buffer) {
      this.pointer = 0;
      this.buffer = buffer;
    }

    readByte() {
      var answer;
      answer = this.buffer.readUInt8(this.pointer);
      this.pointer += 1;
      return answer;
    }

    readByteArray(length) {
      var answer, i, j, ref;
      answer = [];
      for (i = j = 1, ref = length; (1 <= ref ? j <= ref : j >= ref); i = 1 <= ref ? ++j : --j) {
        answer.push(this.readByte());
      }
      return answer;
    }

    readInt8() {
      var answer;
      answer = this.buffer.readInt8(this.pointer);
      this.pointer += 1;
      return answer;
    }

    readUInt8() {
      var answer;
      answer = this.buffer.readUInt8(this.pointer);
      this.pointer += 1;
      return answer;
    }

    readInt16() {
      var answer;
      answer = this.buffer.readInt16LE(this.pointer);
      this.pointer += 2;
      return answer;
    }

    readInt32() {
      var answer;
      answer = this.buffer.readInt32LE(this.pointer);
      this.pointer += 4;
      return answer;
    }

    readAll() {
      var answer;
      answer = this.buffer.slice(this.pointer);
      // @pointer = 0
      return answer;
    }

    readString(length) {
      var answer, full;
      if (this.pointer + length > this.buffer.length) {
        return null;
      }
      full = this.buffer.slice(this.pointer, this.pointer + length).toString('utf-16le');
      answer = full.split("\u0000")[0];
      this.pointer += length;
      return answer;
    }

    readRaw(length) {
      var answer;
      if (this.pointer + length > this.buffer.length) {
        return null;
      }
      answer = this.buffer.slice(this.pointer, this.pointer + length);
      this.pointer += length;
      return answer;
    }

  };

  Replay = (function() {
    class Replay {
      constructor() {
        this.header = null;
        this.hostName = "";
        this.clientName = "";
        this.startLp = 0;
        this.startHand = 0;
        this.drawCount = 0;
        this.opt = 0;
        this.hostDeck = null;
        this.clientDeck = null;
        this.tagHostName = null;
        this.tagClientName = null;
        this.tagHostDeck = null;
        this.tagClientDeck = null;
        this.responses = null;
      }

      getDecks() {
        if (this.isTag) {
          return [this.hostDeck, this.clientDeck, this.tagHostDeck, this.tagClientDeck];
        } else {
          return [this.hostDeck, this.clientDeck];
        }
      }

      getIsTag() {
        var ref;
        return (ref = this.header === null) != null ? ref : {
          false: this.header.isTag
        };
      }

      static async fromFile(filePath) {
        return Replay.fromBuffer((await fs.promises.readFile(filePath)));
      }

      static fromBuffer(buffer) {
        var decompressed, header, lzmaBuffer, reader, replay, restBuffer;
        reader = new ReplayReader(buffer);
        header = Replay.readHeader(reader);
        restBuffer = reader.readAll();
        lzmaBuffer = Buffer.concat([header.getLzmaHeader(), restBuffer]);
        if (header.isCompressed) {
          decompressed = restBuffer;
        } else {
          decompressed = Buffer.from(lzma.decompress(lzmaBuffer));
        }
        reader = new ReplayReader(decompressed);
        replay = Replay.readReplay(header, reader);
        return replay;
      }

      static readHeader(reader) {
        var header;
        header = new replayHeader();
        header.id = reader.readInt32();
        header.version = reader.readInt32();
        header.flag = reader.readInt32();
        header.seed = reader.readInt32();
        header.dataSizeRaw = reader.readByteArray(4);
        header.hash = reader.readInt32();
        header.props = reader.readByteArray(8);
        return header;
      }

      static readReplay(header, reader) {
        var replay;
        replay = new Replay();
        replay.header = header;
        replay.hostName = reader.readString(40);
        if (header.isTag) {
          replay.tagHostName = reader.readString(40);
        }
        if (header.isTag) {
          replay.tagClientName = reader.readString(40);
        }
        replay.clientName = reader.readString(40);
        replay.startLp = reader.readInt32();
        replay.startHand = reader.readInt32();
        replay.drawCount = reader.readInt32();
        replay.opt = reader.readInt32();
        replay.hostDeck = Replay.readDeck(reader);
        if (header.isTag) {
          replay.tagHostDeck = Replay.readDeck(reader);
        }
        if (header.isTag) {
          replay.tagClientDeck = Replay.readDeck(reader);
        }
        replay.clientDeck = Replay.readDeck(reader);
        replay.responses = Replay.readResponses(reader);
        return replay;
      }

      static readDeck(reader) {
        var deck;
        deck = {};
        deck.main = Replay.readDeckPack(reader);
        deck.ex = Replay.readDeckPack(reader);
        return deck;
      }

      static readDeckPack(reader) {
        var answer, i, j, length, ref;
        length = reader.readInt32();
        answer = [];
        for (i = j = 1, ref = length; (1 <= ref ? j <= ref : j >= ref); i = 1 <= ref ? ++j : --j) {
          answer.push(reader.readInt32());
        }
        return answer;
      }

      static readResponses(reader) {
        var answer, length, single;
        answer = [];
        while (true) {
          try {
            length = reader.readUInt8();
            if (length > 64) {
              length = 64;
            }
            single = reader.readRaw(length);
            if (!single) {
              break;
            }
            answer.push(single);
          } catch (error) {
            break;
          }
        }
        return answer;
      }

    };

    Object.defineProperty(replayHeader.prototype, 'decks', {
      get: Replay.getDecks
    });

    Object.defineProperty(replayHeader.prototype, 'isTag', {
      get: Replay.getIsTag
    });

    return Replay;

  }).call(this);

  module.exports = Replay;

}).call(this);
