// Generated by CoffeeScript 1.6.3
(function() {
  var Struct, declaration, field, name, result, structs_declaration, type, typedefs, _i, _len;

  Struct = require('struct').Struct;

  structs_declaration = require('./structs.json');

  typedefs = require('./typedefs.json');

  this.proto_structs = require('./proto_structs.json');

  this.constants = require('./constants.json');

  this.structs = {};

  for (name in structs_declaration) {
    declaration = structs_declaration[name];
    result = Struct();
    for (_i = 0, _len = declaration.length; _i < _len; _i++) {
      field = declaration[_i];
      if (field.encoding) {
        switch (field.encoding) {
          case "UTF-16LE":
            result.chars(field.name, field.length * 2, field.encoding);
            break;
          default:
            throw "unsupported encoding: " + field.encoding;
        }
      } else {
        type = field.type;
        if (typedefs[type]) {
          type = typedefs[type];
        }
        if (field.length) {
          result.array(field.name, field.length, type);
        } else {
          if (this.structs[type]) {
            result.struct(field.name, this.structs[type]);
          } else {
            result[type](field.name);
          }
        }
      }
    }
    this.structs[name] = result;
  }

  this.stoc_follows = {};

  this.ctos_follows = {};

  this.stoc_follow = function(proto, synchronous, callback) {
    var key, value, _ref;
    if (typeof proto === 'string') {
      _ref = this.constants.STOC;
      for (key in _ref) {
        value = _ref[key];
        if (value === proto) {
          proto = key;
          break;
        }
      }
      if (!this.constants.STOC[proto]) {
        throw "unknown proto";
      }
    }
    return this.stoc_follows[proto] = {
      callback: callback,
      synchronous: synchronous
    };
  };

  this.ctos_follow = function(proto, synchronous, callback) {
    var key, value, _ref;
    if (typeof proto === 'string') {
      _ref = this.constants.CTOS;
      for (key in _ref) {
        value = _ref[key];
        if (value === proto) {
          proto = key;
          break;
        }
      }
      if (!this.constants.CTOS[proto]) {
        throw "unknown proto";
      }
    }
    return this.ctos_follows[proto] = {
      callback: callback,
      synchronous: synchronous
    };
  };

  this.stoc_send = function(socket, proto, info) {
    var buffer, header, key, struct, value, _ref;
    if (typeof info === 'undefined') {
      buffer = "";
    } else if (Buffer.isBuffer(info)) {
      buffer = info;
    } else {
      struct = this.structs[this.proto_structs.STOC[proto]];
      struct.allocate();
      struct.set(info);
      buffer = struct.buffer();
    }
    if (typeof proto === 'string') {
      _ref = this.constants.STOC;
      for (key in _ref) {
        value = _ref[key];
        if (value === proto) {
          proto = key;
          break;
        }
      }
      if (!this.constants.STOC[proto]) {
        throw "unknown proto";
      }
    }
    header = new Buffer(3);
    header.writeUInt16LE(buffer.length + 1, 0);
    header.writeUInt8(proto, 2);
    socket.write(header);
    if (buffer.length) {
      return socket.write(buffer);
    }
  };

  this.ctos_send = function(socket, proto, info) {
    var buffer, header, key, struct, value, _ref;
    if (typeof info === 'undefined') {
      buffer = "";
    } else if (Buffer.isBuffer(info)) {
      buffer = info;
    } else {
      struct = this.structs[this.proto_structs.CTOS[proto]];
      struct.allocate();
      struct.set(info);
      buffer = struct.buffer();
    }
    if (typeof proto === 'string') {
      _ref = this.constants.CTOS;
      for (key in _ref) {
        value = _ref[key];
        if (value === proto) {
          proto = key;
          break;
        }
      }
      if (!this.constants.CTOS[proto]) {
        throw "unknown proto";
      }
    }
    header = new Buffer(3);
    header.writeUInt16LE(buffer.length + 1, 0);
    header.writeUInt8(proto, 2);
    socket.write(header);
    if (buffer.length) {
      return socket.write(buffer);
    }
  };

  this.stoc_send_chat = function(client, msg, player) {
    if (player == null) {
      player = 8;
    }
    return this.stoc_send(client, 'CHAT', {
      player: player,
      msg: msg
    });
  };

}).call(this);

/*
//@ sourceMappingURL=ygopro.map
*/
