// Generated by CoffeeScript 1.6.3
(function() {
  var Inotify, Room, debug, dialogues, fs, http, inotify, net, path, request, settings, tips, url, ygopro, _;

  net = require('net');

  http = require('http');

  url = require('url');

  path = require('path');

  fs = require('fs');

  _ = require('underscore');

  _.str = require('underscore.string');

  _.mixin(_.str.exports());

  Inotify = require('inotify').Inotify;

  request = require('request');

  ygopro = require('./ygopro.js');

  Room = require('./room.js');

  settings = require('./config.json');

  debug = false;

  if (process.argv[2] === '--debug') {
    settings.port++;
    settings.http_port++;
  }

  net.createServer(function(client) {
    var ctos_buffer, ctos_message_length, ctos_proto, server, stoc_buffer, stoc_message_length, stoc_proto;
    server = new net.Socket();
    client.server = server;
    client.on('close', function(had_error) {
      console.log("client closed " + had_error);
      if (!client.closed) {
        if (client.room) {
          client.room.disconnect(client);
        }
        client.closed = true;
      }
      return server.end();
    });
    client.on('error', function(error) {
      console.log("client error " + error);
      if (!client.closed) {
        if (client.room) {
          client.room.disconnect(client, error);
        }
        client.closed = error;
      }
      return server.end();
    });
    server.on('close', function(had_error) {
      console.log("server closed " + had_error);
      if (!server.closed) {
        server.closed = true;
      }
      if (!client.closed) {
        ygopro.stoc_send_chat(client, "服务器关闭了连接");
        client.closed = true;
        return client.end();
      }
    });
    server.on('error', function(error) {
      console.log("server error " + error);
      server.closed = error;
      if (!client.closed) {
        ygopro.stoc_send_chat(client, "服务器错误: " + error);
        client.closed = true;
        return client.end();
      }
    });
    ctos_buffer = new Buffer(0);
    ctos_message_length = 0;
    ctos_proto = 0;
    client.pre_establish_buffers = new Array();
    client.on('data', function(data) {
      var b, struct;
      ctos_buffer = Buffer.concat([ctos_buffer, data], ctos_buffer.length + data.length);
      while (true) {
        if (ctos_message_length === 0) {
          if (ctos_buffer.length >= 2) {
            ctos_message_length = ctos_buffer.readUInt16LE(0);
          } else {
            break;
          }
        } else if (ctos_proto === 0) {
          if (ctos_buffer.length >= 3) {
            ctos_proto = ctos_buffer.readUInt8(2);
          } else {
            break;
          }
        } else {
          if (ctos_buffer.length >= 2 + ctos_message_length) {
            if (ygopro.ctos_follows[ctos_proto]) {
              b = ctos_buffer.slice(3, ctos_message_length - 1 + 3);
              if (struct = ygopro.structs[ygopro.proto_structs.CTOS[ygopro.constants.CTOS[ctos_proto]]]) {
                struct._setBuff(b);
                setTimeout(ygopro.ctos_follows[ctos_proto].callback, 0, b, _.clone(struct.fields), client, server);
              } else {
                setTimeout(ygopro.ctos_follows[ctos_proto].callback, 0, b, null, client, server);
              }
            }
            ctos_buffer = ctos_buffer.slice(2 + ctos_message_length);
            ctos_message_length = 0;
            ctos_proto = 0;
          } else {
            break;
          }
        }
      }
      if (!(ygopro.ctos_follows[ctos_proto] && ygopro.ctos_follows[ctos_proto].synchronous)) {
        if (client.established) {
          return server.write(data);
        } else {
          return client.pre_establish_buffers.push(data);
        }
      }
    });
    stoc_buffer = new Buffer(0);
    stoc_message_length = 0;
    stoc_proto = 0;
    return server.on('data', function(data) {
      var b, struct;
      stoc_buffer = Buffer.concat([stoc_buffer, data], stoc_buffer.length + data.length);
      while (true) {
        if (stoc_message_length === 0) {
          if (stoc_buffer.length >= 2) {
            stoc_message_length = stoc_buffer.readUInt16LE(0);
          } else {
            break;
          }
        } else if (stoc_proto === 0) {
          if (stoc_buffer.length >= 3) {
            stoc_proto = stoc_buffer.readUInt8(2);
          } else {
            break;
          }
        } else {
          if (stoc_buffer.length >= 2 + stoc_message_length) {
            if (ygopro.stoc_follows[stoc_proto]) {
              b = stoc_buffer.slice(3, stoc_message_length - 1 + 3);
              if (struct = ygopro.structs[ygopro.proto_structs.STOC[ygopro.constants.STOC[stoc_proto]]]) {
                struct._setBuff(b);
                setImmediate(ygopro.stoc_follows[stoc_proto].callback, b, _.clone(struct.fields), client, server);
              } else {
                setImmediate(ygopro.stoc_follows[stoc_proto].callback, b, null, client, server);
              }
            }
            stoc_buffer = stoc_buffer.slice(2 + stoc_message_length);
            stoc_message_length = 0;
            stoc_proto = 0;
          } else {
            break;
          }
        }
      }
      return client.write(data);
    });
  }).listen(settings.port, function() {
    return console.log("server started on " + settings.ip + ":" + settings.port);
  });

  ygopro.ctos_follow('PLAYER_INFO', true, function(buffer, info, client, server) {
    return client.name = info.name;
  });

  ygopro.ctos_follow('JOIN_GAME', false, function(buffer, info, client, server) {
    if (info.version !== settings.version) {
      ygopro.stoc_send(client, 'ERROR_MSG', {
        msg: 4,
        code: settings.version
      });
      return client.end();
    } else if (!info.pass.length) {
      ygopro.stoc_send_chat(client, "房间为空，请修改房间名");
      ygopro.stoc_send(client, 'ERROR_MSG', {
        msg: 1,
        code: 2
      });
      return client.end();
    } else if (info.pass === '[INCORRECT]') {
      ygopro.stoc_send(client, 'ERROR_MSG', {
        msg: 1,
        code: 1
      });
      return client.end();
    } else if (client.name === '[INCORRECT]') {
      ygopro.stoc_send(client, 'ERROR_MSG', {
        msg: 1,
        code: 2
      });
      return client.end();
    } else {
      client.room = Room.find_or_create_by_name(info.pass);
      return client.room.connect(client);
    }
  });

  ygopro.stoc_follow('JOIN_GAME', false, function(buffer, info, client, server) {
    ygopro.stoc_send(client, 'CHAT', {
      player: 8,
      msg: "Mycard Debugging Server"
    });
    return ygopro.stoc_send(client, 'CHAT', {
      player: 8,
      msg: "这里是测试中的新服务器, 还不稳定, 随时可能崩溃, 遇到意外请淡定\n                           ˉˉˉˉˉ"
    });
  });

  dialogues = {};

  request({
    url: 'https://my-card.in/dialogues.json',
    json: true
  }, function(error, response, body) {
    if (_.isString(body)) {
      return console.log("[WARN]dialogues bad json " + body);
    } else {
      console.log("loaded " + (_.size(body)) + " dialogues");
      return dialogues = body;
    }
  });

  ygopro.stoc_follow('GAME_MSG', false, function(buffer, info, client, server) {
    var card, line, msg, _i, _len, _ref, _results;
    msg = buffer.readInt8(0);
    if (ygopro.constants.MSG[msg] === 'SUMMONING' || ygopro.constants.MSG[msg] === 'SPSUMMONING') {
      card = buffer.readUInt32LE(1);
      if (dialogues[card]) {
        _ref = _.lines(dialogues[card][Math.floor(Math.random() * dialogues[card].length)]);
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          line = _ref[_i];
          _results.push(ygopro.stoc_send_chat(client, line));
        }
        return _results;
      }
    }
  });

  /*
    if ygopro.constants.MSG[msg] == 'WIN'
      room = Room.find_by_client(client)
      if !room
        console.log "[WARN]win: can't find room by player #{client.player}"
        return
      if _.startsWith(room.name, 'M#') and room.dueling
        room.dueling = false
  
        loser_name = room.pos_name[buffer.readUInt8(1)]
        winner_name = room.pos_name[1 - buffer.readUInt8(1)]
        #type = buffer.readUInt8(2)
        User.findOne { name: winner_name }, (err, winner)->
          if(err)
            console.log "#{err} when finding user #{winner_name}"
          else if(!winner)
            console.log "user #{winner_name} not exist"
          else
            User.findOne { name: loser_name }, (err, loser)->
              if(err)
                console.log "#{err} when finding user #{loser_name}"
              else if(!loser)
                console.log "user #{loser_name} not exist"
              else
                winner.points += 10
                loser.points -= 5
                winner.save()
                loser.save()
                console.log "#{winner} 增加10点积分，现在有#{winner.points}点"
                console.log "#{loser} 减少5点积分，现在有#{loser.points}点"
  
  
  #mongoose = require 'mongoose'
  #mongoose.connect('mongodb://localhost/mycard');
  #User = mongoose.model 'User',
  #  name: String
  #  points: Number
  
  #ygopro.stoc_follow 'HS_PLAYER_CHANGE', false, (buffer, info, client, server)->
  #  console.log 'HS_PLAYER_CHANGE', info
  */


  ygopro.stoc_follow('HS_PLAYER_ENTER', false, function(buffer, info, client, server) {
    return console.log("PLAYER_ENTER to " + client.name + ": " + info.name + ", " + info.pos);
  });

  ygopro.stoc_follow('HS_PLAYER_CHANGE', false, function(buffer, info, client, server) {
    return console.log("PLAYER_CHANGE to " + client.name + ": " + (info.status & 0xF !== 0) + ", " + (info.status >> 4));
  });

  ygopro.stoc_follow('TYPE_CHANGE', false, function(buffer, info, client, server) {
    var is_host, selftype;
    selftype = info.type & 0xf;
    is_host = ((info.type >> 4) & 0xf) !== 0;
    client.is_host = is_host;
    client.pos = selftype;
    return console.log("TYPE_CHANGE to " + client.name + ":", info, selftype, is_host);
  });

  http.createServer(function(request, response) {
    var player, room;
    url = url.parse(request.url);
    if (url.pathname === '/count.json') {
      response.writeHead(200);
      response.end(Room.all.length.toString());
    } else if (url.pathname === '/rooms.json') {
      response.writeHead(404);
      response.end();
    }
    if (url.query === 'operation=getroomjson') {
      response.writeHead(200);
      return response.end(JSON.stringify({
        rooms: (function() {
          var _i, _len, _ref, _results;
          _ref = Room.all;
          _results = [];
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            room = _ref[_i];
            _results.push({
              roomid: room.port.toString(),
              roomname: room.name,
              needpass: false.toString(),
              users: (function() {
                var _j, _len1, _ref1, _results1;
                _ref1 = room.players;
                _results1 = [];
                for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
                  player = _ref1[_j];
                  _results1.push({
                    id: (-1).toString(),
                    name: player.name,
                    pos: player.pos
                  });
                }
                return _results1;
              })(),
              istart: "wait"
            });
          }
          return _results;
        })()
      }));
    } else {
      response.writeHead(404);
      return response.end();
    }
  }).listen(settings.http_port);

  inotify = new Inotify();

  inotify.addWatch({
    path: 'ygocore/replay',
    watch_for: Inotify.IN_CLOSE_WRITE | Inotify.IN_CREATE | Inotify.IN_MODIFY,
    callback: function(event) {
      var mask, port, room;
      mask = event.mask;
      if (event.name) {
        port = parseInt(path.basename(event.name, '.yrp'));
        room = Room.find_by_port(port);
        if (room) {
          if (mask & Inotify.IN_CREATE) {

          } else if (mask & Inotify.IN_CLOSE_WRITE) {
            return fs.unlink(path.join('ygocore/replay'), function(err) {});
          } else if (mask & Inotify.IN_MODIFY) {
            return room.alive = true;
          }
        }
      } else {
        return console.log('[warn] event without filename');
      }
    }
  });

  setInterval(function() {
    var player, room, _i, _j, _len, _len1, _ref, _ref1, _results;
    _ref = Room.all;
    _results = [];
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      room = _ref[_i];
      if (room.alive) {
        _results.push(room.alive = false);
      } else {
        console.log("kill room " + room.port);
        _ref1 = room.players;
        for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
          player = _ref1[_j];
          if (!player.closed) {
            ygopro.stoc_send_chat(player, "由于长时间没有活动被关闭");
          }
        }
        _results.push(room.process.kill());
      }
    }
    return _results;
  }, 900000);

  ygopro.stoc_send_tip = function(client, tip) {
    var line, lines, _i, _len, _ref, _results;
    lines = _.lines(tip);
    ygopro.stoc_send_chat(client, "Tip: " + lines[0]);
    _ref = lines.slice(1);
    _results = [];
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      line = _ref[_i];
      _results.push(ygopro.stoc_send_chat(client, line));
    }
    return _results;
  };

  ygopro.stoc_send_random_tip = function(client) {
    if (tips) {
      return ygopro.stoc_send_tip(client, tips[Math.floor(Math.random() * tips.length)]);
    }
  };

  tips = null;

  request({
    url: 'https://my-card.in/tips.json',
    json: true
  }, function(error, response, body) {
    tips = body;
    return console.log("loaded " + tips.length + " tips");
  });

  ygopro.stoc_follow('DUEL_START', false, function(buffer, info, client, server) {
    return ygopro.stoc_send_random_tip(client);
    /*
    room = Room.find_by_client(client)
    if !room
      console.log "[WARN]duel start: can't find room by player #{client.player}"
      return
    
    room.dueling = true
    if _.startsWith(room.name, 'M#')
      User.findOne { name: client.player }, (err, user)->
        if !user
          user = new User({name: client.player, points: 0})
          user.save()
        ygopro.stoc_send_chat(client, "积分系统测试中，你现在有#{user.points}点积分，这些积分以后可能会重置")
    */

  });

  ygopro.ctos_follow('CHAT', false, function(buffer, info, client, server) {
    if (_.trim(info.msg) === '/tip') {
      return ygopro.stoc_send_random_tip(client);
    }
  });

  /*
  # 开包大战
  
  packs_weighted_cards = {}
  for pack, cards of require './packs.json'
    packs_weighted_cards[pack] = []
    for card in cards
      for i in [0..card.count]
        packs_weighted_cards[pack].push card.card
  
  console.log packs_weighted_cards
  
  ygopro.ctos_follow 'UPDATE_DECK', false, (buffer, info, client, server)->
    ygopro.ctos_send server, 'HS_NOTREADY'
  
    deck = []
    for pack in client.player
      for i in [0...5]
        deck.push packs_weighted_cards[pack][Math.floor(Math.random()*packs_weighted_cards[pack].length)]
  
  
    ygopro.ctos_send server, 'UPDATE_DECK', {
      mainc: deck.length,
      sidec: 0,
      deckbuf: deck
    }
    ygopro.ctos_send server, 'HS_READY'
  */


}).call(this);
