// Generated by CoffeeScript 1.6.3
(function() {
  var Room, spawn, ygopro, _;

  _ = require('underscore');

  _.str = require('underscore.string');

  _.mixin(_.str.exports());

  spawn = require('child_process').spawn;

  ygopro = require('./ygopro.js');

  Room = (function() {
    Room.all = [];

    Room.find_or_create_by_name = function(name) {
      var result, _ref;
      return result = (_ref = this.find_by_name(name)) != null ? _ref : new Room(name);
    };

    Room.find_by_name = function(name) {
      return _.find(this.all, function(room) {
        return room.name === name;
      });
    };

    Room.find_by_port = function(port) {
      return _.find(this.all, function(room) {
        return room.port === port;
      });
    };

    function Room(name) {
      var param,
        _this = this;
      this.name = name;
      this.alive = true;
      this.players = [];
      this.status = 'starting';
      Room.all.push(this);
      if (name.slice(0, 2) === 'M#') {
        param = [0, 0, 0, 1, 'F', 'F', 'F', 8000, 5, 1];
      } else if (name.slice(0, 2) === 'T#') {
        param = [0, 0, 0, 2, 'F', 'F', 'F', 8000, 5, 1];
      } else if ((param = name.match(/^(\d)(\d)(T|F)(T|F)(T|F)(\d+),(\d+),(\d+)/i))) {
        param.shift();
        param.unshift(0, 0);
      } else {
        param = [0, 0, 0, 0, 'F', 'F', 'F', 8000, 5, 1];
      }
      this.process = spawn('./ygopro', param, {
        cwd: 'ygocore'
      });
      this.process.on('exit', function(code) {
        console.log("room process " + _this.port + " exited with code " + code);
        return _this["delete"]();
      });
      this.process.stdout.setEncoding('utf8');
      this.process.stdout.once('data', function(data) {
        _this.established = true;
        _this.port = parseInt(data);
        return _.each(_this.players, function(player) {
          return player.server.connect(_this.port, '127.0.0.1', function() {
            var buffer, _i, _len, _ref;
            _ref = player.pre_establish_buffers;
            for (_i = 0, _len = _ref.length; _i < _len; _i++) {
              buffer = _ref[_i];
              player.server.write(buffer);
            }
            return player.established = true;
          });
        });
      });
    }

    Room.prototype["delete"] = function(room) {
      return Room.all.splice(_.indexOf(Room.all, room), 1);
    };

    Room.prototype.toString = function() {
      var player, _ref, _ref1;
      return "room: " + this.name + " " + this.port + " " + ((_ref = this.alive) != null ? _ref : {
        'alive': 'not-alive'
      }) + " " + ((_ref1 = this.dueling) != null ? _ref1 : {
        'dueling': 'not-dueling'
      }) + " [" + ((function() {
        var _i, _len, _ref2, _results;
        _ref2 = this.players;
        _results = [];
        for (_i = 0, _len = _ref2.length; _i < _len; _i++) {
          player = _ref2[_i];
          _results.push("client " + (typeof player.client) + " server " + (typeof player.server) + " " + player.name + " " + player.pos + ". ");
        }
        return _results;
      }).call(this)) + "] " + (JSON.stringify(this.pos_name));
    };

    Room.prototype.connect = function(client) {
      this.players.push(client);
      if (this.established) {
        return client.server.connect(this.port, '127.0.0.1', function() {
          var buffer, _i, _len, _ref;
          _ref = client.pre_establish_buffers;
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            buffer = _ref[_i];
            client.server.write(buffer);
          }
          return client.established = true;
        });
      }
    };

    Room.prototype.disconnect = function(client, error) {
      var player, _i, _len, _ref, _results;
      this.players = _.reject(this.players, function(player) {
        return player === client;
      });
      _ref = this.players;
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        player = _ref[_i];
        _results.push(ygopro.stoc_send_chat(player, "" + client.name + " 离开了游戏" + (error ? ": " + error : '')));
      }
      return _results;
    };

    return Room;

  })();

  module.exports = Room;

}).call(this);

/*
//@ sourceMappingURL=room.map
*/
