import sys
from flask import Flask, Response
from flask_cors import CORS
from requests_oauthlib import OAuth1Session, OAuth2Session
import os
import time
import json
from get_graphql_endpoint import endpoint
import threading
import random
import redis

redisClient = None

if os.getenv('REDIS_HOST'):
    redisPool = redis.ConnectionPool(
        host= os.getenv('REDIS_HOST'), 
        port= os.getenv('REDIS_PORT', 6379),
        password= os.getenv('REDIS_PASSWORD', None),
        db = os.getenv('REDIS_DB', 0)
    )
    redisClient = redis.Redis(connection_pool=redisPool)

app = Flask(__name__)
CORS(app)

twitterKeys = [
    'AAAAAAAAAAAAAAAAAAAAANRILgAAAAAAnNwIzUejRCOuH5E6I8xnZz4puTs%3D1Zv7ttfk8LF81IUq16cHjhLTvJu4FA33AGWWjCpTnA',
    'AAAAAAAAAAAAAAAAAAAAAFXzAwAAAAAAMHCxpeSDG1gLNLghVe8d74hl6k4%3DRUMF4xAQLsbeBhTSRrCiQpJtxoGWeyHrDb5te2jpGskWDFW82F',
    'AAAAAAAAAAAAAAAAAAAAAAj4AQAAAAAAPraK64zCZ9CSzdLesbE7LB%2Bw4uE%3DVJQREvQNCZJNiz3rHO7lOXlkVOQkzzdsgu6wWgcazdMUaGoUGm',
]
privateKey = os.getenv('TWITTER_AUTH_KEY')
if privateKey:
    twitterKeys = privateKey.split(" ")

cookies = [os.getenv('COOKIE')]

cookie_file = os.getenv('COOKIE_FILE')
if cookie_file:
    with open(cookie_file, 'r') as f:
        cookies = str.strip(f.read()).split("\n")

# print("Booting")
ENDPOINT = {
    "UserTweetsAndReplies": "CwLU7qTfeu0doqhSr6tW4A",
    "TweetDetail": "BoHLKeBvibdYDiJON1oqTg",
}
# print("Booted")

FeaturesDict = {
    "responsive_web_uc_gql_enabled": False, 
    "dont_mention_me_view_api_enabled": False,
    "interactive_text_enabled": False,
    "responsive_web_edit_tweet_api_enabled": False,
    "standardized_nudges_for_misinfo_nudges_enabled": False,
    "vibe_tweet_context_enabled": False,
    "standardized_nudges_misinfo": False,
    "responsive_web_enhance_cards_enabled": False,
    "vibe_api_enabled": False,
    "tweet_with_visibility_results_prefer_gql_limited_actions_policy_enabled": False,
    "responsive_web_text_conversations_enabled": False,
    "unified_cards_ad_metadata_container_dynamic_card_content_query_enabled": False,
    "graphql_is_translatable_rweb_tweet_is_translatable_enabled": False,
    "responsive_web_graphql_timeline_navigation_enabled": False,
    "tweetypie_unmention_optimization_enabled": False,
    "verified_phone_label_enabled": False,
    "responsive_web_twitter_blue_verified_badge_is_enabled": False,
    "view_counts_public_visibility_enabled": False,
    "view_counts_everywhere_api_enabled": False,
    "longform_notetweets_consumption_enabled": False,
}
FeaturesJson = json.dumps(FeaturesDict)

healthLock = threading.Lock()
isHealthy = True

def getTwitterSession(specifyCookie = None):
    twitter_b = OAuth2Session()
    twitter_b.headers["Authorization"] = "Bearer {}".format(random.choice(twitterKeys))
    twitter_b.headers['user-agent'] = "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36"
    cookie = ''
    if specifyCookie is not None:
        cookie = specifyCookie
    else:
        cookie = random.choice(cookies)
    if cookie: # and useCookie:
        twitter_b.headers['cookie'] = cookie
        twitter_b.headers['x-csrf-token'] = cookie.split("ct0=")[1].split(";")[0]
    return twitter_b

def doSearch(screen_name):
    global isHealthy
    twitter_b = getTwitterSession()
    searchurl_v2 = "https://x.com/i/api/graphql/nK1dw4oV3k4w5TdtcAdSww/SearchTimeline"
    params_v2 = {
        "features": json.dumps({
            "rweb_lists_timeline_redesign_enabled": True,
            "responsive_web_graphql_exclude_directive_enabled": True,
            "verified_phone_label_enabled": False,
            "creator_subscriptions_tweet_preview_api_enabled": True,
            "responsive_web_graphql_timeline_navigation_enabled": True,
            "responsive_web_graphql_skip_user_profile_image_extensions_enabled": False,
            "tweetypie_unmention_optimization_enabled": True,
            "responsive_web_edit_tweet_api_enabled": True,
            "graphql_is_translatable_rweb_tweet_is_translatable_enabled": True,
            "view_counts_everywhere_api_enabled": True,
            "longform_notetweets_consumption_enabled": True,
            "responsive_web_twitter_article_tweet_consumption_enabled": False,
            "tweet_awards_web_tipping_enabled": False,
            "freedom_of_speech_not_reach_fetch_enabled": True,
            "standardized_nudges_misinfo": True,
            "tweet_with_visibility_results_prefer_gql_limited_actions_policy_enabled": True,
            "longform_notetweets_rich_text_read_enabled": True,
            "longform_notetweets_inline_media_enabled": True,
            "responsive_web_media_download_video_enabled": False,
            "responsive_web_enhance_cards_enabled": False
        }),
        "variables": json.dumps({
            "count": 20,
            "querySource": "typed_query",
            "product": "Latest",
            "rawQuery": "from:@" + screen_name,
        }),
        "fieldToggles": json.dumps({
            "withArticleRichContentState": False
        })

    }
    response = twitter_b.get(searchurl_v2, params=params_v2)
    #print("Search: " + response.text)
    search_v2 = response.json()
    isHealthy = 'data' in search_v2
    if isHealthy:
        return search_v2["data"]["search_by_raw_query"]["search_timeline"]["timeline"]["instructions"]
    else:
        print("Search error: " + response.text)
        return None

@app.route('/_healthy')
def healthy():
    return {"healthy": True}
    #result = None
    #if isHealthy:
    #    return {'healthy': True}
    #with healthLock:
    #    if isHealthy:
    #        return {'healthy': True}
    #    doSearch('Dream', getTwitterSession())
    #    if isHealthy:
    #        print("Rate limit passed.")
    #        return {'healthy': True}
    #    return Response(status=500)
    #return result

def checkCookies():
    good = []
    bad = []
    for cookie in cookies:
        print("Checking cookie: " + cookie, file=sys.stderr)
        twitter_b = getTwitterSession(cookie)
        response = twitter_b.get("https://api.twitter.com/1.1/guest/activate.json")
        if response.status_code == 200:
            return True
        
        usertlurl = 'https://x.com/i/api/graphql/oUZZZ8Oddwxs8Cd3iW3UEA/UserByScreenName'
        screen_name = 'Sena_n_Karin'
        params = {
            'variables': json.dumps({
                'screen_name': screen_name,
                'withSafetyModeUserFields': True,
            }),
            'features': json.dumps({
                "hidden_profile_likes_enabled": False,
                "responsive_web_graphql_exclude_directive_enabled": True,
                "verified_phone_label_enabled": False,
                "subscriptions_verification_info_verified_since_enabled": True,
                "highlights_tweets_tab_ui_enabled": True,
                "creator_subscriptions_tweet_preview_api_enabled": True,
                "responsive_web_graphql_skip_user_profile_image_extensions_enabled": False,
                "responsive_web_graphql_timeline_navigation_enabled": True
            })
        }

        usertl_b = twitter_b.get(usertlurl, params=params)
        usertl = usertl_b
        usertl_json = usertl.json()
        possibleErrors = [
            'Could not authenticate you',
            'Authorization: Denied by access control: To protect our users from spam and other malicious activity, this account is temporarily locked. Please log in to https://twitter.com to unlock your account.'
        ]
        matchError = False
        if "errors" in usertl_json:
            for error in possibleErrors:
                for e in usertl_json["errors"]:
                    if e['message'].startswith(error):
                        matchError = True
                        break
                if matchError:
                    break
        if usertl.status_code == 200 or not matchError:
            print(f"Good cookie {usertl.status_code}: " + cookie + " " + usertl.text, file=sys.stderr)
            good.append(cookie)
        else:
            print(f"Bad cookie {usertl.status_code}: " + cookie + " " + usertl.text, file=sys.stderr)
            bad.append(cookie)
    return good, bad

    

@app.route("/<screen_name>")
def searchban(screen_name):
    if redisClient:
        cached = redisClient.get('shadowban:{}'.format(screen_name))
        if cached:
            print('Using cached result for {}: {}'.format(screen_name, cached))
            cachedDict = json.loads(cached)
            return cachedDict

    print("Checking {}".format(screen_name))
    returnjson = {
                "timestamp": time.time(),
                "profile": {
                    # "id": "7080152",
                    # "screenName": "TwitterJP",
                    # "protected": False,
                    # "suspended": False,
                    # "has_tweets": True,
                    "exists": False,
                    "error": None,
                    "screen_name": screen_name,
                },
                # "check": {
                #     "search": 1484727214419628037,
                #     "suggest": True,
                #     "ghost": {"ban": True},
                #     "reply": {"ban": False, "tweet": "1480819689898987523", "in_reply_to": "1369626114381901828"}
                # }
            }

    
    # twitter = OAuth1Session(TWITTER_IPHONE_CK, TWITTER_IPHONE_CS)
    twitter_b = getTwitterSession()

    # check rate limit
    # response = twitter_b.get("https://api.twitter.com/1.1/application/rate_limit_status.json")
    # print(response.json())

    # profile_url = "https://api.twitter.com/1.1/users/show.json"
    # params = {"screen_name": screen_name}
    # profile_info = twitter_b.get(profile_url, params=params)
    # profile_json = profile_info.json()
    # print(profile_json)
    # if profile_info.status_code == 200:
    #     returnjson["profile"]["exists"] = True
    #     returnjson["profile"]["id"] = profile_json["id_str"]
    #     returnjson["profile"]["screenName"] = profile_json["screen_name"]
    #     returnjson["profile"]["protected"] = profile_json["protected"]
    # elif profile_info.status_code == 403:
    #     returnjson["profile"]["suspended"] = True
    #     return returnjson
    # else:
    #     returnjson["profile"]["error"] = profile_json["errors"][0]["message"]
    #     # return returnjson

    # if profile_json["protected"] == True:
    #     returnjson["profile"]["protected"] = True
    #     return returnjson

    # if profile_json["statuses_count"] == 0:
    #     returnjson["profile"]["has_tweets"] = False
    #     return returnjson
    # else:
    #     returnjson["profile"]["has_tweets"] = True

    # check whether the user has any tweets
    #usertlurl = "https://api.twitter.com/1.1/statuses/user_timeline.json"
    #params = {"screen_name": screen_name, "count": 200}
    usertlurl = 'https://x.com/i/api/graphql/oUZZZ8Oddwxs8Cd3iW3UEA/UserByScreenName'
    params = {
        'variables': json.dumps({
            'screen_name': screen_name,
            'withSafetyModeUserFields': True,
        }),
        'features': json.dumps({
            "hidden_profile_likes_enabled": False,
            "responsive_web_graphql_exclude_directive_enabled": True,
            "verified_phone_label_enabled": False,
            "subscriptions_verification_info_verified_since_enabled": True,
            "highlights_tweets_tab_ui_enabled": True,
            "creator_subscriptions_tweet_preview_api_enabled": True,
            "responsive_web_graphql_skip_user_profile_image_extensions_enabled": False,
            "responsive_web_graphql_timeline_navigation_enabled": True
        })
    }

    usertl_b = twitter_b.get(usertlurl, params=params)
    usertl = usertl_b
    usertl_json = usertl.json()
    print(usertl_json)
    # if "errors" in usertlb:
    #     return "An error occurred" # TODO: Better error handling
    # if len(usertlb) == 0:
    #     return "No tweets found"  # TODO: Better error handling

    if 'errors' in usertl_json:
        returnjson["profile"]["error"] = usertl_json["errors"][0]['message']
        return returnjson
    if len(usertl_json) == 0 or 'user' not in usertl_json['data']:
        returnjson["profile"]["has_tweets"] = False
        return returnjson

    returnjson["profile"]["has_tweets"] = True

    if usertl.status_code == 200:
        returnjson["profile"]["exists"] = True
        returnjson["profile"]["id"] = usertl_json['data']["user"]["result"]["rest_id"]
        returnjson["profile"]["screen_name"] = usertl_json['data']["user"]["result"]["legacy"]["screen_name"]
        # returnjson["profile"]["protected"] = usertl_json["protected"]
    elif usertl.status_code == 403:
        returnjson["profile"]["suspended"] = True
        return returnjson
    else:
        print("Profile error: " + usertl.text)
        if "error" in usertl_json and usertl_json["error"] == "Not authorized.":
            returnjson["profile"]["protected"] = True
            returnjson["profile"]["suspended"] = True
            returnjson["profile"]["has_tweets"] = False
            return returnjson
        returnjson["profile"]["error"] = usertl_json
        return returnjson

    # if usertl_json["protected"] == True:
    #     returnjson["profile"]["protected"] = True  ## how do you determen protected and suspended
    #     return returnjson

    # if usertl_json["statuses_count"] == 0:
    #     returnjson["profile"]["has_tweets"] = False
    #     return returnjson
    # else:
    #     returnjson["profile"]["has_tweets"] = True

    returnjson["tests"] = {
        "search": True,    ## Search ban
        "typeahead": True, ## suggest ban
        "ghost": {"ban": None},
        "more_replies": {"ban": False, "tweet": "-1", "in_reply_to": "-1"}
    }
    hasFailure = False

    # searchurl = "https://api.twitter.com/1.1/users/search.json"
    # params = {"q": "from:@{}".format(screen_name), "count": 1}
    # search = twitter_b.get(searchurl, params=params).json()
    # print(search)
    # if len(search) == 0:
    #     returnjson["test"]["search"] = "ban"
    #     return returnjson
    # else:
    #     return returnjson

    print("Checking search suggestion banned of {}".format(screen_name))
    suggestions = twitter_b.get("https://x.com/i/api/1.1/search/typeahead.json?include_ext_is_blue_verified=1&include_ext_verified_type=1&include_ext_profile_image_shape=1&src=search_box&result_type=users&q=@" + screen_name).json()
    print("Suggestions: " + str(suggestions))
    try:
        returnjson["tests"]["typeahead"] = len([1 for user in suggestions["users"] if user["screen_name"].lower() == screen_name.lower()]) > 0
    except:
        hasFailure = True
        print("Error checking typeahead of {}".format(screen_name))
        returnjson["tests"]["typeahead"] = '_error'

    if returnjson["tests"]["typeahead"] == False:
        print("{} is search suggestion banned, checking search ban.".format(screen_name))
        search_result = doSearch(screen_name)
        if search_result is None:
            returnjson["tests"]["search"] = '_error'
            hasFailure = True
        else:
            found_id = None
            for item in search_result:
                if item['type'] != 'TimelineAddEntries':
                    continue
                for entry_item in item['entries']:
                    if not entry_item['entryId'].startswith('tweet-'):
                        continue
                    found_id = entry_item['content']['itemContent']['tweet_results']['result']['rest_id']
                    break
                if found_id:
                    break
            if found_id:
                returnjson["tests"]["search"] = found_id
                print("{} is not search banned: {}".format(screen_name, found_id))
            else:
                returnjson["tests"]["search"] = False
                print("{} is search banned.".format(screen_name))
        #elif search_tweets == {}:
        #    returnjson["tests"]["search"] = False
        #    print("{} is search banned.".format(screen_name))
        #    # returnjson["tests"]["typeahead"] = False
        #else:
        #    returnjson["tests"]["search"] = str(search_tweets[list(search_tweets.keys())[0]]["id"])
        #    print("{} is not search banned.".format(screen_name))
    else:
        returnjson["tests"]["search"] = "_implied_good"
        print("{} is not search suggestion banned, skipped search ban check.".format(screen_name))

    ## get replies
    ## Start GraphQL

    guest_session = twitter_b.post("https://api.twitter.com/1.1/guest/activate.json")

    twitter_b.headers["x-guest-token"] = guest_session.json()["guest_token"]

    user_id = returnjson["profile"]["id"]

    reply = None

    print("User ID of {}: {}".format(screen_name, user_id))

    get_reply_vars = { 
       "count": 200, "userId": user_id,
            "includePromotedContent": False, "withSuperFollowsUserFields": False, "withBirdwatchPivots": False,
            "withDownvotePerspective": False, "withReactionsMetadata": False,
             "withReactionsPerspective": False, "withSuperFollowsTweetFields": False, "withVoice": False, "withV2Timeline": False,
    }
    get_reply_param = param = {"variables": json.dumps(get_reply_vars), "features": FeaturesJson}
    replies = None

    try:
        replies = twitter_b.get("https://x.com/i/api/graphql/{}/{}".format(ENDPOINT["UserTweetsAndReplies"], "UserTweetsAndReplies"), params=get_reply_param)
        ghostban = True
        ghostTweetId = None
        ghostReplyId = None
        showmore = False
        showmoreTweetId = None
        showmoreReplyId = None
        repliesJson = replies.json()
        maindata = repliesJson["data"]["user"]["result"]["timeline"]["timeline"]["instructions"]
        checkedTweets = set()
        for d in maindata:
            if not ghostban:
                # all checks done
                break
            if d["type"] == "TimelineAddEntries":
                for ent in d["entries"]:
                    if not ghostban:
                        # all checks done
                        break
                    if ent["entryId"].startswith("tweet") and "legacy" in ent["content"]["itemContent"]["tweet_results"]["result"]:
                        tmp = ent["content"]["itemContent"]["tweet_results"]["result"]["legacy"]
                        if "in_reply_to_status_id_str" in tmp and tmp["in_reply_to_status_id_str"] not in checkedTweets:
                            reply = tmp
                            tweetId = reply["in_reply_to_status_id_str"]
                            checkedTweets.add(tweetId)
                            if ghostTweetId is None:
                                ghostTweetId = tweetId
                                ghostReplyId = reply["id_str"]
                            if showmoreTweetId is None:
                                showmoreTweetId = tweetId
                                showmoreReplyId = reply["id_str"]
                            tweet_detail_vars = {
                                "focalTweetId": tweetId,
                                "includePromotedContent":False,
                                "withBirdwatchNotes":False,
                                "withSuperFollowsUserFields":False,
                                "withDownvotePerspective":False,
                                "withReactionsMetadata":False,
                                "withReactionsPerspective":False,
                                "withSuperFollowsTweetFields":False,
                                "withVoice":False,
                            }
                            tweetdetails = twitter_b.get("https://x.com/i/api/graphql/{}/{}".format(ENDPOINT["TweetDetail"], "TweetDetail"), params={"variables": json.dumps(tweet_detail_vars), "features": FeaturesJson})
                            tweetData = tweetdetails.json()["data"]
                            if "threaded_conversation_with_injections" not in tweetData:
                                continue
                            insts = tweetdetails.json()["data"]["threaded_conversation_with_injections"]["instructions"]
                            for inst in insts:
                                if not ghostban:
                                    # all checks done
                                    break
                                if inst["type"] == "TimelineAddEntries":
                                    for ent in inst["entries"]:
                                        if not ghostban:
                                            # all checks done
                                            break
                                        print("Current entry of {} is: {}".format(screen_name, ent["entryId"]))
                                        if ent["entryId"].startswith("conversationthread") and ghostban:
                                            for item in ent["content"]["items"]:
                                                if "tweet_results" in item["item"]["itemContent"] and "legacy" in item["item"]["itemContent"]["tweet_results"]["result"] and item["item"]["itemContent"]["tweet_results"]["result"]["legacy"]["user_id_str"] == user_id:
                                                    replyId = item["item"]["itemContent"]["tweet_results"]["result"]["legacy"]["id_str"]
                                                    returnjson["tests"]["ghost"] = {"ban": False, "tweet": tweetId, "in_reply_to": replyId}
                                                    ghostban = False
                                                    print("Found valid reply {} => {}, so {} is not ghost banned.".format(tweetId, replyId, screen_name))
                                                    break
                                        if ent["entryId"].startswith("cursor-showmorethreadsprompt") and not showmore:
                                            # showmore = True
                                            cursor_vars = tweet_detail_vars
                                            cursor_vars["cursor"] = ent["content"]["itemContent"]["value"]
                                            cursor = twitter_b.get("https://x.com/i/api/graphql/{}/{}".format(ENDPOINT["TweetDetail"], "TweetDetail"), params={"variables": json.dumps(cursor_vars), "features": FeaturesJson})

                                            cursor_insts = cursor.json()["data"]["threaded_conversation_with_injections"]["instructions"]
                                            for c_i in cursor_insts:
                                                if c_i["type"] == "TimelineAddEntries":
                                                    if len(c_i["entries"]) == 0:
                                                        returnjson["tests"]["more_replies"] = {"ban": True}
                                                        showmore = True
                                                        break
                                                    for c_ent in c_i["entries"]:
                                                        if c_ent["entryId"].startswith("conversationthread"):
                                                            print("Checking more contents of {} by {}".format(tweetId, screen_name))
                                                            for c_item in c_ent["content"]["items"]:
                                                                if "legacy" in c_item["item"]["itemContent"]["tweet_results"]["result"] and c_item["item"]["itemContent"]["tweet_results"]["result"]["legacy"]["user_id_str"] == user_id:
                                                                    replyId = c_item["item"]["itemContent"]["tweet_results"]["result"]["legacy"]["id_str"]
                                                                    returnjson["tests"]["more_replies"] = {"ban": True, "in_reply_to": replyId, "tweet": tweetId}
                                                                    print("{} is reply deboosted because of {} => {}.".format(screen_name, tweetId, replyId))
                                                                    showmore = True
                                                                    break
        if len(checkedTweets) > 0:
            if ghostban:
                print("{} is ghost banned.".format(screen_name))
                returnjson["tests"]["ghost"] = {
                    "ban": True,
                    "tweet": ghostTweetId,
                    "in_reply_to": ghostReplyId
                }
            if not showmore:
                print("{} is not reply deboosted.".format(screen_name))
                returnjson["tests"]["more_replies"] = {
                    "ban": False,
                    "in_reply_to": showmoreReplyId,
                    "tweet": showmoreTweetId
                }
            # No search ban || more replies => No ghost ban
            #if returnjson["tests"]["search"] and returnjson["tests"]["search"] != "_error" and "ban" in returnjson["tests"]["ghost"] and returnjson["tests"]["ghost"]["ban"] == True or "ban" in returnjson["tests"]["more_replies"] and returnjson["tests"]["more_replies"]["ban"] == True:
            #    returnjson["tests"]["ghost"] = {
            #        "ban": False,
            #        "tweet": ghostTweetId,
            #        "in_reply_to": ghostReplyId
            #    }

            # No ghost ban && unknown more replies => No more replies ban
            if "ban" not in returnjson["tests"]["more_replies"] and "ban" in returnjson["tests"]["ghost"] and returnjson["tests"]["ghost"]["ban"] == False:
                returnjson["tests"]["more_replies"] = {
                    "ban": False,
                    "in_reply_to": showmoreReplyId,
                    "tweet": showmoreTweetId
                }
        else:
            print("No replies found for {}.".format(screen_name))
            returnjson["tests"]["ghost"] = {}
            returnjson["tests"]["more_replies"] = {}
    except KeyError as e:
        print("Errored testing {}".format(screen_name))
        print(e)
        if replies is not None:
            print("Response: " + replies.text)
        returnjson["tests"]["ghost"] = {}
        returnjson["tests"]["more_replies"] = {}
        hasFailure = True


    #print("ban" in returnjson["tests"]["more_replies"])
    #print("ban" in returnjson["tests"]["ghost"])
    #print(returnjson["tests"]["ghost"])

    plainJson = json.dumps(returnjson)

    print("Result of {}: {}".format(screen_name, plainJson))
    if redisClient and not hasFailure:
        redisClient.set("shadowban:{}".format(screen_name), plainJson, ex=600)
    return returnjson

if __name__ == '__main__':
    if os.getenv('CHECK_COOKIE'):
        good, bad = checkCookies()
        #print("Good cookies:")
        for g in good:
            print(g)
        #print("Bad cookies:")
        #for b in bad:
        #    print(b)
        # quit
    else:
        app.run(debug=True, port=os.environ.get("PORT", 5000), host="0.0.0.0")
