import { Injectable } from '@nestjs/common';
import { CrudBase } from '../crud-base/crud-base';
import { RankRecord } from '../entities/rank-record.entity';
import { InjectRepository } from '@nestjs/typeorm';
import { Session } from 'koishi';
import moment from 'moment';
import { IsNull, MoreThanOrEqual } from 'typeorm';

@Injectable()
export class RecordService extends CrudBase<RankRecord> {
  constructor(@InjectRepository(RankRecord) repo) {
    super(RankRecord, repo);
  }

  async isCanGiveRecord(session: Session) {
    const previous = await this.repo.findOne({
      select: ['id'],
      where: {
        userId: session.userId,
        guildId: session.guildId,
        operatorId: IsNull(),
        rankDate: MoreThanOrEqual(moment().subtract(2, 'hours').toDate()),
      },
    });
    return !previous;
  }

  async recordGiven(session: Session, content: string, targetId?: string) {
    const record = new RankRecord().fromSession(session, targetId);
    record.rankName = content;
    try {
      await this.create(record);
      return true;
    } catch (e) {
      return false;
    }
  }
}
