"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
exports.__esModule = true;
exports.RankRecord = void 0;
var openapi = require("@nestjs/swagger");
var typeorm_1 = require("typeorm");
var IdBase_entity_1 = require("./bases/IdBase.entity");
var base_1 = require("./decorators/base");
var class_validator_1 = require("class-validator");
var swagger_1 = require("@nestjs/swagger");
var query_1 = require("./utility/query");
var RankRecord = /** @class */ (function (_super) {
    __extends(RankRecord, _super);
    function RankRecord() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    RankRecord.prototype.fromSession = function (session) {
        this.userId = session.userId;
        this.guildId = session.guildId;
        this.rankDate = new Date();
        return this;
    };
    RankRecord.prototype.applyQuery = function (qb, entityName) {
        _super.prototype.applyQuery.call(this, qb, entityName);
        (0, query_1.applyQueryProperty)(this, qb, entityName, 'userId', 'guildId', 'rankDate');
        (0, query_1.applyQueryPropertySearch)(this, qb, entityName, 'rankName');
    };
    RankRecord._OPENAPI_METADATA_FACTORY = function () {
        return { userId: { required: true, type: function () { return String; } }, guildId: { required: true, type: function () { return String; } }, rankDate: { required: true, type: function () { return Date; } }, rankName: { required: true, type: function () { return String; } } };
    };
    __decorate([
        (0, typeorm_1.Index)(),
        (0, base_1.StringColumn)(11, 'User ID', undefined, true)
    ], RankRecord.prototype, "userId");
    __decorate([
        (0, typeorm_1.Index)(),
        (0, base_1.StringColumn)(11, 'Guild ID', undefined, true)
    ], RankRecord.prototype, "guildId");
    __decorate([
        (0, typeorm_1.Index)(),
        (0, typeorm_1.Column)({ type: 'timestamp' }),
        (0, class_validator_1.IsDate)(),
        (0, swagger_1.ApiProperty)({ type: Date, description: 'The date of the rank given' })
    ], RankRecord.prototype, "rankDate");
    __decorate([
        (0, typeorm_1.Index)(),
        (0, base_1.StringColumn)(6, 'Rank content', undefined, true)
    ], RankRecord.prototype, "rankName");
    RankRecord = __decorate([
        (0, typeorm_1.Entity)()
    ], RankRecord);
    return RankRecord;
}(IdBase_entity_1.IdBase));
exports.RankRecord = RankRecord;
