import { Column } from 'typeorm';
import { MergePropertyDecorators } from './base';
import { ApiProperty, ApiPropertyOptions } from '@nestjs/swagger';
import { IsInt, IsNotEmpty, IsOptional, IsPositive } from 'class-validator';
import { BigintTransformer } from '../utility/bigint-transform';
import { ColumnCommonOptions } from 'typeorm/decorator/options/ColumnCommonOptions';
import { ColumnWithLengthOptions } from 'typeorm/decorator/options/ColumnWithLengthOptions';
import { ColumnWithWidthOptions } from 'typeorm/decorator/options/ColumnWithWidthOptions';

export const RelationColumn = (
  description = '对应编号',
  notNull = false,
  columnExtras: ColumnCommonOptions & ColumnWithWidthOptions = {},
  propertyExtras: ApiPropertyOptions = {},
) =>
  MergePropertyDecorators([
    Column('bigint', {
      nullable: !notNull,
      unsigned: true,
      transformer: new BigintTransformer(),
      comment: description,
      ...columnExtras,
    }),
    ApiProperty({
      type: Number,
      description,
      required: notNull,
      ...propertyExtras,
    }),
    ...(notNull ? [] : [IsOptional()]),
    IsInt(),
    IsPositive(),
  ]);
export const StringRelationColumn = (
  description = '对应编号',
  notNull = false,
  columnExtras: ColumnCommonOptions & ColumnWithLengthOptions = {},
  propertyExtras: ApiPropertyOptions = {},
) =>
  MergePropertyDecorators([
    Column('varchar', {
      length: 32,
      nullable: !notNull,
      comment: description,
      ...columnExtras,
    }),
    ApiProperty({
      type: String,
      required: notNull,
      description,
      ...propertyExtras,
    }),
    ...(notNull ? [] : [IsOptional()]),
    IsNotEmpty(),
  ]);
