"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
exports.__esModule = true;
exports.StringRelationColumn = exports.RelationColumn = void 0;
var typeorm_1 = require("typeorm");
var base_1 = require("./base");
var swagger_1 = require("@nestjs/swagger");
var class_validator_1 = require("class-validator");
var bigint_transform_1 = require("../utility/bigint-transform");
var RelationColumn = function (description, notNull, columnExtras, propertyExtras) {
    if (description === void 0) { description = '对应编号'; }
    if (notNull === void 0) { notNull = false; }
    if (columnExtras === void 0) { columnExtras = {}; }
    if (propertyExtras === void 0) { propertyExtras = {}; }
    return (0, base_1.MergePropertyDecorators)(__spreadArray(__spreadArray([
        (0, typeorm_1.Column)('bigint', __assign({ nullable: !notNull, unsigned: true, transformer: new bigint_transform_1.BigintTransformer(), comment: description }, columnExtras)),
        (0, swagger_1.ApiProperty)(__assign({ type: Number, description: description, required: notNull }, propertyExtras))
    ], (notNull ? [] : [(0, class_validator_1.IsOptional)()]), true), [
        (0, class_validator_1.IsInt)(),
        (0, class_validator_1.IsPositive)(),
    ], false));
};
exports.RelationColumn = RelationColumn;
var StringRelationColumn = function (description, notNull, columnExtras, propertyExtras) {
    if (description === void 0) { description = '对应编号'; }
    if (notNull === void 0) { notNull = false; }
    if (columnExtras === void 0) { columnExtras = {}; }
    if (propertyExtras === void 0) { propertyExtras = {}; }
    return (0, base_1.MergePropertyDecorators)(__spreadArray(__spreadArray([
        (0, typeorm_1.Column)('varchar', __assign({ length: 32, nullable: !notNull, comment: description }, columnExtras)),
        (0, swagger_1.ApiProperty)(__assign({ type: String, required: notNull, description: description }, propertyExtras))
    ], (notNull ? [] : [(0, class_validator_1.IsOptional)()]), true), [
        (0, class_validator_1.IsNotEmpty)(),
    ], false));
};
exports.StringRelationColumn = StringRelationColumn;
