"use strict";
exports.__esModule = true;
exports.EntityDescription = exports.EntityName = void 0;
var base_1 = require("./base");
var typeorm_1 = require("typeorm");
var EntityName = function (length, description) {
    if (length === void 0) { length = 32; }
    if (description === void 0) { description = '名称'; }
    return (0, base_1.MergePropertyDecorators)([
        (0, typeorm_1.Index)(),
        (0, base_1.StringColumn)(length, description, undefined, true),
    ]);
};
exports.EntityName = EntityName;
var EntityDescription = function (length, description) {
    if (length === void 0) { length = 5000; }
    if (description === void 0) { description = '描述'; }
    return (0, base_1.StringColumn)(length, description, '', false);
};
exports.EntityDescription = EntityDescription;
